<?php
#############################################################
# Project:      bCounter                                    #
# File:         index.php                                   #
# Decription:   main bCounter display file
#                                                           #
# Copyright (c) Alexander Bondar (http://bondar.de/)        #
#############################################################

    session_start();
    $iStarttime = microtime(TRUE);
    require_once("./inc/inc.php");  # include all needed files and settings
    $strTitle = '';
    $strLoad = "stats";             # default module to load

    if ( isset( $_POST["login-name"], $_POST["login-pw"] ) ) {
    # login data sent
        $bCounterUser->signin( $_POST["login-name"], $_POST["login-pw"] );
    }elseif( isset( $_POST["user-logout"] ) && $_POST["user-logout"] === "logout" ) {
    # logout
        $bCounterUser->signout();
    }


    if ( $bCounterUser->is_signed_in() ) {
    # only after login
        if ( isset($_GET["load"]) && is_file("./inc/".$_GET["load"].".php") ) {
            $strLoad = $_GET["load"];
        }
    }else{
    # user not loged in
        $strLoad = "login";
    }
    $strDivNav2 = "";
    require_once("./inc/".$strLoad.".php"); # include needed module

    # force to reload the page by every visit
    header("Expires: Mon, 14 Jul 2008 21:33:33 GMT");
?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <title><?php echo 'bCounter'.$strTitle; ?></title>
        <style type="text/css">@import url("./bCounter.css");
        </style>
    </head>
    <body>
<?php
    echo '<div>'."\n";
    echo '<h1><img src="./img/logo.png" width="37" height="20" alt="bCounter - Logo" /> bCounter <span>'.$strTitle.'</span></h1>';
    require_once("./inc/core/nav.php");
?>
        <div class="clear"></div>
<?php
    if ( strlen($strDivNav2) > 0 ) {
        echo '<div class="nav2">'.$strDivNav2.'</div>
        <div class="clear"></div>';
    }
    if ( strlen($strDivNav3) > 0 ) {
        echo '<div class="nav3">'.$strDivNav3.'</div>
        <div class="clear"></div>';
    }
    echo $strDivBody;
    if ( strlen($strDivNav3) > 0 ) {
        echo '<div class="nav3">'.$strDivNav3.'</div>
        <div class="clear"></div>';
    }
    echo '</div>'."\n";

    $iEndtime = microtime(TRUE);
    $fDiff = $iEndtime - $iStarttime + 0;
    $strDiff = number_format( $fDiff, 3, ",", "." );
?>
        <div class="clear"></div>
        <div id="footer">&copy; 2008&mdash;2009 <a href="http://bcounter.bondar.de/" target="_blank">bCounter</a> v<?php echo $bCounter_version; ?><br />
<?php echo "Generiert in ".$strDiff." sec."; ?>
        </div>
    </body>
</html>