<?php
#############################################################
# Project:      bCounter                                    #
# File:         install.php                                 #
# Decription:   easy instalation file
#                                                           #
# Copyright (c) Alexander Bondar (http://bondar.de/)        #
#############################################################

    $iStarttime = microtime(TRUE);
    header("Expires: Mon, 14 Jul 2008 21:33:33 GMT"); // force to reload the page by every visit
    echo '<!DOCTYPE html>'."\n";

    require_once("./inc/inc.php");

    $strTitle = '';
    $strLoad = "step1";


    if ( isset($_POST["load"]) && ( $_POST["load"] == "step2" || $_POST["load"] == "step3" ) ) {
        $strLoad = $_POST["load"];
    }
    $strDivNav2 = "";
?>
<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <title><?php echo 'bCounter'.$strTitle; ?></title>
        <style type="text/css">@import url("./bCounter.css");
        </style>
    </head>
    <body>
<?php
    echo '<div>'."\n";
    echo '<h1>bCounter <span>| Installation</span></h1>';
    @require_once("./inc/core/nav.php");
?>
        <div class="clear"></div>
<?php
    if ( strlen($strDivNav2) > 0 ) {
        echo '<div class="nav2">'.$strDivNav2.'</div>
        <div class="clear"></div>';
    }

    switch ( $strLoad ) {
        case "step1":
            echo '<h2>Willkommen im Installationsassistenten von bCounter!</h2>';

            echo '<h2>Datenbankstatus</h2>';
            if ( $bCounter_dbDatabase != "" && $bCounter_dbUser != "" && $bCounter_dbPassword != "" || false ) {
                echo '
<div class="table">
<p>Zugangsdaten: <span class="success"><b>vorhanden</b></span>.</p>
<p>Datenbankserver: '.$bCounter_dbServer.'<br />
Datenbankname: '.$bCounter_dbDatabase.'<br />
Datenbankbenutzer: '.$bCounter_dbUser.'<br />
Datenbankpasswort: <em>vorhanden</em></p>
<p>Pr&auml;fix: '.( (strlen($bCounter_dbPrefix)>0)?$bCounter_dbPrefix:"<em>kein Pr&auml;fix</em>" ).'</p>
</div>
';

                echo '<h2>bCounter-Benutzer</h2>';
                if ( isset($bCounter_users) && is_array($bCounter_users) && is_array($bCounter_users[0]) && strlen($bCounter_users[0]["pw_hash"]) == 32 ) {
                    echo '
<div class="table">
<p>Zugangsdaten: <span class="success"><b>vorhanden</b></span>.</p>
</div>
';

####################################################################################################

                    echo '<h2>Optionen</h2>';
                    echo '
<div class="table">
<p>Jetzt k&ouml;nnen die bCounter-Tabellen in der Datenbank angelegt werden. Bitte w&auml;hlen Sie zus&auml;tzliche Optionen:</p>
<form action="install.php" method="post">
<input type="hidden" name="load" value="step2" />
<p><label for="rebuild-iplist"><input type="checkbox" name="rebuild-iplist" id="rebuild-iplist" /> IP-Liste neu erstellen (zu empfehlen bei Upgrades). ';

                    echo 'Datei <b>ip-to-country.csv</b>: ';
                    if ( is_file("ip-to-country.csv") ) {
                        echo '<span class="success">gefunden</span>';

                    }else{
                        echo '<span class="error">nicht gefunden</span>';
                    }
                    echo '.</label></p>';

                    echo '
<p><input type="submit" class="button" value="Installation starten" /></p>
</form>

</div>
';
                }else{
                    echo '
<div class="table">
<p>Zugangsdaten: <span class="error"><b>nicht vorhanden</b></span>.</p>
<p>Zum Fortfahren speichern Sie bitte die Zugangsdaten f&uuml;r mindestens einen Benutzer in der Datei <b>settings.php</b> (Variable <b>$bCounter_users</b>).
</div>
';
                }
            }else{
                echo '<div class="table">';
                echo '<p>Zugangsdaten: <span class="error"><b>nicht vorhanden</b></span>.</p>';
                echo '<p>Zum Fortfahren speichern Sie bitte die Zugangsdaten f&uuml;r Ihre Datenbank in der Datei <b>settings.php</b>.</p>';
                echo '</div>';
            }
            break;
        case "step2":
            echo '<h2>bCounter-Installation</h2>';

            echo '<div class="table">';
            echo '<h3>MySQL-Tabellen</h3><p>Tabellen werden angelegt, wenn nicht vorhanden.</p>';


$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."data (
  ID bigint(20) unsigned NOT NULL auto_increment,
  redirect_status int(3) unsigned NOT NULL default '0',
  user_agent text NOT NULL,
  remote_addr varchar(15) NOT NULL default '',
  host varchar(255) NOT NULL default '',
  redirect_url text NOT NULL,
  request_uri text NOT NULL,
  `timestamp` int(11) NOT NULL default '0',
  referer text NOT NULL,
  PRIMARY KEY  (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 PACK_KEYS=1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'data</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>';
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."iplist (
  IP_from int(10) unsigned NOT NULL default '0',
  IP_to int(10) unsigned NOT NULL default '0',
  alpha2 char(2) NOT NULL,
  alpha3 char(3) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'iplist</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>';
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."referer (
  ID int(11) NOT NULL auto_increment,
  `timestamp` int(11) NOT NULL,
  host varchar(256) NOT NULL,
  path varchar(256) NOT NULL,
  `query` varchar(256) NOT NULL,
  PRIMARY KEY  (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'referer</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>';
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."suchbegriffe (
  ID int(11) NOT NULL auto_increment,
  `timestamp` int(11) NOT NULL,
  suchbegriff varchar(256) NOT NULL,
  PRIMARY KEY  (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'suchbegriffe</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>';
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."visits (
  ID int(10) unsigned NOT NULL auto_increment,
  IP varchar(15) NOT NULL,
  first_seen int(10) unsigned NOT NULL,
  last_seen int(10) unsigned NOT NULL,
  os varchar(20) NOT NULL,
  os_version varchar(30) NOT NULL,
  browser varchar(20) NOT NULL,
  browser_version varchar(30) NOT NULL,
  `type` ENUM('human', 'bot', 'lib', 'fake', 'downloader', 'spam' ) NOT NULL,
  alpha2 varchar(2) NOT NULL,
  top_host varchar(50) NOT NULL,
  PRIMARY KEY  (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
";

            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'visits</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>: '.mysql_error();
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."visits_per_day (
  ID int(10) unsigned NOT NULL auto_increment,
  `week` int(6) unsigned NOT NULL,
  mo int(10) unsigned NOT NULL default '0',
  tu int(10) unsigned NOT NULL default '0',
  we int(10) unsigned NOT NULL default '0',
  th int(10) unsigned NOT NULL default '0',
  fr int(10) unsigned NOT NULL default '0',
  sa int(10) unsigned NOT NULL default '0',
  su int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'visits_per_day</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>';
            }
            echo '</p>';

$strSQLstring = "
CREATE TABLE IF NOT EXISTS ".$bCounter_dbPrefix."login_log (
   `ID` bigint(20) unsigned not null auto_increment,
   `uID` int(10) unsigned not null,
   `sID` varchar(32) not null,
   `timestamp` timestamp not null default CURRENT_TIMESTAMP,
   PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
";
            echo '<p>Tabelle <b>'.$bCounter_dbPrefix.'login_log</b>: ';
            if ( $bCounterDB->query($strSQLstring) ) {
                echo '<b class="green">erfolgreich</b>';
            }else{
                echo '<b class="red">Fehler</b>'.mysql_error();
            }
            echo '</p>';

            echo '<h3>IP-Liste neu erstellen</h3>';
            if ( isset($_POST["rebuild-iplist"]) ) {
                @set_time_limit(0); # make it run unlimited (doesn't work in safe mode)
                $handle = @fopen("ip-to-country.csv", "r");
                echo '<p>Datei <b>ip-to-country.csv</b>: ';
                if ( $handle != false ) {
                    echo '<span class="success">vorhanden</span>.</p>';
                    $strSQLstring = "TRUNCATE ".$bCounter_dbPrefix."iplist";

                    echo '<p> Tabelle <b>'.$bCounter_dbPrefix.'iplist</b> leeren:';
                    if ( $bCounterDB->query($strSQLstring) ) {
                        echo '<span class="success">erfolgreich</span></p>';
                        # Schleife fr jede Zeile der Datei durchlaufen:
                        while ($zeile = fgetcsv($handle, 1024, ',', '"')) {
                            $sql = "INSERT INTO ".$bCounter_dbPrefix."iplist VALUES('".$zeile[0]."', '".$zeile[1]."', '".$zeile[2]."', '".$zeile[3]."', '".$zeile[4]."');";
                            $bCounterDB->query($sql);
                        }
                        echo '<p>Datenimport abgeschlossen.</p>';
                        # CSV-Datei schlieen:
                        fclose($handle);
                    }else{
                        echo '<span class="error">fehlgeschlagen</span>: '.mysql_error().'</p>';
                    }
                }else{
                    echo '<span class="error">nicht vorhanden</span>.</p>';
                }
            }else{
                echo '<p><span class="error">Nicht erw&uuml;nscht.</span></p>';
            }

            echo '</div>';

            echo '<h2>Fertig!</h2>';
            echo '<div class="table">';
            echo '<p><a href="./">Zum bCounter</a></p>';
            echo '</div>';

            break;
    }
    echo '</div>'."\n";
    $iEndtime = microtime(TRUE);
    $fDiff = $iEndtime - $iStarttime + 0;
    $strDiff = number_format( $fDiff, 3, ",", "." );
?>
        <div class="clear"></div>
        <div id="footer">&copy; 2008&mdash;2009 <a href="http://bcounter.bondar.de/" target="_blank">bCounter</a> v<?php echo $bCounter_version; ?><br />
<?php echo "Generiert in ".$strDiff." sec."; ?>
        </div>
    </body>
</html>