<?php
#############################################################
# Project:      bCounter                                    #
# File:         class.bcounter.php                          #
# Decription:   bCounter class file
#                                                           #
# Copyright (c) Alexander Bondar (http://bondar.de/)        #
#############################################################

class bCounter
{
    function bCounter() {}

    function get_nav_pages ( $iCurrentPage, $iEntriesPerPage, $iEntriesTotal, $strLoad, $iPrevNextPages = 5 ) {
        $strReturn = "";
        $bDottesBeforePrinted = false;
        $bDottesAfterPrinted  = false;
        $iPagesTotal = floor($iEntriesTotal/$iEntriesPerPage)+1;

        $strReturn .= '<ul>';
        $strReturn .= '<li><a class="info">Seiten:</a></li>';
        $page = 0;
        for ( $i = 0; $i <= $iEntriesTotal; $i = $i + $iEntriesPerPage ) {
            $page++;
            if (
                $page == 1 || $page == $iCurrentPage || $page == $iPagesTotal
                || ( max($iCurrentPage-$page, 0) > 0 && max($iCurrentPage-$page, 0) <= $iPrevNextPages )
                || ( max($page-$iCurrentPage, 0) > 0 && max($page-$iCurrentPage, 0) <= $iPrevNextPages )
            ) {
                $strReturn .= '<li><a href="./?load='.$strLoad.'&amp;eps='.$iEntriesPerPage.'&amp;page='.$page.'"';
                if ( $page == $iCurrentPage ) {
                    $strReturn .= ' class="current"';
                }
                $strReturn .= '>&nbsp;'.$page.'&nbsp;</a></li>';
            }elseif( !$bDottesBeforePrinted && $page > 1 && $page < $iCurrentPage ){
                $strReturn .= '<li><a class="info">&hellip;</a></li>';
                $bDottesBeforePrinted = true;
            }elseif( !$bDottesAfterPrinted && $page < $iPagesTotal && $page > $iCurrentPage ){
                $strReturn .= '<li><a class="info">&hellip;</a></li>';
                $bDottesAfterPrinted = true;
            }
        }
        $strReturn .= '<li><a class="info">('.$iEntriesPerPage.' Eintr&auml;ge pro Seite)</a></li>';
        $strReturn .= '</ul>';
        $strReturn .= '<div class="clear"></div>';

        return $strReturn;
    }

    function get_graph_name( $strType, $arrVars = array() ) {
        global $bCounter_bUseModRewrite;
        $strReturn = "";

        if ( $bCounter_bUseModRewrite ) {
            $strReturn .= "diagramm_".$strType;
            foreach ( $arrVars as $var ) {
                $strReturn .= "-$var";
            }
            $strReturn .= ".png";
        }else{
            $strReturn .= "diagramm.php?type=".$strType;
            $i = 1;
            foreach ( $arrVars as $var ) {
                $strReturn .= "&input$i=$var";
                $i++;
            }
            
        }
        return $strReturn;
    }
}
?>