<?php
/**
 * Filename:       includes/lang/francais.inc.php
 * Function:       French language file for MODx
 * Encoding:       ISO-8859-1 (Latin 1)
 * Author:         Nicolas Martignoni (Nissai), révisé par David Mollière pour la 0.9.6 (davidm)
 * Date:           2007/05/02
 * Version:        2.2
 * MODx version:   0.9.6
*/
// NOTE: Now alpha-sorted

setlocale (LC_ALL, 'fr_FR');

include_once(dirname(__FILE__).'/english.inc.php'); // fall back to English defaults if needed

$_lang["about_msg"] = 'MODx a été développé à partir d\'Etomite. Il est placé sous licence <a href="../assets/docs/license.txt\">GPL</a>.';
$_lang["about_title"] = 'À propos de MODx';
$_lang["access_permissions"] = 'Autorisations d\'accès';
$_lang["access_permissions_add_document_group"] = 'Nouveau groupe de documents';
$_lang["access_permissions_add_user_group"] = 'Nouveau groupe d\'utilisateurs';
$_lang["access_permissions_docs_message"] = 'Cocher ci-dessous les groupes de documents auxquels ce document doit appartenir';
$_lang["access_permissions_documents_in_group"] = '<strong>Documents dans le groupe :</strong> ';
$_lang["access_permissions_documents_tab"] = 'Les groupes de documents actuels sont affichés ci-dessous. Vous pouvez en créer de nouveaux, les renommer, les supprimer et voir quels documents sont membres des différents groupes (le survol par le pointeur du numéro du document en affichera le nom). Pour ajouter un document à un groupe ou pour l\'en retirer, modifiez directement le document.';
$_lang["access_permissions_document_groups"] = 'Groupes de documents';
$_lang["access_permissions_introtext"] = 'Cette section vous permet de gérer les groupes d\'utilisateurs et les groupes de documents utilisés pour les autorisations d\'accès. Pour ajouter un utilisateur à un groupe d\'utilisateurs, modifier l\'utilisateur et cocher les groupes auxquels il doit appartenir. Pour ajouter un document à un groupe d\'utilisateurs, modifier le document et cocher les groupes auxquels il doit appartenir.';
$_lang["access_permissions_links"] = 'Liens groupes d\'utilisateurs/de documents ';
$_lang["access_permissions_links_tab"] = 'Le tableau ci-dessous indique les groupes d\'utilisateurs ayant accès (c\'est-à-dire pouvant modifier ou créer des enfants) à des groupes de document. Pour lier un groupe de documents à un groupe d\'utilisateurs, choisissez le groupe à partir du menu déroulant, et cliquez sur le «Ajouter le groupe». Pour retirer un groupe, cliquez sur «Retirer ->». Le lien sera immédiatement supprimé.';
$_lang["access_permissions_no_documents_in_group"] = 'Néant.';
$_lang["access_permissions_no_users_in_group"] = 'Néant.';
$_lang["access_permissions_off"] = '<span class="warning">Les autorisations d\'accès ne sont pas activées.</span> Les modifications faites ici n\'auront aucun effet jusqu\'à ce que les autorisations d\'accès soient activées.';
$_lang["access_permissions_users_in_group"] = '<strong>Utilisateurs dans le groupe :</strong> ';
$_lang["access_permissions_users_tab"] = 'Les groupes d\'utilisateurs actuels sont affichés ci-dessous. Vous pouvez en créer de nouveaux, les renommer, les supprimer et voir quels utilisateurs sont membres des différents groupes. Pour ajouter un nouvel utilisateur à un groupe ou pour l\'en retirer, modifiez directement l\'utilisateur. Les administrateurs ont toujours accès à tous les documents. Ils n\'est donc pas nécessaire de les ajouter à aucun groupe.';
$_lang["access_permissions_user_group"] = 'Groupe d\'utilisateurs';
$_lang["access_permissions_user_groups"] = 'Groupes d\'utilisateurs';
$_lang["access_permissions_user_group_access"] = 'Groupes de documents auxquels le groupe d\'utilisateurs a accès :';
$_lang["access_permissions_user_message"] = 'Vous pouvez choisir ici les groupes d\'utilisateurs auxquels cet utilisateur appartient';
$_lang["access_permission_denied"] = 'Vous n\'avez pas les autorisations nécessaires pour modifier ce document.';
$_lang["access_permission_parent_denied"] = 'Vous n\'avez pas l\'autorisation de créer ou de déplacer un document ici !';
$_lang["account_email"] = 'Email du compte utilisateur';
$_lang["actioncomplete"] = '<strong>l\'action a été accomplie avec succès&nbsp;!</strong><br /> - Veuillez patienter un instant.';
$_lang["activity_message"] = 'Cette liste contient les documents que vous avez modifiés ou créés récemment&nbsp;:';
$_lang["activity_title"] = 'Documents récents';
$_lang["add"] = 'Ajouter';
$_lang["add_chunk"] = 'Ajouter un chunk';
$_lang["add_doc"] = 'Ajouter un document';
$_lang["add_document"] = 'Nouveau document';
$_lang["add_folder"] = 'Nouveau dossier';
$_lang["add_plugin"] = 'Ajouter un plugin';
$_lang["add_snippet"] = 'Ajouter un snippet';
$_lang["add_tag"] = 'Ajouter balise';
$_lang["add_template"] = 'Ajouter un modèle';
$_lang["add_tv"] = 'Ajouter une variable de modèle';
$_lang["add_weblink"] = 'Nouveau lien';
$_lang["administrator_role_message"] = 'Ce rôle ne peut être ni modifié, ni supprimé.';
$_lang["after_saving"] = 'After saving';
$_lang["alert_delete_self"] = 'Vous ne pouvez pas supprimer votre propre compte !';
$_lang["alias"] = 'Alias';
$_lang["allow_mgr_access"] = 'Accès à l\'interface du gestionnaire';
$_lang["allow_mgr_access_message"] = 'Sélectionnez cette option pour permettre ou non l\'accès à l\'interface du gestionnaire.<br /><strong>ATTENTION ! Si vous avez désactivé cette option, l\'utilisateur sera dirigé automatiquement vers la page de connexion au gestionnaire ou vers la page d\'accueil du site web.</strong>';
$_lang["all_doc_groups"] = 'Tous les groupes de documents (Public)';
$_lang["all_events"] = 'Tous les évènements';
$_lang["all_usr_groups"] = 'Tous les groupes (Public)';
$_lang["already_deleted"] = 'a déjà été supprimé.';
$_lang["attachment"] = 'Annexe';
$_lang["automatic_alias_message"] = 'Une fois activé, le gestionnaire générera automatiquement un alias à partir du titre de la page lors de son enregistrement.';
$_lang["automatic_alias_title"] = 'Générer automatiquement les alias :';
$_lang["backup"] = 'Sauvegarde';
$_lang["bk_manager"] = 'Gestion des sauvegardes';
$_lang["blocked_minutes_message"] = 'Vous pouvez saisir ici le nombre de minutes durant lesquelles un utilisateur sera bloqué s\'il atteint le nombre maximum de tentative de login. Attention de ne saisir qu\'une valeur numérique (pas de virgule, d\'espace...etc)';
$_lang["blocked_minutes_title"] = 'Durée de blocage (en minutes):';
$_lang["block_message"] = 'Une fois ces données enregistrées, cet utilisateur sera bloqué !';
$_lang["cache_files_deleted"] = 'Les fichiers suivants ont été supprimés :';
$_lang["cancel"] = 'Annuler';
$_lang["captcha_code"] = 'Code de sécurité';
$_lang["captcha_message"] = 'Activer les codes CAPTCHA permet de renforcer la sécurité en exigeant des utilisateurs d\'écrire un code illisible par des machines (automates).';
$_lang["captcha_title"] = 'Utiliser les codes CAPTCHA :';
$_lang["captcha_words_message"] = 'Vous pouvez ici taper une liste de mots à utiliser si CAPTCHA est activé. Séparez les mots par des virgules. Ce champ est limité à 255 caractères.';
$_lang["captcha_words_title"] = 'Mots CAPTCHA';
$_lang["category_heading"] = 'Catégorie';
$_lang["category_msg"] = 'Vous pouvez voir ici toutes les ressources groupées par catégorie.';
$_lang["change_name"] = 'Modifier le nom';
$_lang["change_password"] = 'Changer mot de passe';
$_lang["change_password_confirm"] = 'Retaper le mot de passe ';
$_lang["change_password_message"] = 'Veuillez taper votre nouveau mot de passe, puis le retaper pour confirmation.<br />Votre mot de passe doit contenir entre 6 et 15 caractères.';
$_lang["change_password_new"] = 'Nouveau mot de passe ';
$_lang["charset_message"] = 'Veuillez choisir l\'encodage de caractères que vous souhaitez utiliser dans le gestionnaire. MODx a été testé avec bon nombre d\'encodages, mais pas avec tous. Pour la plupart des langues, y compris le français, le réglage par défaut (utf-8) convient.';
$_lang["charset_title"] = 'Encodage des caractères :';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Code source du chunk (html)';
$_lang["cleaningup"] = 'Nettoyage';
$_lang["clear_log"] = 'Vider l\'historique';
$_lang["click_to_context"] = 'Cliquer pour accéder au menu contextuel';
$_lang["click_to_edit_title"] = 'Gliquez ici pour afficher cet enregistrement';
$_lang["click_to_view_details"] = 'Cliquer ici pour afficher les détails';
$_lang["close"] = 'Fermer';
$_lang["collapse_tree"] = 'Réduire';
$_lang["comment"] = 'Commentaire';
$_lang["configcheck_admin"] = 'Merci de contacter un administrateur et de lui communiquer le contenu de ce message !';
$_lang["configcheck_cache"] = 'Répertoire cache non modifiable ';
$_lang["configcheck_cache_msg"] = 'MODx ne peut pas écrire dans le répertoire cache. Il fonctionnera normalement, le cache ne fonctionnera pas. Pour corriger ce problème, veuillez permettre l\'écriture dans le répertoire /_cache/.';
$_lang["configcheck_configinc"] = 'Le fichier de configuration est modifiable.';
$_lang["configcheck_configinc_msg"] = 'Des personnes mal intentionnées pourrait modifier la configuration de votre site (notamment, login et mot de passe). Modifiez <strong>immédiatement</strong> les permissions de votre fichier de configuration (/manager/includes/config.inc.php) en lecture seule (effectuez un CHMOD 644)!';
$_lang["configcheck_default_msg"] = 'Une erreur inconnue est survenue. Merci de rapporter celle-ci via notre <a href="http://MODxcms.com/bugs\">bugtracker</a>';
$_lang["configcheck_errorpage_unavailable"] = 'La page d\'erreur de votre site n\'est pas définie.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Cela signifie que votre page d\'erreur n\'est pas accessible à vos visiteurs ou qu\'elle n\'existe pas. Cela peut provoquer une boucle infinie, générer des erreurs dans vos logs. Assurez vous qu\'aucun groupe utilisateur n\'est défini pour cette page.';
$_lang["configcheck_errorpage_unpublished"] = 'La page d\'erreur de votre site n\'est pas publiée ou n\'existe pas.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Cela signifie qu\'elle n\'est pas accessible au public. Publiez cette page ou assurez vous que le numéro d\'ID de la page est valide dans Outils > Configuration.';
$_lang["configcheck_images"] = 'Répertoire d\'images pas accessible en écriture';
$_lang["configcheck_images_msg"] = 'Le répertoire des images n\'a pas les autorisations en écriture ou n\'existe pas. Par conséquent, les fonctions de gestion d\'images de l\'éditeur WYSIWYG ne fonctionneront pas !';
$_lang["configcheck_installer"] = 'Installeur encore présent ';
$_lang["configcheck_installer_msg"] = 'Le répertoire «&nbsp;install/&nbsp;» contient l\'installeur de MODx. Imaginez un instant ce qui pourraît arriver à votre site si une personne mal intentionnée trouve ce répertoire et exécute l\'installeur&nbsp;! Il n\'irait probablement pas bien loin, parce qu\'il devra taper les informations de l\'utilisateur de la base de données, mais il est bien plus sûr de supprimer ce répertoire de votre serveur.';
$_lang["configcheck_lang_difference"] = 'Nombre incorrect de variables dans le fichier de langue';
$_lang["configcheck_lang_difference_msg"] = 'La langue actuellement choisie ($manager_language) a un nombre de variables différent de la langue par défaut. Ceci n\'est pas nécessairement un problème, mais peut signifier que le fichier de langue doit être mis à jour.';
$_lang["configcheck_notok"] = 'Un ou plusieurs détails de configuration ne sont pas valides&nbsp;:';
$_lang["configcheck_ok"] = 'Le contrôle s\'est bien passé - aucun avertissement rapporté.';
$_lang["configcheck_register_globals"] = 'register_globals est sur "ON" dans votre fichier de configuration php (php.ini)';
$_lang["configcheck_register_globals_msg"] = 'Cette configuration rend votre site vulnérable aux attaques <a href="http://www.commentcamarche.net/attaques/cross-site-scripting.php3">XCSS</a> (cross site scripting). Consulter votre hébergeur sur la marche à suivre pour désactiver ce réglage.';
$_lang["configcheck_title"] = 'Contrôle de configuration';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'La page "accès non autorisé" n\'est pas publiée ou n\'existe pas.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Cela signifie que cette page n\'est pas accessible à vos visiteurs ou n\'existe pas. Cela peut provoquer une boucle infinie, générer des erreurs dans vos logs. Assurez vous qu\'aucun groupe utilisateur n\'est défini pour cette page.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La page "accès non autorisé" définie dans la configuration du site n\'est pas publiée.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Cela signifie que la page "accès non autorisé" n\'est pas accessible au public. Publiez cette page ou assurez vous que le numéro d\'ID de la page est valide dans Outils > Configuration.';
$_lang["configcheck_warning"] = 'Avertissement de configuration&nbsp;:';
$_lang["configcheck_what"] = 'Que signifie ceci&nbsp;?';
$_lang["confirm_block"] = 'Voulez-vous vraiment bloquer cet utilisateur ?';
$_lang["confirm_delete_document"] = 'Voulez-vous vraiment supprimer ce document ?\nTous les documents enfants seront également supprimés.';
$_lang["confirm_delete_eventlog"] = 'Voulez-vous vraiment supprimer cet historique ?';
$_lang["confirm_delete_file"] = 'Voulez-vous vraiment supprimer ce fichier ?\n\nUne telle opération pourrait empêcher votre site de fonctionner correctement ! Ne supprimez ce fichier que si vous êtes absolument certain de ne rien casser.';
$_lang["confirm_delete_htmlsnippet"] = 'Voulez-vous vraiment supprimer ce chunk ?';
$_lang["confirm_delete_keywords"] = 'Voulez-vous vraiment supprimer ce mots clés ?';
$_lang["confirm_delete_module"] = 'Voulez-vous vraiment supprimer ce module&nbsp;?';
$_lang["confirm_delete_plugin"] = 'Voulez-vous vraiment supprimer ce plugin?';
$_lang["confirm_delete_record"] = 'Voulez-vous vraiment supprimer les enregistrements sélectionnés ?';
$_lang["confirm_delete_role"] = 'Voulez-vous vraiment supprimer ce rôle ?';
$_lang["confirm_delete_snippet"] = 'Voulez-vous vraiment supprimer ce snippet ?';
$_lang["confirm_delete_tags"] = 'Voulez-vous vraiment supprimer les balises META sélectionnées ?';
$_lang["confirm_delete_template"] = 'Voulez-vous vraiment supprimer ce modèle ?';
$_lang["confirm_delete_tmplvars"] = 'Voulez-vous vraiment supprimer cette variable et toutes ses valeurs enregistrées&nbsp;?';
$_lang["confirm_delete_user"] = 'Voulez-vous vraiment supprimer cet utilisateur ?';
$_lang["confirm_duplicate_document"] = 'Voulez-vous vraiment dupliquer ce document/dossier&nbsp;?\nLes sous-dossiers et pages incluses seront aussi dupliqués.';
$_lang["confirm_duplicate_record"] = 'Voulez-vous vraiment dupliquer cet enregistrement&nbsp;?';
$_lang["confirm_empty_trash"] = 'Vous allez supprimer de manière permanente TOUS les documents que vous avez mis à la corbeille !\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_load_depends"] = 'Voulez-vous vraiment charger la page du Gestionnaire des dépendances sans enregistrer vos modifications&nbsp;?';
$_lang["confirm_name_change"] = 'La modification du nom d\'un utilisateur peut influencer d\'autres applications liées au gestionnaire de contenu. \n\n Voulez-vous vraiment modifier le nom de cet utilisateur ?';
$_lang["confirm_publish"] = '\n\nSi vous publiez ce document maintenant, vous en supprimerez toutes les dates de (dé)publications ayant été fixées. Si vous souhaitez fixer ou modifier les dates de (dé)publication, veuillez plutôt choisir de «&nbsp;Modifier&nbsp;» le document.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_remove_locks"] = 'Les utilisateurs ferment parfois leur navigateur alors qu\'ils modifient des documents, modèle, snippets ou analyseurs. Ils laissent ainsi parfois verrouillé l\'élément en cours d\'édition. En cliquant sur OK vous pouvez enlever TOUS les verrous actuellement en place.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_unblock"] = 'Voulez-vous vraiment débloquer cet utilisateur ?';
$_lang["confirm_undelete"] = '\n\nTous les documents enfants supprimés avec ce document seront rétablis, mais les documents enfants supprimés plus tôt seront encore marqués comme supprimés.';
$_lang["confirm_unpublish"] = '\n\nSi vous dépubliez ce document maintenant, vous en supprimerez toutes les dates de (dé)publications ayant été fixées. Si vous souhaitez fixer ou modifier les dates de (dé)publication, veuillez plutôt choisir de «&nbsp;Modifier&nbsp;» le document.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_unzip_file"] = 'Voulez-vous vraiment décompresser ce fichier ?\n\nLes fichiers de même nom existant seront supprimés.';
$_lang["could_not_find_user"] = 'Impossible de trouver cet utilisateur';
$_lang["createdon"] = 'Date création';
$_lang["create_document_here"] = 'Créer page ici';
$_lang["create_folder_here"] = 'Créer un dossier ici';
$_lang["create_weblink_here"] = 'Créer lien ici';
$_lang["credits"] = 'Crédits';
$_lang["credits_dTree"] = 'MODx utilise l\'excellent script dTree de DestroyDrop.com.';
$_lang["credits_everaldo"] = 'MODx utilise plusieurs icônes du jeu d\'icônes Crystal d\'Everaldo.';
$_lang["credits_mysql"] = 'MODx fonctionne avec MySQL.';
$_lang["credits_php"] = 'MODx fonctionne grâce à PHP.';
$_lang["credits_shouts_msg"] = '<ul><li><strong>Raymond Irving, Ryan Thrash</strong> &ndash; Project Founders</li><li><strong>Jason Coward, Victor Brillon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</strong> &ndash; Core Architecture &amp; Design</li><li><strong>Nicolas Martignoni et David Mollière</strong> &ndash; Traduction française</li></ul>';
$_lang["credits_shouts_title"] = '<strong>Remerciements également à :</strong>';
$_lang["credits_webfx"] = 'MODx utilise un certain nombre de JavaScript de Webfx.';
$_lang["custom_contenttype_message"] = 'Vous pouvez ajouter ici des types de contenu personnalisés pour vos documents. Pour ajouter un nouveau type, tapez-le dans le champ, puis cliquez le bouton «&nbsp;Ajouter&nbsp;».';
$_lang["custom_contenttype_title"] = 'Types de contenu personnalisés&nbsp;:';
$_lang["database_name"] = 'Nom de la BDD';
$_lang["database_server"] = 'Nom du serveur de la BDD';
$_lang["database_tables"] = 'Tables de la BDD';
$_lang["database_overhead"] = '<b style=\'color:#990033\'>Note:</b> L\'overhead est un espace réservé par MySQL et qui est inutilisé. Pour libérer cet espace, cliquer sur le chiffre dans la colonne overhead.';
$_lang["database_table_clickhere"] = 'Cliquez ici';
$_lang["database_table_clickbackup"] = 'pour sauvegarder les tables sélectionnées';
$_lang["database_table_datasize"] = 'Taille';
$_lang["database_table_droptablestatements"] = 'Générer les déclarations DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Taille réelle';
$_lang["database_table_indexsize"] = 'Taille de l\'index';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Enregistrement';
$_lang["database_table_tablename"] = 'Nom de la table';
$_lang["database_table_totalsize"] = 'Taille totale';
$_lang["database_table_totals"] = 'Totaux:';
$_lang["date"] = 'Date';
$_lang["datechanged"] = 'Date de modification';
$_lang["defaultcache_message"] = 'Choisissez «&nbsp;Oui&nbsp;» pour permettre de mettre en cache les nouveaux documents par défaut.';
$_lang["defaultcache_title"] = 'À mettre en cache par défaut :';
$_lang["defaultmenuindex_message"] = 'Sélectionnez «&nbsp;Oui&nbsp;» pour activer l\'auto-incrémentation de l\'index de menu par défaut.';
$_lang["defaultmenuindex_title"] = 'Auto-incrémentation de l\'index';
$_lang["defaultpublish_message"] = 'Choisissez «&nbsp;Oui&nbsp;» pour que tous les nouveaux documents soient publiés par défaut.';
$_lang["defaultpublish_title"] = 'Publié par défaut :';
$_lang["defaultsearch_message"] = 'Choisissez «&nbsp;Oui&nbsp;» pour rendre tous les nouveaux documents rechercheables par défaut.';
$_lang["defaultsearch_title"] = 'Rechercheable par défaut :';
$_lang["defaulttemplate_message"] = 'Choisissez le modèle que vous souhaitez utiliser par défaut pour les nouveaux documents. Vous pourrez choisir un modèle différent lors de la modification du document. Ce réglage indique simplement le modèle sélectionné initialement.';
$_lang["defaulttemplate_title"] = 'Modèle par défaut';
$_lang["delete"] = 'Supprimer';
$_lang["delete_document"] = 'Supprimer document';
$_lang["delete_tags"] = 'Supprimer balises';
$_lang["deleting_file"] = 'Suppression du fichier «&nbsp;%s&nbsp;» : ';
$_lang["description"] = 'Description';
$_lang["deselect_keywords"] = 'Supprimer les mots clés';
$_lang["deselect_metatags"] = 'Retirer les balises META';
$_lang["disabled"] = 'Désactivé';
$_lang["document"] = 'Document';
$_lang["document_alias"] = 'Alias du document';
$_lang["document_alias_help"] = 'Vous pouvez ici définir un alias pour ce document. Le document pourra ainsi être atteint à l\'adresse : http://votreserver/alias. Cette fonctionnalité n\'est active que si vous utilisez les URLs simples.';
$_lang["document_content"] = 'Contenu du document';
$_lang["document_description"] = 'Description ';
$_lang["document_description_help"] = 'Vous pouvez taper ici une description (facultative) du document.';
$_lang["document_long_title_help"] = 'Vous pouvez indiquer ici un plus long titre pour votre document. Un tel titre sera pratique pour des moteurs de recherche, et offrira une meilleure description de votre document.';
$_lang["document_metatag_help"] = 'Sélectionnez les balises META et les mots-clés que vous désirez associer à ce document. Vous pouvez sélectionner plusieurs mots-clés ou balises (touche Majuscule ou Contrôle).';
$_lang["document_opt_contentdispo"] = 'Affichage contenu';
$_lang["document_opt_contentdispo_help"] = 'Utilisez le champ Affichage contenu pour spécifier la façon dont le document doit être traité par le navigateur web. Pour les fichiers à télécharger, choisissez l\'option the Annexe.';
$_lang["document_opt_emptycache"] = 'Supprimer du cache ?';
$_lang["document_opt_emptycache_help"] = 'Cocher cette case si vous voulez que MODx supprime automatiquement le document du cache après son enregistrement. De cette façon, vos visiteurs auront accès à la dernière version du document et non pas à la version en cache.';
$_lang["document_opt_folder"] = 'Répertoire ?';
$_lang["document_opt_folder_help"] = 'Cocher cette case pour définir ce document comme répertoire d\'autres documents. Comme MODx prend généralement soin automatiquement de ce réglage, n\'y attachez pas trop d\'importance.';
$_lang["document_opt_menu_index"] = 'Index de menu';
$_lang["document_opt_menu_index_help"] = 'l\'index de menu est une valeur que vous pouvez utiliser pour trier les documents dans vos snippets de menu. Vous pouvez également l\'utiliser dans vos snippets à n\'importe quel autre fin.';
$_lang["document_opt_menu_title"] = 'Titre de menu';
$_lang["document_opt_menu_title_help"] = 'Le titre de menu est un champ que vous pouvez utiliser pour afficher un bref intitulé du document dans vos snippets ou modules de menu.';
$_lang["document_opt_published"] = 'Publié ?';
$_lang["document_opt_published_help"] = 'Cocher cette case pour publier ce document immédiatement après son enregistrement.';
$_lang["document_opt_richtext"] = 'Éditeur WYSIWYG ?';
$_lang["document_opt_richtext_help"] = 'Cocher cette case si vous voulez utiliser l\'éditeur WISIWYG pour modifier ce document. Si le document contient du JavaScript ou du code HTML, décochez la case pour modifier le document en mode HTML, afin que l\'éditeur WYSIWYG ne le détériore pas.';
$_lang["document_opt_show_menu"] = 'Afficher dans le menu';
$_lang["document_opt_show_menu_help"] = 'Choisissez cette option pour afficher le document dans un menu web. Certains scripts de construction de menus peuvent ignorer cette option.';
$_lang["document_opt_trackvisit_help"] = 'Enregistrer les visites de chaque internaute sur cette page';
$_lang["document_overview"] = 'Résumé du document';
$_lang["document_parent"] = 'Document parent';
$_lang["document_parent_help"] = 'Cliquez sur l\'icône dossier ci-dessus pour activer ou désactiver la sélection d\'un parent, puis cliquer sur un document dans l\'arbre pour le choisir comme parent de ce document.';
$_lang["document_setting"] = 'Propriétés du document';
$_lang["document_summary"] = 'Résumé';
$_lang["document_summary_help"] = 'Taper un bref résumé du document';
$_lang["document_title"] = 'Titre';
$_lang["document_title_help"] = 'Taper ici le nom du document. Évitez d\'utiliser des antislashs (\) dans ce nom&nbsp;!';
$_lang["document_to_be_moved"] = 'Document à déplacer';
$_lang["document_weblink_help"] = 'Taper ici l\'adresse (URL) de l\'objet que vous souhaitez référencer.';
$_lang["documents_in_container"] = 'documents dans ce dossier';
$_lang["documents_in_container_no"] = 'Ce dossier n\'a aucun document enfant.';
$_lang["doc_data_title"] = 'Afficher les données du document';
$_lang["duplicate"] = 'Dupliquer';
$_lang["duplicate_alias_found"] = 'Le document «&nbsp;%s&nbsp;» utilise déjà l\'alias «&nbsp;%s&nbsp;». Veuillez choisir un alias unique.';
$_lang["duplicate_alias_message"] = 'Vous autorisez ici la création de d\'alias identiques. <strong>Attention&nbsp;!</strong> Pour éviter des problèmes de référencement de documents, cette option ne doit être activée qu\'en conjonction avec l\'option «&nbsp;Chemin d\'accès pour les alias simples&nbsp;».';
$_lang["duplicate_alias_title"] = 'Permettre les doublons d\'alias&nbsp;:';
$_lang["duplicate_document"] = 'Dupliquer un document';
$_lang["edit"] = 'Modifier';
$_lang["editedon"] = 'Date modification';
$_lang["editing_file"] = 'Modification fichier ';
$_lang["editor_css_path_message"] = 'Tapez le chemin du fichier CSS que vous désirez utiliser dans l\'éditeur. La meilleur façon de saisir le chemin est de l\'écrire à partir de la racine de votre serveur, par exemple /assets/site/style.css. Si vous ne désirez pas charger une feuille de style dans l\'éditeur, laissez ce champ vide.';
$_lang["editor_css_path_title"] = 'Chemin du fichier CSS&nbsp;:';
$_lang["edit_document"] = 'Modifier page';
$_lang["edit_document_title"] = 'Créer/modifier un document';
$_lang["edit_settings"] = 'Configuration';
$_lang["email"] = 'email';
$_lang["emailsender_message"] = 'Vous pouvez indiquer l\'adresse email à utiliser pour envoyer aux nouveaux utilisateurs leur login et mot de passe.';
$_lang["emailsender_title"] = 'Adresse email :';
$_lang["emailsubject_message"] = 'Vous pouvez taper ici le sujet du message envoyé par email aux nouveaux utilisateurs.';
$_lang["emailsubject_title"] = 'Sujet du message :';
$_lang["email_sent"] = 'Email sent';
$_lang["empty_folder"] = 'Ce répertoire est vide';
$_lang["empty_recycle_bin"] = 'Vider la corbeille';
$_lang["empty_recycle_bin_empty"] = 'La corbeille ne contient aucun document à purger.';
$_lang["enabled"] = 'Activé';
$_lang["enable_resource"] = 'Activer le fichier ressource.';
$_lang["enable_sharedparams"] = 'Activer le partage des paramètres';
$_lang["enable_sharedparams_msg"] = '<strong>Attention&nbsp;!</strong> l\'identifiant unique global (GUID) ci-dessus ne sera utilisé que pour distinguer ce module et ses paramètres partagés. Le GUID est aussi utilisé pour former un lien entre le module et les plugins ou snippets qui accèdent à ses paramètres partagés. ';
$_lang["error"] = 'Erreur';
$_lang["errorpage_message"] = 'Tapez ici le numéro du document que vous voulez afficher aux utilisateurs s\'ils demandent un document qui n\'existe pas réellement. <strong>ATTENTION&nbsp;! Assurez-vous que ce numéro est bien celui d\'un document existant et qu\'il est publié &nbsp;</strong>';
$_lang["errorpage_title"] = 'Page d\'erreur :';
$_lang["error_sending_email"] = 'Erreur durant l\'envoi de l\'email';
$_lang["eventlog"] = 'Historique événements';
$_lang["eventlog_msg"] = 'l\'historique des événements est utilisé pour afficher des informations, des messages d\'avertissements ou d\'erreurs générés par le gestionnaire de contenu. La colonne «&nbsp;source&nbsp;» indique la section d\'où provient le message.';
$_lang["eventlog_viewer"] = 'Affichage historique';
$_lang["event_id"] = 'Id événement';
$_lang["existing_category"] = 'Catégorie existante';
$_lang["expand_tree"] = 'Développer';
$_lang["export_site"] = 'Exporter le site';
$_lang["export_site_cacheable"] = 'Inclure les fichiers non-cachables :';
$_lang["export_site_exporting_document"] = 'Exportation du fichier <strong>%s</strong> sur <strong>%s</strong><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><em>%s</em>, no %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style="color:#990000">Échec !</span>';
$_lang["export_site_html"] = 'Exportation en HTMl';
$_lang["export_site_maxtime"] = 'Temps maximal d\'exportation :';
$_lang["export_site_maxtime_message"] = 'Vous pouvez indiquer ici la durée maximale (en secondes) à disposition de MODx pour exporter le site (remplace la configuration PHP). Tapez «&nbsp;0&nbsp;» pour une durée illimitée. Il n\'est pas recommandé de taper «&nbsp;0&nbsp;» ou un nombre très élevé, car dans ce cas des disfonctionnements de votre serveur pourront survenir.';
$_lang["export_site_message"] = '<p>Cette fonction vous permet d\'exporter la totalité du site en format HTML. Ce faisant, vous perdrez ainsi beaucoup de fonctionnalités de MODx :<p /><ul><li>les visites sur les fichiers exportés ne seront pas comptabilisées&nbsp;;</li><li>les snippets interactifs ne fonctionneront pas dans les fichiers exportés&nbsp;;</li><li>seuls les documents seront exportés, alors que les liens ne le seront pas&nbsp;;</li><li>le processus d\'exportation peut échouer si vos documents contiennent des snippets qui renvoient des en-têtes de redirection&nbsp;;</li><li>suivant la façon dont vous avez écrit vos documents, feuilles de styles et images, la mise en page de votre site pourrait être chamboulée. Pour éviter ceci, vous pouvez enrgistrer ou déplacer vos fichiers exportés dans le répertoire où se situe le fichier principal de MODx «&nbsp;index.php&nbsp;»&nbsp;;</li></ul><p />Veuillez remplir le formulaire et cliquer sur «Commencer l\'exportation» pour débuter le processus. Les fichiers créés seront enregistrés à l\'endroit spécifié, en utilisant comme noms de fichiers, dans la mesure du possible, les alias de document. Lors de l\'exportation de votre site, il est préférable d\'activer les «&nbsp;Alias simples&nbsp;» dans la configuration de MODx. Selon la taille de votre site, l\'exportation peut prendre un bon moment.<p /><strong>Si des fichiers de même nom existent, ils seront écrasés par les nouveaux fichiers aux noms identiques !</strong><p />';
$_lang["export_site_numberdocs"] = '<strong>%s documents trouvés pour exportation...</strong>';
$_lang["export_site_prefix"] = 'Préfixe de fichier :';
$_lang["export_site_start"] = 'Commencer l\'exportation';
$_lang["export_site_success"] = '<span style="color:#009900">Succès !</span>';
$_lang["export_site_suffix"] = 'Suffixe de fichier :';
$_lang["export_site_target_unwritable"] = 'Impossible d\'écrire dans le répertoire cible. Veuillez vous assurer que les autorisations du répertoire sont correctes et essayez à nouveau.';
$_lang["export_site_time"] = 'l\'exportation est terminée. l\'opération a duré %s secondes.';
$_lang["failed_login_message"] = 'Vous pouvez spécifier ici le nombre de tentatives de login infructueuses avant qu\'un utilisateur ne soit bloqué.';
$_lang["failed_login_title"] = 'Tentatives de login infructueuses :';
$_lang["fe_editor_lang_message"] = 'Choisir une langue pour l\'éditeur (utilisé pour l\'édition en ligne, côté front-end).';
$_lang["fe_editor_lang_title"] = 'Langue de l\'éditeur Front-End:';
$_lang["file_delete_file"] = 'Supprimer le fichier';
$_lang["file_delete_folder"] = 'Supprimer le répertoire';
$_lang["filemanager_path_message"] = 'Souvent, IIS ne remplit pas correctement le réglage document_root, qui est utilisé par le gestionnaire pour déterminer ce que vous pouvez voir. Si vous rencontrez des problèmes avec le gestionnaire, assurez-vous que ce chemin pointe vers la racine de votre installation MODx.';
$_lang["filemanager_path_title"] = 'Chemin du Gestionnaire de fichiers :';
$_lang["files_access_denied"] = 'Accès interdit !';
$_lang["files_data"] = 'Données';
$_lang["files_directories"] = 'Répertoires';
$_lang["files_dirwritable"] = 'Accès en écriture ?';
$_lang["files_dir_listing"] = 'Contenu du répertoire ';
$_lang["files_editfile"] = 'Modifier fichier';
$_lang["files_filename"] = 'Nom de fichier';
$_lang["files_fileoptions"] = 'Options';
$_lang["files_files"] = 'Fichiers';
$_lang["files_filesize"] = 'Taille';
$_lang["files_filetype_notok"] = 'Vous ne pouvez pas télécharger ce type de fichier !';
$_lang["files_file_type"] = 'Type du fichier : ';
$_lang["file_folder_chmod_error"] = 'Impossible de modifier les permissions, vous allez devoir changer les permissions manuellement (FTP, SSH).';
$_lang["files_modified"] = 'Modification';
$_lang["files_title"] = 'Sélection de fichiers';
$_lang["files_top_level"] = 'Vers la racine';
$_lang["files_uploadfile"] = 'Télécharger';
$_lang["files_uploadfile_msg"] = 'Sélectionner un fichier à télécharger :';
$_lang["files_uploading"] = 'Téléchargement de <strong>%s</strong> dans <strong>%s/</strong><br />';
$_lang["files_upload_copyfailed"] = 'Le fichier n\'a pas pu être copié dans le répertoire de destination - le téléchargement a échoué !';
$_lang["files_upload_error"] = 'Erreur';
$_lang["files_upload_error0"] = 'Un problème est survenu lors de votre téléchargement.';
$_lang["files_upload_error1"] = 'Le fichier que vous essayez de télécharger est trop grand.';
$_lang["files_upload_error2"] = 'Le fichier que vous essayez de télécharger est trop grand.';
$_lang["files_upload_error3"] = 'Le fichier que vous essayez de télécharger n\'a été que partiellement téléchargé.';
$_lang["files_upload_error4"] = 'Veuillez sélectionner un fichier à télécharger.';
$_lang["files_upload_error5"] = 'Un problème est survenu lors de votre téléchargement.';
$_lang["files_upload_inhibited_msg"] = '<strong>Téléchargement est désactivé</strong> - assurez-vous que votre serveur supporte le téléchargement et que PHP possède l\'autorisation d\'écrire dans le répertoire.<br />';
$_lang["files_upload_ok"] = 'Fichier téléchargé avec succès !';
$_lang["files_up_level"] = 'Niveau supérieur';
$_lang["files_viewfile"] = 'Afficher fichier';
$_lang["file_deleted"] = 'Succès !';
$_lang["file_download_file"] = 'Télécharger fichier';
$_lang["file_download_unzip"] = 'Décompresser fichier';
$_lang["file_folder_created"] = 'Le dossier a été créé !';
$_lang["file_folder_deleted"] = 'Le dossier a été supprimé&nbsp;!';
$_lang["file_folder_not_created"] = 'Impossible de créer le dossier';
$_lang["file_folder_not_deleted"] = 'Impossible de supprimer le dossier. Veuillez vous assurer qu\'il est vide avant de le supprimer&nbsp;!';
$_lang["file_not_deleted"] = 'Échec !';
$_lang["file_not_saved"] = 'Impossible d\'enregistrer le fichier. Veuillez vous assurer qu\'il est possible d\'écrire dans le répertoire cible !';
$_lang["file_saved"] = 'Le fichier a été enregistré !';
$_lang["file_unzip"] = 'Les fichiers ont été décompressés !';
$_lang["file_unzip_fail"] = 'Les fichiers n\'ont pas pu être décompressés !';
$_lang["folder"] = 'Répertoire';
$_lang["forgot_password_email_fine_print"] = '* l\'URL ci-dessus expirera dès que vous changez votre mot de passe, ou à défaut, le jour suivant.';
$_lang["forgot_password_email_instructions"] = 'A partir de là vous serez en mesure de changer votre mot de passe depuis le menu Mon Compte';
$_lang["forgot_password_email_intro"] = 'Une demande de changement de mot de passe a été émise pour votre compte utilisateur.';
$_lang["forgot_password_email_link"] = 'Cliquez ici pour finaliser le changement de mot de passe.';
$_lang["forgot_your_password"] = 'Mot de passe oublié ?';
$_lang["friday"] = 'Vendredi';
$_lang["friendlyurlsprefix_message"] = 'Vous pouvez indiquer ici un préfixe à utiliser pour les URLs simples. Par exemple, si le préfixe est «page», l\'URL /index.php?id=2 sera transformé en l\'URL simple /page2.html (pour autant que le suffixe soit «.html»). Vous pouvez ainsi spécifier ce que vos utilisateurs (et les moteurs de recherche) verront comme liens sur votre site.';
$_lang["friendlyurlsprefix_title"] = 'Préfixe des URLs simples :';
$_lang["friendlyurlsuffix_message"] = 'Vous pouvez indiquer ici un suffixe à utiliser pour les URLs simples. Par exemple, en indiquant «.html», toutes vos URLs simples se termineront par .html.';
$_lang["friendlyurlsuffix_title"] = 'Suffixe des URLs simples :';
$_lang["friendlyurls_message"] = 'Cette option vous permet d\'utiliser des URLs compatibles avec les moteurs de recherche. Veuillez prendre note que ceci ne fonctionne que sur des installations de MODx fonctionnant avec Apache, et que vous devrez écrire un fichier .htaccess pour que cela fonctionne correctement. Pour plus d\'informations, voyez les fichiers .htaccess inclus dans la distribution.';
$_lang["friendlyurls_title"] = 'Utiliser les URLs simples :';
$_lang["friendly_alias_message"] = 'Si vous utilisez les URLs simples et si le document possède un alias, l\'alias aura toujours la priorité sur l\'URL simple. En spécifiant «&nbsp;oui&nbsp;» pour ce réglage, le préfixe et le suffixe de l\'URL seront appliqués à l\'alias. Par exemple, si votre document no 1 a l\'alias «&nbsp;introduction&nbsp;» et si le préfixe est «&nbsp;» (vide) et le suffixe «&nbsp;.html&nbsp;», l\'URL généré pour ce document sera «&nbsp;introduction.html&nbsp;». Si le document n\'a pas d\'alias, l\'URL sera «&nbsp;1.html&nbsp;».';
$_lang["friendly_alias_title"] = 'Utiliser les alias simples';
$_lang["functionnotimpl"] = 'Désolé !';
$_lang["functionnotimpl_message"] = 'Cette fonction n\'a pas encore été implémentée.';
$_lang["go"] = 'Exécuter';
$_lang["group_access_permissions"] = 'Accès des groupes d\'utilisateurs';
$_lang["guid"] = 'GUId';
$_lang["help"] = 'Aide';
$_lang["help_msg"] = 'Si vous avez besoin d\'aide sur MODx, le mieux est de nous rendre visite sur les <a href="http://modxcms.com/forums/index.php#8" target="_blank">Forums de MODx</a>. Vous pouvez aussi consulter la <a href="http://www.tattoocms.info/wiki/doku.php">documentation française</a>. Les réponses que vous attendez s\'y trouvent peut-être. Dans le cas contraire, posez votre question dans les forums, et nous y répondrons aussi vite que possible.';
$_lang["help_title"] = 'Aide';
$_lang["hide_tree"] = 'Cacher l\'arbre';
$_lang["home"] = 'Accueil';
$_lang["htmlsnippet_desc"] = 'Description du chunk';
$_lang["htmlsnippet_management_msg"] = 'Cette section vous permet de créer et de modifier des chunks.';
$_lang["htmlsnippet_msg"] = 'Cette section vous permet de créer et de modifier des chunks (portions de code HTML). Les chunks sont écrits en code HTML «pur», et le code PHP n\'y sera pas interprété.';
$_lang["htmlsnippet_name"] = 'Nom du chunk';
$_lang["htmlsnippet_title"] = 'Créez/modifier un chunk';
$_lang["icon"] = 'Icône';
$_lang["id"] = 'No';
$_lang["illegal_parent_child"] = 'Choix du parent&nbsp;:\n\nle document est un enfant du document sélectionné.';
$_lang["illegal_parent_self"] = 'Choix du parent&nbsp;:\n\nle document sélectionné ne peut pas être son propre parent.';
$_lang["import_files_found"] = '<strong>%s documents trouvés pour importation...</strong><p/>';
$_lang["import_params"] = 'Importer les paramètres partagés du module';
$_lang["import_params_msg"] = 'Vous pouvez importer les paramètres ou réglages d\'un module en sélectionnant le nom du module dans le menu déroulant ci-dessus. <strong>Remarque&nbsp;:</strong> pour qu\'un module apparaisse dans le menu, ce plugin ou ce snippet doit faire partie des ressources dont le module dépend et le partage des paramètres doit être activé pour ce module.';
$_lang["import_parent_document"] = 'Document parent&nbsp:';
$_lang["import_site"] = 'Importer un site';
$_lang["import_site_failed"] = '<span style="color:#990000">Échec&nbsp;!</span>';
$_lang["import_site_html"] = 'Importer un site en HTMl';
$_lang["import_site_importing_document"] = 'Importation du fichier <strong>%s</strong> ';
$_lang["import_site_maxtime"] = 'Durée maximale d\'importation&nbsp;:';
$_lang["import_site_maxtime_message"] = 'Vous pouvez indiquer ici la durée maximale (en secondes) à disposition de MODx pour importer le site (remplace la configuration PHP). Tapez «&nbsp;0&nbsp;» pour une durée illimitée. Il n\'est pas recommandé de taper «&nbsp;0&nbsp;» ou un nombre très élevé, car dans ce cas des disfonctionnements de votre serveur pourront survenir.';
$_lang["import_site_message"] = 'l\'utilisation de cette fonction vous permet d\'importer l\'intégralité d\'un site web en HTML dans la base de données. Avant de lancer cette opération, vous devez copier tous vos fichiers et dossier HTML dans le dossier «&nbsp;assets/import&nbsp;».<p />Veuillez compléter le formulaire et cliquer sur «&nbsp;Importer&nbsp;» pour commencer l\'importation. Les fichiers importés seront enregistrés à l\'emplacement choisi, en utilisant si possible, les noms de fichiers comme alias des pages et le titre des pages de façon adéquate.';
$_lang["import_site_skip"] = '<span style="color:#990000">Ignoré&nbsp;!</span>';
$_lang["import_site_start"] = 'Importer';
$_lang["import_site_success"] = '<span style="color:#009900">Succès&nbsp;!</span>';
$_lang["import_site_time"] = 'Importation terminée. l\'importation a duré %s secondes.';
$_lang["inbox"] = 'Boîte de réception';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Elément en ligne';
$_lang["insert"] = 'Insérer';
$_lang["insert_snippet"] = 'Insérer un snippet dans la page';
$_lang["keyword"] = 'Mot clé';
$_lang["keywords"] = 'Mots clés';
$_lang["keywords_intro"] = 'Pour modifier un mot-clé, tapez un nouveau mot-clé dans le champ à côté du mot-clé à modifier. Pour supprimer un mot-clé, cochez la case «&nbsp;Supprimer&nbsp;» de ce mot-clé. Si vous cocher cette case et modifier aussi le mot-clé, celui-ci sera effacé et le changement de nom n\'aura pas lieu.';
$_lang["language_message"] = 'Choisissez la langue de l\'administration de MODx.';
$_lang["language_title"] = 'Langue :';
$_lang["launch_site"] = 'Visiter le site';
$_lang["link_attributes"] = 'Attributs des liens';
$_lang["link_attributes_help"] = 'Vous pouvez indiquer ici des attributs pour les liens, tels que target= or rel=.';
$_lang["list_mode"] = 'Mode liste actif/inactif - permet d\'afficher dans la grille tous les enregistrements.';
$_lang["loading_doc_tree"] = 'Chargement de l\'arbre...';
$_lang["loading_menu"] = 'Chargement du menu...';
$_lang["loading_page"] = 'Veuillez patienter pendant le chargement de la page...';
$_lang["localtime"] = 'Heure locale';
$_lang["locked"] = 'Verrouillé';
$_lang["lock_htmlsnippet"] = 'Verrouiller ce chunk';
$_lang["lock_htmlsnippet_msg"] = 'Seuls les administrateurs peuvent modifier ce chunk.';
$_lang["lock_module"] = 'Verrouiller le module en vue de modification';
$_lang["lock_module_msg"] = 'Seuls les administrateurs peuvent modifier ce module.';
$_lang["lock_msg"] = '%s modifie actuellement ce %s. Veuillez patienter jusqu\'à ce que l\'autre utilisateur ait terminé et essayer à nouveau.';
$_lang["lock_plugin"] = 'Verrouiller ce plugin';
$_lang["lock_plugin_msg"] = 'Seuls les administrateurs peuvent modifier ce plugin.';
$_lang["lock_settings_msg"] = '%s modifie acteullement ces réglages. Veuillez patienter jusqu\'à ce que l\'autre utilisateur ait terminé et essayer à nouveau.';
$_lang["lock_snippet"] = 'Verrouiller ce snippet';
$_lang["lock_snippet_msg"] = 'Seuls les administrateurs peuvent modifier ce snippet.';
$_lang["lock_template"] = 'Verrouiller ce modèle';
$_lang["lock_template_msg"] = 'Seuls les administrateurs peuvent modifier ce modèle.';
$_lang["lock_tmplvars"] = 'Verrouiller la variable';
$_lang["lock_tmplvars_msg"] = 'Seuls les administrateurs peuvent modifier cette variable.';
$_lang["login_allowed_days"] = 'Jours autorisés';
$_lang["login_allowed_days_message"] = 'Choisissez les jours durant lesquels l\'utilisateur a l\'autorisation de se connecter.';
$_lang["login_allowed_ip"] = 'Adresses IP autorisée';
$_lang["login_allowed_ip_message"] = 'Taper ici les adresses IP d\'où l\'utilisateur a l\'autorisation de se connecter. <strong>ATTENTION&nbsp;! Séparez les diverses adresses IP par une virgule (,)</strong>';
$_lang["login_button"] = 'Connecter';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">L\'installation du site est actuellement en cours.<br /> Merci de ré-essayer dans quelques minutes !</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">MODx a été ré-installé. Merci de vous logger a nouveau!</span><br/>';
$_lang["login_captcha_message"] = 'Merci de saisir le code de sécurité tel qu\'affiché sur le graphique. Si vous ne pouvez pas lire le code, cliquez sur l\'image pour en générer un nouveau ou contactez votre administrateur.';
$_lang["login_captcha_message"] = ' Un administrateur a activé la validation par CAPTCHA. Vous devez par conséquent taper le code de sécurité. Si vous avez du mal à lire le code, cliquez sur le code pour en produire un nouveau.';
$_lang["login_homepage"] = 'Connexion page d\'accueil';
$_lang["login_homepage_message"] = 'Taper le numéro du document où envoyer l\'utilisateur après sa connexion. <strong>ATTENTION&nbsp;! Assurez-vous que ce numéro est bien celui d\'un document existant et qu\'il est publié et accessible par l\'utilisateur&nbsp;!</strong>';
$_lang["login_message"] = 'Veuillez vous identifier afin d\'accéder au gestionnaire de contenu de votre site. Votre login et votre mot de passe sont sensibles à la casse. Tapez-les donc avec soin !';
$_lang["logout"] = 'Déconnexion';
$_lang["logo_slogan"] = 'Faire plus avec moins - MODx Content Manager';
$_lang["long_title"] = 'Titre long';
$_lang["mail_check_timeperiod_title"] = 'Intervalle de vérification des messages:';
$_lang["mail_check_timeperiod_message"] = 'A quel intervalle MODx doit-il vérifier l\'arrivée de nouveaux messages, en secondes.';
$_lang["manager"] = 'Gestionnaire';
$_lang["manager_direction_message"] = 'Choisissez la direction dans laquelle le texte sera lu dans le gestionnaire, de gauche à droite ou de droite à gauche.';
$_lang["manager_direction_title"] = 'Sens de lecture du gestionnaire:';
$_lang["manager_lockout_message"] = 'Vous êtes déjà connecté au Manager. Si vous souhaitez fermer votre session merci de bien vouloir utiliser le bouton "Déconnexion". <p />Pour aller à la page d\'accueil. Cliquer sur "Site > Accueil".';
$_lang["manager_permissions"] = 'Autorisations du gestionnaire';
$_lang["manager_theme"] = 'Thème du gestionnaire&nbsp;:';
$_lang["manager_theme_message"] = 'Choisir un thème pour le gestionnaire de contenu.';
$_lang["manage_depends"] = 'Gestion des dépendances';
$_lang["manage_files"] = 'Gestion des fichiers';
$_lang["manage_htmlsnippets"] = 'Gestion des chunks';
$_lang["manager_lang_attribute_message"] = 'Saisissez le code qui convient le mieux à la langue utilisée pour le gestionnaire, cela garantira que votre navigateur affichera les contenus au format correct.';
$_lang["manager_lang_attribute_title"] = 'Attribut de langue HTML et XML du gestionnaire:';
$_lang["manage_metatags"] = 'Gestion des balises META et des mots-clés';
$_lang["manage_modules"] = 'Gestion des modules';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Gestion des modèles';
$_lang["messages"] = 'Messages';
$_lang["messages_all"] = 'Tout le monde';
$_lang["messages_compose"] = 'Composer message';
$_lang["messages_forward"] = 'Transmettre';
$_lang["messages_from"] = 'De';
$_lang["messages_group"] = 'Un groupe';
$_lang["messages_inbox"] = 'Boîte de messages';
$_lang["messages_message"] = 'Message';
$_lang["messages_not_allowed_to_read"] = 'Vous ne pouvez pas lire ce message !';
$_lang["messages_no_messages"] = 'Votre boîte ne contient aucun message.';
$_lang["messages_private"] = 'Privé';
$_lang["messages_read_message"] = 'Lire message';
$_lang["messages_reply"] = 'Répondre';
$_lang["messages_select_group"] = 'Choisir un groupe';
$_lang["messages_select_user"] = 'Choisir un utilisateur';
$_lang["messages_send"] = 'Envoyer';
$_lang["messages_send_to"] = 'Envoyer à';
$_lang["messages_sent"] = 'Envoyé le';
$_lang["messages_subject"] = 'Sujet';
$_lang["messages_system_user"] = '[Système]';
$_lang["messages_title"] = 'Messages';
$_lang["messages_user"] = 'Un utilisateur';
$_lang["metatags"] = 'Balises META';
$_lang["metatags_and_keywords"] = 'Balises META et mots-clés';
$_lang["metatag_intro"] = 'Sur cette page, vous pouvez supprimer, créer ou modifier des balises META. Pour associer des balises META à des documents, sélectionnez l\'onglet <strong>Mots clés</u> lors de l\'édition du document, et sélectionnez les balises META et les mots-clés adéquats. Pour ajouter une nouvelle balise, tapez son nom et sa valeur, puis cliquez le bouton «&nbsp;Ajouter balise&nbsp;». Pour modifier une balise, cliquez sur son nom dans la grille de données.';
$_lang["metatag_notice"] = 'Merci de consulter le <a href="http://www.html-reference.com/META.htm" target="_blank">Guide de réference HTML</a> pour plus d\'informations. Liste non exhaustive.';
$_lang["meta_keywords"] = 'Mots-clés';
$_lang["mgr_access_permissions"] = 'Autorisations d\'accès au gestionnaire';
$_lang["mgr_login_start"] = 'Document de départ';
$_lang["mgr_login_start_message"] = 'Tapez ici le numéro du document que vous voulez faire afficher à l\'utilisateur une fois qu\'il est connecté au gestionnaire.<br /><strong>ATTENTION&nbsp;! Assurez-vous que ce numéro est bien celui d\'un document existant, qu\'il est publié et que cet utilisateur à les autorisations pour y accéder&nbsp;!</strong>';
$_lang["mgrlog_action"] = 'Action';
$_lang["mgrlog_actionid"] = 'ID';
$_lang["mgrlog_anyall"] = 'Toutes/Aucune';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() a retourné false.';
$_lang["mgrlog_datefr"] = 'Date du';
$_lang["mgrlog_dateinvalid"] = 'Format de date incorrect.';
$_lang["mgrlog_dateto"] = 'Date au';
$_lang["mgrlog_emptysrch"] = 'Votre recherche n\'a donné aucun résultat (aucun logs correpondants).';
$_lang["mgrlog_field"] = 'Champs';
$_lang["mgrlog_itemid"] = 'ID de l\'item';
$_lang["mgrlog_itemname"] = 'Nom de l\'item';
$_lang["mgrlog_msg"] = 'Message';
$_lang["mgrlog_noquery"] = 'Pas de recherche effectuée.';
$_lang["mgrlog_query_msg"] = 'Merci d\'effecteur une sélection pour visualiser les logs. Vous pouvez effectuer une sélection par date, mais faites bien attention : les dates saisies ne sont pas inclusives - pour sélectionner les logs du 1/1/2004 vous devez sélectionner les logs du 1/1/2004 au 2/1/2004.<br /><br />
Message et action ont habituellement les mêmes valeurs. Si vous recherchez un message spécifique, il vaut mieux sélectionner l\'action sur «&nbsp;Toutes/Acune&nbsp;».';
$_lang["mgrlog_results"] = 'Nb. de résultats';
$_lang["mgrlog_qresults"] = 'Résultat de la recherche';
$_lang["mgrlog_searchlogs"] = 'Rechercher les logs';
$_lang["mgrlog_sortinst"] = 'Vous pouvez trier les tables en cliquant sur l\'entête de colonne. Si les logs deviennent plus volumineux, vous pouvez <a href="index.php?a=55">les vider</a>. Cela supprimera tous les logs et ne peut pas être annulé !';
$_lang["mgrlog_query"] = 'Enregistrement des requêtes';
$_lang["mgrlog_time"] = 'Heure';
$_lang["mgrlog_user"] = 'Utilisateur';
$_lang["mgrlog_username"] = 'Nom utilisateur';
$_lang["mgrlog_value"] = 'Valeur';
$_lang["mgrlog_view"] = 'Voir les logs du manager';
$_lang["modules"] = 'Modules';
$_lang["module_code"] = 'Code source du module (php)';
$_lang["module_config"] = 'Configuration du module';
$_lang["module_desc"] = 'Description';
$_lang["module_disabled"] = 'Le module est désactivé';
$_lang["module_edit_click_title"] = 'Cliquer ici pour modifier le module';
$_lang["module_group_access_msg"] = 'Sélectionnez les groupes d\'utilisateurs ayant le droit de lancer ce module depuis le gestionnaire de contenu.';
$_lang["module_management"] = 'Gestion des modules';
$_lang["module_management_msg"] = 'Vous pouvez choisir ici le module à lancer ou à modifier. Pour lancer le module, cliquer sur l\'icône dans la grille. Pour modifier le module, cliquer sur le nom du module.';
$_lang["module_msg"] = 'Vous pouvez ici ajouter ou modifier des modules. Un module est une collection de ressources (par exemple des plugins, des snippets, etc.).';
$_lang["module_name"] = 'Nom du module';
$_lang["module_resource_msg"] = 'Vous pouvez ici ajouter ou supprimer les ressources dont dépend ce module. Pour ajouter une nouvelle ressource, cliquez sur l\'un des boutons ci-dessous.';
$_lang["module_resource_title"] = 'Dépendances du module';
$_lang["module_title"] = 'Créer/modifier un module';
$_lang["module_viewdepend_msg"] = 'Vous pouvez voir ici les ressources dont dépend le fonctionnement du module. Cliquer sur le bouton «&nbsp;Dépendances du gestionnaire&nbsp;» pour modifier les dépendances';
$_lang["modx_version"] = "Version de MODx";
$_lang["monday"] = 'Lundi';
$_lang["move"] = 'Déplacer';
$_lang["move_document"] = 'Déplacer document';
$_lang["move_document_message"] = 'Vous pouvez déplacer un document et tous ses enfants en choisissant un nouveau parent dans l\'arbre. Si ce document n\'est pas un répertoire, il sera transformé en répertoire. Veuillez cliquer sur le nouveau parent dans l\'arbre.';
$_lang["move_document_new_parent"] = 'Veuillez choisir un nouveau parent dans l\'arbre des documents.';
$_lang["move_document_title"] = 'Déplacer le document';
$_lang["name"] = 'Nom';
$_lang["new_category"] = 'Nouvelle Catégorie';
$_lang["new_file_permissions_message"] = 'Lorsque vous uploadez un fichier via le gestionnaire de fichier, celui-ci tentera de modifier automatiquement les permissions sur le réglages saisi ici. Il est possible que cela ne fonctionne pas sur certaines configuration de serveur, telle qu\'IIS, vous serez alors contraint de modifier les permissions manuellement (FTP, SSH).';
$_lang["new_file_permissions_title"] = 'Nouvelle permission du fichier';
$_lang["new_folder_permissions_message"] = 'Lorsque vous créez un répertoire via le gestionnaire de fichier, celui-ci tentera de modifier automatiquement les permissions sur le réglages saisi ici. Il est possible que cela ne fonctionne pas sur certaines configuration de serveur, telle qu\'IIS, vous serez alors contraint de modifier les permissions manuellement (FTP, SSH).';
$_lang["new_folder_permissions_title"] = 'Nouvelle permission du répertoire';
$_lang["new_htmlsnippet"] = 'Nouveau chunk';
$_lang["new_keyword"] = 'Ajouter un nouveau mot clé :';
$_lang["new_module"] = 'Nouveau module';
$_lang["new_parent"] = 'Nouveau parent';
$_lang["new_plugin"] = 'Nouveau plugin';
$_lang["new_role"] = 'Créer un rôle';
$_lang["new_snippet"] = 'Nouveau snippet';
$_lang["new_template"] = 'Nouveau modèle';
$_lang["new_tmplvars"] = 'Nouvelle variable de modèle';
$_lang["new_user"] = 'Créer un utilisateur';
$_lang["new_web_user"] = 'Nouvel utilisateur web';
$_lang["no"] = 'Non';
$_lang["nologentries_message"] = 'Spécifiez le nombre d\'entrées de l\'historique affichées par page lors de l\'affichage de l\'historique.';
$_lang["nologentries_title"] = 'Nombre d\'entrées de l\'historique :';
$_lang["nomessages_message"] = 'Spécifiez le nombre de messages à afficher dans la boîte lors de l\'affichage des messages.';
$_lang["nomessages_title"] = 'Nombre de messages :';
$_lang["none"] = 'Aucun';
$_lang["noresults_message"] = 'Tapez ici le nombre des résultats à afficher dans la grille de données lors de l\'affichage de listes et de résultats de recherches.';
$_lang["noresults_title"] = 'Nombre de résultats&nbsp;:';
$_lang["notset"] = 'Non fixé';
$_lang["not_deleted"] = 'n\'a pas été supprimé.';
$_lang["not_set"] = 'Non fixé';
$_lang["no_activity_message"] = 'Vous n\'avez encore créé ni modifié aucun document.';
$_lang["no_category"] = 'non catégorisé';
$_lang["no_docs_pending_publishing"] = 'Aucun document en attente de publication.';
$_lang["no_docs_pending_pubunpub"] = 'Aucun évènement trouvé.';
$_lang["no_docs_pending_unpublishing"] = 'Aucun document en attente de dépublication.';
$_lang["no_groups_found"] = 'Aucun groupe trouvé.';
$_lang["no_keywords_found"] = 'Le site n\'a actuellement pas de mots-clés.';
$_lang["no_records_found"] = 'Aucun enregistrement trouvé.';
$_lang["no_results"] = 'Aucun résultat trouvé';
$_lang["offline"] = 'Hors ligne';
$_lang["online"] = 'En ligne';
$_lang["onlineusers_action"] = 'Action';
$_lang["onlineusers_actionid"] = 'Action-ID';
$_lang["onlineusers_ipaddress"] = 'Adresse IP de l\'utilisateur';
$_lang["onlineusers_lasthit"] = 'Dernière requête';
$_lang["onlineusers_message"] = 'La liste ci-dessous affiche les utilisateurs actifs durant des 20 dernières minutes (il est actuellement ';
$_lang["onlineusers_title"] = 'Utilisateurs en ligne';
$_lang["onlineusers_user"] = 'Utilisateur';
$_lang["onlineusers_userid"] = 'Numéro ID';
$_lang["optimize_table"] = 'Cliquez ici pour optimiser cette table';
$_lang["pagetitle"] = 'Titre';
$_lang["page_data_cacheable"] = 'À placer en cache';
$_lang["page_data_cacheable_help"] = 'Cocher cette case si vous voulez permettre que le document soit placé en cache. Si votre document contient des snippets, assurez-vous que ce champ est ne soit pas coché.';
$_lang["page_data_cached"] = '<strong>Source tirée du cache&nbsp;:</strong>';
$_lang["page_data_changes"] = 'Modifications';
$_lang["page_data_contentType"] = 'Type de contenu';
$_lang["page_data_contentType_help"] = 'Choisissez le type de contenu de ce document. Si vous n\'êtes pas sûr du type de votre document, sélectionnez «text/html».';
$_lang["page_data_created"] = 'Créé le';
$_lang["page_data_edited"] = 'Modifié le';
$_lang["page_data_editor"] = 'Modifier avec éditeur WYSIWYG';
$_lang["page_data_folder"] = 'Le document est un répertoire';
$_lang["page_data_general"] = 'Général';
$_lang["page_data_markup"] = 'Disposition/structure';
$_lang["page_data_mgr_access"] = 'Accès gestionnaire';
$_lang["page_data_notcached"] = 'Ce document n\'a pas (encore) été mis en cache.';
$_lang["page_data_publishdate"] = 'Date publication';
$_lang["page_data_publishdate_help"] = 'Si vous choisissez une date de publication, le document sera publié lorsque cette date sera atteinte. Cliquez sur l\'icône du calendrier pour choisir une date, ou sur l\'icône à côté pour supprimer la date de publication. Dans ce cas le document ne sera pas publié automatiquement.';
$_lang["page_data_published"] = 'Publié';
$_lang["page_data_searchable"] = 'Recherchable';
$_lang["page_data_searchable_help"] = 'Cocher cette case si vous voulez permettre que le document soit retrouvé par la fonction de recherche. Vous pouvez également utiliser ce champ dans vos snippets à n\'importe quel autre fin.';
$_lang["page_data_source"] = 'Source';
$_lang["page_data_status"] = 'Statut';
$_lang["page_data_template"] = 'Modèle utilisé';
$_lang["page_data_template_help"] = 'Sélectionnez ici le modèle à utiliser pour la mise en page du document.';
$_lang["page_data_title"] = 'Données de page';
$_lang["page_data_unpublishdate"] = 'Date fin de publication';
$_lang["page_data_unpublishdate_help"] = 'Si vous choisissez une date de fin de publication, le document sera dépublié lorsque cette date sera atteinte. Cliquez sur l\'icône du calendrier pour choisir une date, ou sur l\'icône à côté pour supprimer la date de fin de publication. Dans ce cas le document ne sera pas dépublié automatiquement.';
$_lang["page_data_unpublished"] = 'Non publié';
$_lang["page_data_web_access"] = 'Accès web';
$_lang["pagination_table_first"] = "Début";
$_lang["pagination_table_last"] = "Fin";
$_lang["pagination_table_gotopage"] = "Aller à la page";
$_lang["paging_first"] = 'première';
$_lang["paging_last"] = 'dernière';
$_lang["paging_next"] = 'suivant';
$_lang["paging_prev"] = 'précédent';
$_lang["paging_showing"] = 'Affichées';
$_lang["paging_to"] = 'à';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Paramètre';
$_lang["password"] = 'Votre mot de passe ';
$_lang["password_change_request"] = 'Demande de modification de mot de passe';
$_lang["password_gen_gen"] = 'Laisser MODx générer le mot de passe.';
$_lang["password_gen_length"] = 'Le mot de passe doit contenir au moins 6 caractères.';
$_lang["password_gen_method"] = 'Comment créer le mot de passe de cet utilisateur ?';
$_lang["password_gen_specify"] = 'Me laisser spécifier le mot de passe :';
$_lang["password_method"] = 'Comment notifier du nouveau mot de passe ?';
$_lang["password_method_email"] = 'Envoyer le nouveau mot de passe par email.';
$_lang["password_method_screen"] = 'Afficher le nouveau mot de passe à l\'écran.';
$_lang["password_msg"] = 'Le nouveau mot de passe de <strong>%s</strong> est <strong>%s</strong>.';
$_lang["php_version_check"] = 'MODx est compatible avec PHP version 4.3.0 ou ultérieure. Veuillez mettre à jour votre installation de PHP !';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Code source du plugin (php)';
$_lang["plugin_config"] = 'Réglages du plugin';
$_lang["plugin_desc"] = 'Description';
$_lang["plugin_disabled"] = 'Plugin désactivé';
$_lang["plugin_event_msg"] = 'Sélection des événements devant être pris en compte par ce plugin.';
$_lang["plugin_locked_message"] = 'Ce plugin est verrouillé.';
$_lang["plugin_management_msg"] = 'Vous pouvez choisir ici quel plugin modifier.';
$_lang["plugin_msg"] = 'Cette section vous permet de créer et de modifier des plugins. Les plugins sont des extraits de code PHP brut exécutés par MODx lorsque les événements système choisis sont détectés.';
$_lang["plugin_name"] = 'Nom du plugin';
$_lang["plugin_priority"] = 'Editer l\'ordre d\'exécution du plugin';
$_lang["plugin_title"] = 'Créer/modifier plugin';
$_lang["preview"] = 'Prévisualiser';
$_lang["preview_document"] = 'Prévisualiser le document';
$_lang["preview_msg"] = 'Voici la prévisualisation de vos derniers changements enregistrés. Cliquer ici pour <a href="javascript://" onclick="saveRefreshPreview();"><img src="media/images/icons/save.gif" align="absmiddle" height="12">Enregistrer et afficher</a> vos modifications actuelles';
$_lang["private"] = 'Privé';
$_lang["public"] = 'Public';
$_lang["publish_date"] = 'Date de publication';
$_lang["publish_document"] = 'Publier le document';
$_lang["publish_events"] = 'Documents à publier';
$_lang["rb_base_dir_message"] = 'Tapez ici le chemin physique vers le dossier des ressources. d\'ordinaire, ce réglage généré automatiquement. Cependant, si vous utilisez IIS, MODx ne pourra pas détecter le chemin, et le gestionnaire de ressources affichera une erreur. Dans ce cas, vous pouvez saisir ici le chemin du dossier images (le chemin tel que vous le voyez dans l\'explorateur Windows). <strong>Attention&nbsp;!</strong> Le dossier des ressources doit contenir les sous-dossiers images, fichiers, flash et media pour que le gestionnaire de ressources fonctionne correctement.';
$_lang["rb_base_dir_title"] = 'Chemin des ressources&nbsp;:';
$_lang["rb_base_url_message"] = 'Tapez ici le chemin virtuel vers le dossier des ressources. d\'ordinaire, ce réglage généré automatiquement. Cependant, si vous utilisez IIS, MODx ne pourra pas détecter le chemin, et le gestionnaire de ressources affichera une erreur. Dans ce cas, vous pouvez saisir ici l\'URL du dossier images (l\'URL tel que vous le saisiriez dans votre navigateur web).';
$_lang["rb_base_url_title"] = 'URL des ressources&nbsp;:';
$_lang["rb_message"] = 'Une fois activé, vos utilisateurs pourront consulter et télécharger des ressources, par exemple des images, fichiers flash et d\'autres médias sur le serveur.';
$_lang["rb_title"] = 'Activer le gestionnaire de ressources&nbsp;:';
$_lang["recent_docs"] = 'Documents récents';
$_lang["refresh_cache"] = 'Cache : <strong>%s</strong> fichier(s) en cache&nbsp; <strong>%d</strong> d\'entre eux ont été supprimés.<br />De nouveaux fichiers seront créés en cache à mesure que les pages sont visitées.';
$_lang["refresh_published"] = 'Documents publiés&nbsp;: <strong>%s</strong> document(s) a(ont) été publié(s).';
$_lang["refresh_site"] = 'Recharger le site';
$_lang["refresh_title"] = 'Recharger le site';
$_lang["refresh_tree"] = 'Recharger l\'arbre';
$_lang["refresh_unpublished"] = 'Documents non publiés&nbsp;: <strong>%s</strong> document(s) a(ont) été dépublié(s).';
$_lang["remember_username"] = 'Enregistrer mon nom d\'utilisateur';
$_lang["remove"] = 'Retirer';
$_lang["remove_date"] = 'Retirer date';
$_lang["remove_locks"] = 'Supprimer les verrous';
$_lang["rename"] = 'Renommer';
$_lang["reports"] = 'Rapports';
$_lang["require_tagname"] = 'Un nom de balise est requis';
$_lang["require_tagvalue"] = 'Une valeur est requise pour la balise';
$_lang["reset"] = 'Vider';
$_lang["reset_failedlogins"] = 'Mise à zéro';
$_lang["resolve_hostnames_message"] = 'Voulez-vous que MODx résolve les noms de domaines de vos visiteurs ? La résolution des noms de domaines engendre une charge supplémentaire sur le serveur, mais vos visiteurs ne s\'en apercevront pas.';
$_lang["resolve_hostnames_title"] = 'Résolution des noms de domaine :';
$_lang["resource"] = 'Ressource';
$_lang["resources"] = 'Ressources';
$_lang["resource_categories"] = 'Toutes les ressources';
$_lang["resource_management"] = 'Gestion ressources';
$_lang["resource_name"] = 'Nom de la ressource';
$_lang["resource_selector_msg"] = 'Sélectionnez les ressources dans la liste ci-dessous et cliquer sur le bouton «&nbsp;Insérer&nbsp;».';
$_lang["resource_selector_title"] = 'Sélecteur de ressources';
$_lang["role_about"] = 'Accès à la page «&nbsp;À propos de&nbsp;»';
$_lang["role_access_persmissions"] = 'Autorisations d\'accès';
$_lang["role_actionok"] = 'Accès à l\'écran de fin d\'action';
$_lang["role_bk_manager"] = 'Utiliser le gestionnaire de sauvegardes';
$_lang["role_cache_refresh"] = 'Purge du cache du site';
$_lang["role_change_password"] = 'Changement de mot de passe';
$_lang["role_chunk_management"] = 'Gestion des Chunks';
$_lang["role_config_management"] = 'Gestion de la configuration';
$_lang["role_content_management"] = 'Gestion du contenu';
$_lang["role_create_chunk"] = 'Créer un Chunk';
$_lang["role_create_doc"] = 'Création de documents';
$_lang["role_create_plugin"] = 'Créer plugins';
$_lang["role_create_snippet"] = 'Création de snippets';
$_lang["role_create_template"] = 'Création de modèles';
$_lang["role_credits"] = 'Accès aux crédits';
$_lang["role_delete_chunk"] = 'Supprimer les Chunks';
$_lang["role_delete_doc"] = 'Suppression de documents';
$_lang["role_delete_eventlog"] = 'Supprimer l\'historique des événements';
$_lang["role_delete_module"] = 'Supprimer module';
$_lang["role_delete_plugin"] = 'Supprimer plugins';
$_lang["role_delete_role"] = 'Suppression de rôles';
$_lang["role_delete_snippet"] = 'Suppression de snippets';
$_lang["role_delete_template"] = 'Suppression de modèles';
$_lang["role_delete_user"] = 'Suppression d\'utilisateurs';
$_lang["role_delete_web_user"] = 'Supprimer utilisateurs web';
$_lang["role_edit_chunk"] = 'Editer les chunks';
$_lang["role_edit_doc"] = 'Modification de documents';
$_lang["role_edit_doc_metatags"] = 'Modifier les balises META et les mots-clés du document';
$_lang["role_edit_module"] = 'Modifier module';
$_lang["role_edit_plugin"] = 'Modifier plugins';
$_lang["role_edit_role"] = 'Modification de rôles';
$_lang["role_edit_settings"] = 'Modification de la configuration du site';
$_lang["role_edit_snippet"] = 'Modification de snippets';
$_lang["role_edit_template"] = 'Modification des modèles';
$_lang["role_edit_user"] = 'Modification d\'utilisateurs';
$_lang["role_edit_web_user"] = 'Modifier utilisateurs web';
$_lang["role_errors"] = 'Accès aux annonces d\'erreurs';
$_lang['role_export_static'] = 'Exportation HTML';
$_lang["role_eventlog_management"] = 'Gestion de l\'historique des événements';
$_lang["role_file_manager"] = 'Utilisation du gestionnaire de fichiers';
$_lang["role_frames"] = 'Accès aux cadres du gestionnaire';
$_lang["role_help"] = 'Accès aux pages d\'aide';
$_lang["role_home"] = 'Accès à la page d\'introduction du gestionnaire';
$_lang['role_import_static'] = 'Importation HTML';
$_lang["role_logout"] = 'Déconnexion du gestionnaire';
$_lang["role_management_msg"] = 'Cette section vous permet de créer et de modifier des rôles.';
$_lang["role_management_title"] = 'Gestion rôles';
$_lang["role_manage_metatags"] = 'Gérer les les balises META et les mots-clés du site';
$_lang["role_messages"] = 'Lecture et envoi de messages';
$_lang["role_module_management"] = 'Gestion des modules';
$_lang["role_name"] = 'Nom du rôle ';
$_lang["role_new_module"] = 'Nouveau module';
$_lang["role_new_role"] = 'Création de rôles';
$_lang["role_new_user"] = 'Création d\'utilisateurs';
$_lang["role_new_web_user"] = 'Créer utilisateurs web';
$_lang["role_plugin_management"] = 'Gestion des plugins';
$_lang["role_role_management"] = 'Gestion des rôles';
$_lang["role_publish_doc"] = 'Publier les documents';
$_lang["role_run_module"] = 'Lancer module';
$_lang["role_save_chunk"] = 'Enregistrement des chunks';
$_lang["role_save_doc"] = 'Enregistrement de documents';
$_lang["role_save_module"] = 'Enregistrer module';
$_lang["role_save_password"] = 'Enregistrement du mot de passe';
$_lang["role_save_plugin"] = 'Enregistrer plugins';
$_lang["role_save_role"] = 'Enregistrement de rôles';
$_lang["role_save_snippet"] = 'Enregistrement de snippets';
$_lang["role_save_template"] = 'Enregistrement de modèles';
$_lang["role_save_user"] = 'Enregistrement d\'utilisateurs';
$_lang["role_save_web_user"] = 'Enregistrer utilisateurs web';
$_lang["role_snippet_management"] = 'Gestion des snippets';
$_lang["role_template_management"] = 'Gestion des modèles';
$_lang["role_title"] = 'Créer/modifier un rôle';
$_lang["role_udperms"] = 'Gestion des autorisations';
$_lang["role_user_management"] = 'Gestion des utilisateurs';
$_lang["role_view_docdata"] = 'Affichage des données des documents';
$_lang["role_view_eventlog"] = 'Afficher l\'historique des événements';
$_lang["role_view_logs"] = 'Affichage des historiques du système';
$_lang["role_view_unpublished"] = 'Visualiser les documents non publiés';
$_lang["role_web_access_persmissions"] = 'Autorisations d\'accès web';
$_lang["role_web_user_management"] = 'Gestion des utilisateurs web';
$_lang["run_module"] = 'Lancer le module';
$_lang["saturday"] = 'Samedi';
$_lang["save"] = 'Enregistrer';
$_lang["save_all_changes"] = 'Enregistrer tous les changements';
$_lang["save_tag"] = 'Enregistrer balise';
$_lang["saving"] = 'En cours d\'enregistrement, veuillez patienter...';
$_lang["scroll_dn"] = 'Défilement vers le bas';
$_lang["scroll_up"] = 'Défilement vers le haut';
$_lang["search"] = 'Recherche';
$_lang["search_criteria"] = 'Critères de recherche';
$_lang["search_criteria_content"] = 'Rech. par contenu';
$_lang["search_criteria_content_msg"] = 'Chercher les documents dont le contenu contient ce texte';
$_lang["search_criteria_id"] = 'Recherche par no';
$_lang["search_criteria_id_msg"] = 'Tapez un no de document pour le localiser rapidement';
$_lang["search_criteria_longtitle"] = 'Rech. par titre long';
$_lang["search_criteria_longtitle_msg"] = '(Voir les documents avec le texte écrit dans leur titre long)';
$_lang["search_criteria_title"] = 'Rech. par titre';
$_lang["search_criteria_title_msg"] = 'Chercher les documents dont le titre contient ce texte';
$_lang["search_empty"] = 'Votre recherche n\'a donné aucun résultat. Veuillez essayer de nouveau en élargissant vos critères de recherche.';
$_lang["search_item_deleted"] = 'Cet élément a été supprimé';
$_lang["search_results"] = 'Résultats de recherche';
$_lang["search_results_returned_desc"] = 'Description';
$_lang["search_results_returned_id"] = 'No';
$_lang["search_results_returned_msg"] = 'Vos critères de recherche ont permis de trouver <strong>%s</strong> documents. Si un trop grand nombre de fichiers sont trouvés, essayer de taper des critères plus spécifiques. Les deux colonnes à l\'extrême gauche vous permettront de trouver le document dans l\'arbre ou de l\'afficher. Les colonnes de droite montrent, respectivement, si un document a été supprimé et son statut de publication.<br />';
$_lang["search_results_returned_title"] = 'Titre';
$_lang["search_view_docdata"] = 'Afficher cet élément';
$_lang["security"] = 'Sécurité';
$_lang["select_date"] = 'Choisir une date';
$_lang["send"] = 'Envoyer';
$_lang["serveroffset_message"] = 'Choisissez le nombre d\'heures de décalage entre le lieu où vous êtes et celui où se trouve le serveur. l\'heure sur le serveur est actuellement <strong>[%s]</strong>,<br />l\'heure sur le serveur en tenant compte du décalage est <strong>[%s]</strong>.';
$_lang["serveroffset_title"] = 'Décalage horaire du serveur&nbsp;:';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Si votre site est sur un serveur sécurisé (HTTPS), veuillez l\'indiquez ici.';
$_lang["server_protocol_title"] = 'Type de serveur :';
$_lang["servertime"] = 'Heure du serveur';
$_lang["serveroffset"] = 'Décalage horaire du serveur';
$_lang["settings_after_install"] = 'Puisqu\'il s\'agit d\'une nouvelle installation, vous devez contrôler ces réglages et effectuer les modifications que vous souhaitez. Veuillez ensuite cliquer «Enregistrer» pour enregistrer les réglages dans la base de données.<br /><br />';
$_lang["settings_config"] = 'Configuration';
$_lang["settings_dependencies"] = 'Dépendances';
$_lang["settings_events"] = 'Événements système';
$_lang["settings_furls"] = 'Réglages URLs simples';
$_lang["settings_general"] = 'Général';
$_lang["settings_misc"] = 'Réglages divers';
$_lang["settings_page_settings"] = 'Réglages de la page';
$_lang["settings_photo"] = 'Photo';
$_lang["settings_properties"] = 'Propriétés';
$_lang["settings_site"] = 'Réglages site';
$_lang["settings_snippets"] = 'Snippets';
$_lang["settings_strip_image_paths_message"] = 'l\'activation de cette option permet à MODx de changer les liens des images en chemin relatifs au lieu de chemins absolus. c\'est très pratique si vous souhaitez déplacer votre installation de MODx (par exemple d\'un site d\'ébauche à un site en production). Si vous ne savez pas de quoi il s\'agit, il est préférable de ne pas l\'activer.';
$_lang["settings_strip_image_paths_title"] = 'Chemins relatifs des images ?';
$_lang["settings_templvars"] = 'Variables de modèle';
$_lang["settings_title"] = 'Configuration';
$_lang["settings_ui"] = 'Réglages interface et éditeur';
$_lang["settings_users"] = 'Réglages utilisateurs';
$_lang["showing"] = 'Affichage';
$_lang["show_preview"] = 'Afficher la fenêtre de prévisualisation';
$_lang["show_tree"] = 'Afficher l\'arbre';
$_lang["signupemail_message"] = 'Vous pouvez taper ici le message envoyé à vos utilisateurs lors de la création de leur compte. Ce message contiendra leur login et leur mot de passe. <strong>Remarque&nbsp;:</strong> Les codes %s sont remplacés par MODx quand il envoie le message. Le premier %s est remplacé par le login, et le second par le mot de passe. <strong>Laissez les deux codes %s dans le email, sans quoi le login et le mot de passe ne seront pas envoyés dans le email et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["signupemail_title"] = 'Message d\'inscription :';
$_lang["site"] = 'Site';
$_lang["sitename_message"] = 'Tapez ici le nom de votre site.';
$_lang["sitename_title"] = 'Nom du site :';
$_lang["sitestart_message"] = 'Tapez ici le numéro du document que vous voulez utiliser comme page d\'accueil. <strong>ATTENTION&nbsp;! Assurez-vous que ce numéro est bien celui d\'un document existant et qu\'il est publié&nbsp;!</strong>';
$_lang["sitestart_title"] = 'Page d\'accueil du site :';
$_lang["sitestatus_message"] = 'Choisissez «&nbsp;En ligne&nbsp;» pour publier votre site sur le web. Si vous choisissez «&nbsp;Hors ligne&nbsp;», vos visiteurs se verront afficher le message d\'indisponibilité et ne pourront pas visiter le site.';
$_lang["sitestatus_title"] = 'Statut du site :';
$_lang["siteunavailable_message"] = 'Ce message est affiché lorsque le site est «&nbsp;Hors ligne&nbsp;» ou si une erreur se produit. <strong>Ce message ne sera affiché que si l\'option d\'afficher une page d\'indisponibilité n\'est pas utilisée.</strong>';
$_lang["siteunavailable_page_message"] = 'Tapez ici le numéro du document que vous voulez utiliser comme page lorsque le site est indisponible. <strong>Remarque&nbsp;:</strong> assurez-vous que ce numéro appartient à un document existant et que ce document est publié&nbsp;!';
$_lang["siteunavailable_page_title"] = 'Page site indisponible&nbsp;:';
$_lang["siteunavailable_title"] = 'Message d\'indisponibilité :';
$_lang["site_schedule"] = 'Programme du site';
$_lang["snippet"] = 'Snippet';
$_lang["snippets_availabe"] = 'Snippets disponibles pour cette page';
$_lang["snippet_code"] = 'Code source du snippet (php)';
$_lang["snippet_desc"] = 'Description du snippet';
$_lang["snippet_execonsave"] = 'Lancer l\'exécution du snippet après l\'enregistrement.';
$_lang["snippet_management_msg"] = 'Cette section vous permet de créer et de modifier des snippets.';
$_lang["snippet_msg"] = 'Cette section vous permet de créer et de modifier des snippets. Attention, les snippets sont codé en PHP «pur», et si vous vous voulez que l\'output du snippet s\'affiche à un certain endroit d\'un modèle, il doit y avoir dans le snippet une variable du même nom que le snippet lui-même. En clair, l\'output du snippet doit être enregistré dans une variable portant le même nom que le snippet.';
$_lang["snippet_name"] = 'Nom du snippet';
$_lang["snippet_properties"] = 'Propriétés par défaut';
$_lang["snippet_title"] = 'Créer/modifier un snippet';
$_lang["sort_asc"] = 'Ascendant';
$_lang["sort_desc"] = 'Descendant';
$_lang["sort_tree"] = 'Trier';
$_lang["source"] = 'Source';
$_lang["stay"] = 'Continuer l\'édition';
$_lang["stay_new"] = 'Ajouter un autre';
$_lang["submit"] = 'Submit';
$_lang["sunday"] = 'Dimanche';
$_lang["sysinfo_activity_message"] = 'Cette liste affiche les documents ayant été récemment modifiés ou créés par vos utilisateurs.';
$_lang["sysinfo_userid"] = 'Utilisateur';
$_lang["system_email_signup"] = 'Bonjour [+uid+] Voici vos paramètres de connexion pour le gestionnaire de contenu de [+sname+] ([+surl+]): Nom d\'utilisateur: [+uid+] Mot de passe: [+pwd+]. Une fois connecté au gestionnaire de contenu, vous pourrez changer votre mot de passe. Salutations, l\'administrateur du site';
$_lang["system_email_webreminder"] = 'Bonjour [+uid+] Pour activer votre nouveau mot de passe, cliquez sur le lien suivant: [+surl+]. Si tout se passe normalement vous pourrez utiliser le mot de passe suivant pour vous identifier: Mot de passe:[+pwd+]. Si vous n\'aviez pas demandé ce email, alors n\'en tenez pas compte. Salutations,l\'administrateur du site';
$_lang["system_email_websignup"] = 'Bonjour [+uid+] Voici vos paramètres de connexion pour [+sname+]: Nom d\'utilisateur: [+uid+] Mot de passe: [+pwd+]. Une fois connecté en tant que [+sname+] ([+surl+]), vous pourrez changer votre mot de passe. Salutations, l\'administrateur du site';
$_lang["sys_alert"] = 'Alerte système';
$_lang["table_hoverinfo"] = 'Passer le curseur de la souris sur un nom de table pour voir une courte description de sa fonction (Toutes les tables n\'en disposent pas).';
$_lang["table_prefix"] = 'Préfixe de la table';
$_lang["tag"] = 'Balise';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Variables de modèle associées';
$_lang["template_code"] = 'Code source du modèle (html)';
$_lang["template_desc"] = 'Description ';
$_lang["template_edit_tab"] = 'Editer le modèle';
$_lang["template_locked_message"] = 'Ce modèle est verrouillé.';
$_lang["template_management_msg"] = 'Cette section vous permet de créer et de modifier des modèles.';
$_lang["template_msg"] = 'Cette section vous permet de créer et de modifier des modèles. Les modèles créés ou modifiés ne seront pas actualisés dans les pages en cache de votre site jusqu\'à ce que le cache soit vidé. Cependant, vous pouvez utiliser la fonction de prévisualisation d\'une page pour afficher la mise en page du nouveau modèle.';
$_lang["template_name"] = 'Nom du modèle ';
$_lang["template_no_tv"] = 'Aucune variable de modèle associées à ce modèle pour le moment.';
$_lang["template_reset_all"] = 'Utiliser sur toutes les pages le modèle par défaut';
$_lang["template_reset_specific"] = 'Seulement sur les pages %s';
$_lang["template_title"] = 'Créer/modifier un modèle';
$_lang["template_tv_edit"] = 'Modifier l\'ordre de tri des variables de modèle';
$_lang["template_tv_msg"] = 'Les variables de modèles associées à ce modèle sont listés ci-dessous.';
$_lang["thursday"] = 'Jeudi';
$_lang["tmplvars"] = 'Variables de modèle';
$_lang["tmplvars_binding_msg"] = 'Ce champ supporte les liens à une source de données utilisant les commandes @';
$_lang["tmplvars_caption"] = 'Légende';
$_lang["tmplvars_default"] = 'Valeur par défaut';
$_lang["tmplvars_description"] = 'Description';
$_lang["tmplvars_elements"] = 'Valeurs optionnelles d\'entrée';
$_lang["tmplvars_management_msg"] = 'Vous pouvez gérer ici les champs supplémentaires pour vos documents.';
$_lang["tmplvars_msg"] = 'Cette section vous permet d\'ajouter/de modifier les variables de modèle. Les variables de modèle doivent être activées pour certains modèles afin qu\'elles puissent être utilisées à partir de snippets et de documents comme n\'importe quelle autre variable de contenu.';
$_lang["tmplvars_name"] = 'Nom de variable';
$_lang["tmplvars_novars"] = 'Aucune variable de modèle trouvée';
$_lang["tmplvars_rank"] = 'Ordre de tri';
$_lang["tmplvars_reset_params"] = 'Paramètres à zéro';
$_lang["tmplvars_type"] = 'Type d\'entrée';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Propriétés du widget';
$_lang["tmplvar_access_msg"] = 'Sélectionner les groupes de documents ayant l\'autorisation de modifier le contenu ou la valeur de cette variable';
$_lang["tmplvar_change_template_msg"] = 'La modification de ce modèle générera le rechargement des variables de modèles de la page. Les changements non enregistrés seront perdus.\n\n Voulez-vous vraiment modifier ce modèle&nbsp;?';
$_lang["tmplvar_inuse"] = 'Le(s) document(s) suivant(s) utilisent actuellement cette variable de modèle. Pour confirmer la suppression, cliquer sur le bouton Supprimer. Dans le cas contraire, cliquer sur le bouton Annuler.';
$_lang["tmplvar_tmpl_access"] = 'Accès au modèle';
$_lang["tmplvar_tmpl_access_msg"] = 'Sélectionner les modèles pouvant accéder à cette variable et l\'utiliser';
$_lang["to"] = 'à';
$_lang["tools"] = 'Outils';
$_lang["top_howmany_message"] = 'Lors de l\'affichage des statistiques, combien d\'éléments avec les plus hautes statistiques doivent être affichés dans les listes ?';
$_lang["top_howmany_title"] = 'Lignes à afficher :';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'l\'enregistrement de visites vous permettra d\'afficher des statistiques d\'utilisation de votre site. Cependant, cela ralentit un peu l\'analyseur du site. Si les statistiques des visites ne vous intéressent pas particulièrement, vous pouvez sans risque les désactiver et apprécier l\'augmentation de vitesse.';
$_lang["track_visitors_title"] = 'Enregistrer les visites :';
$_lang["tree_show_protected"] = 'Montrer les pages protégées';
$_lang["tree_show_protected_message"] = 'Lorsque cette option est sur "Non", les pages protégées (et tous leurs enfants) ne seront pas visibles dans l\'arbre des documents aux utlisateurs hors du groupe d\'utilisateur autorisé. ""Non" était le réglage par défaut dans les versions antérieures."Oui" permet de donner accès à vos utilisateur aux enfants d\'un document protégé sans donner accès pour autant au parent.';
$_lang["truncate_table"] = 'Cliquez ici pour tronquer cette table';
$_lang["tuesday"] = 'Mardi';
$_lang["tv"] = 'Variable de modèle';
$_lang["type"] = 'Type';
$_lang["udperms_allowroot_message"] = 'Voulez-vous autoriser à vos utilisateurs la création de nouveaux documents/répertoires à la racine du site&nbsp;?';
$_lang["udperms_allowroot_title"] = 'Accès racine :';
$_lang["udperms_message"] = 'Les autorisations d\'accès vous permettent d\'indiquer quelles pages peuvent modifier vos utilisateurs. Vous devrez assigner les utilisateurs à des groupes d\'utilisateurs, vos documents à des groupes de documents et spécifier quels groupes d\'utilisateurs peuvent modifier quels groupes de documents. La première fois vous activez les autorisations d\'accès, seuls les administrateurs peuvent modifier des documents.';
$_lang["udperms_title"] = 'Utiliser les autorisations d\'accès :';
$_lang["unable_set_link"] = 'Impossible de définir le lien !';
$_lang["unable_set_parent"] = 'Impossible de fixer le nouveau parent !';
$_lang["unauthorizedpage_message"] = 'Tapez ici le numéro du document que vous voulez afficher aux utilisateurs s\'ils demandent un document sécurisé ou auxquel ils n\'ont pas accès. <strong>ATTENTION&nbsp;! Assurez-vous que ce numéro est bien celui d\'un document existant, qu\'il est publié et accessible par tout le monde&nbsp;!</strong>';
$_lang["unauthorizedpage_title"] = 'Page non autorisée&nbsp;:';
$_lang["unblock_message"] = 'Une fois ces données enregistrées, cet utilisateur sera débloqué !';
$_lang["undelete_document"] = 'Rétablir document';
$_lang["unpublish_date"] = 'Date de dépublication';
$_lang["unpublish_document"] = 'Dépublier document';
$_lang["unpublish_events"] = 'Dépublication(s)';
$_lang["untitled_document"] = 'Page sans titre';
$_lang["untitled_weblink"] = 'Lien sans titre';
$_lang["update_params"] = 'Mettre à jour l\'affichage des paramètres';
$_lang["uploadable_files_message"] = 'Vous pouvez taper ici une liste de types de fichiers peuvant être téléchargés avec le gestionnaire de fichiers. Veuillez taper les extensions correspondant aux types de fichiers, séparées par des virgules.';
$_lang["uploadable_files_title"] = 'Types de fichier téléchargeables :';
$_lang["uploadable_flash_message"] = 'Vous pouvez saisir ici une liste de types de fichier à déposer dans "assets/flash/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers Flash  (swf, flv...), séparées par des virgules.';
$_lang["uploadable_flash_title"] = 'Types Flash autorisés :';
$_lang["uploadable_images_message"] = 'Vous pouvez saisir ici une liste de types fichier à déposer dans "assets/images/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers Image  (jpg, jpeg, png...), séparées par des virgules.';
$_lang["uploadable_images_title"] = 'Types d\'image autorisés :';
$_lang["uploadable_media_message"] = 'Vous pouvez saisir ici une liste de types fichier à déposer dans "assets/media/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers multimédia  (mov, avi...), séparées par des virgules.';
$_lang["uploadable_media_title"] = 'Types de contenus multimédia autorisés :';
$_lang["upload_maxsize_message"] = 'Taper ici la taille maximale des fichiers pourvant être téléchargés à l\'aide du gestionnaire de fichiers. La taille doit être spécifiée en octets. <strong>Attention&nbsp;! De gros fichiers peuvent prendre très longtemps à télécharger&nbsp;!</strong>';
$_lang["upload_maxsize_title"] = 'Taille maximale de téléchargement';
$_lang["user"] = 'Utilisateur';
$_lang["username"] = 'Votre nom d\'utilisateur ';
$_lang["users"] = 'Utilisateurs';
$_lang["user_block"] = 'Bloqué';
$_lang["user_blockedafter"] = 'Bloqué après';
$_lang["user_blockeduntil"] = 'Bloqué jusqu\'au';
$_lang["user_changeddata"] = 'Vos données ont été actualisées. Merci de vous identifier à nouveau.';
$_lang["user_country"] = 'Pays';
$_lang["user_dob"] = 'Date de naissance';
$_lang["user_doesnt_exist"] = 'User does not exist';
$_lang["user_edit_self_msg"] = '<br /><br />Pour que les informations soient effectivement mises à jour, il vous faudra vous déconnecter, puis vous reconnecter.</strong><br />En outre, si vous choisissez de générer un nouveau mot de passe pour vous-même, il vous sera envoyé par email.';
$_lang["user_email"] = 'Adresse email ';
$_lang["user_failedlogincount"] = 'Connexions échouées ';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Féminin';
$_lang["user_full_name"] = 'Nom complet ';
$_lang["user_gender"] = 'Sexe';
$_lang["user_is_blocked"] = 'Cet utilisateur est bloqué !';
$_lang["user_logincount"] = 'Nombre de connexions ';
$_lang["user_male"] = 'Masculin';
$_lang["user_management_msg"] = 'Cette section vous permet de créer et de modifier des utilisateurs.';
$_lang["user_management_title"] = 'Gestion utilisateurs';
$_lang["user_mobile"] = 'Téléphone mobile ';
$_lang["user_phone"] = 'Téléphone ';
$_lang["user_photo"] = 'Photo utilisateur';
$_lang["user_photo_message"] = 'Taper l\'URL de l\'image pour cet utilisateur ou utiliser le bouton insérer pour sélectionner ou télécharger une image sur le serveur.';
$_lang["user_prevlogin"] = 'Dernière connexion ';
$_lang["user_role"] = 'Rôle de l\'utilisateur ';
$_lang["user_state"] = 'État';
$_lang["user_title"] = 'Créer/modifier un utilisateur';
$_lang["user_upload_message"] = ' Si vous souhaitez empêcher cet utilisateur de déposer n\'importe quel type de fichier dans cette catégorie, assurez vous que la case "Utiliser la configuration par défaut" n\'est pas cochée et de laisser ce champ vide.';
$_lang["user_use_config"] = 'Utiliser la configuration par défaut';
$_lang["user_zip"] = 'Code postal';
$_lang["use_alias_path_message"] = 'l\'activation de cette option permet l\'affichage de chemin d\'accès complet au document, si celui-ci a un alias. Par exemple, si un document dont l\'alias est «&nbsp;fils&nbsp;» est placé dans un dossier d\'alias «&nbsp;parent&nbsp;», le chemin «&nbsp;/parent/child.html&nbsp;» sera affiché comme URL du document.<br /><strong>Remarque&nbsp;: si cette option est activée, les références à vos fichiers (images, css, javascripts, etc.) doivent être absolues, par exemple «&nbsp;/assets/images&nbsp;» au lieu de «&nbsp;assets/images&nbsp;». Ceci permet d\'éviter que le navigateur ou le serveur web ajoute le chemin relatif au chemin de l\'alias.</strong>';
$_lang["use_alias_path_title"] = 'Chemin d\'accès pour les alias simples&nbsp;:';
$_lang["use_editor_message"] = 'Voulez-vous activer l\'éditeur WYSIWYG ? Si vous êtes plus à l\'aise avec le code HTML, ce réglage vous permet de désactiver l\'éditeur. Ce réglage s\'applique à tous les documents et à tous les utilisateurs !';
$_lang["use_editor_title"] = 'Activer l\'éditeur :';
$_lang["value"] = 'Valeur';
$_lang["version_codename"] = "Nom de code de version";
$_lang["view"] = 'Afficher';
$_lang["view_child_documents_in_container"] = "Voir les documents enfants";
$_lang["view_document"] = 'Afficher page';
$_lang["view_log"] = 'Afficher l\'historique';
$_lang["view_logging"] = 'Historiques';
$_lang["view_sysinfo"] = 'Afficher infos système';
$_lang["warning"] = 'Attention !';
$_lang["warning_not_saved"] = 'Les changements que vous avez fait n\'ont pas été encore enregistrés. Vous pouvez choisir de rester sur cette page pour enregistrer vos modifications (Annuler), ou vous pouvez quitter cette page, et perdrez ainsi toutes les modifications que vous avez effectuées (OK).';
$_lang["weblink"] = 'Lien';
$_lang["weblink_message"] = 'Un lien est une référence à un objet sur Internet. Ce peut être un document dans MODx, une page sur un autre site, une image ou tout autre fichier accessible sur Internet.<br /><br />';
$_lang["webpwdreminder_message"] = 'Vous pouvez taper ici le message envoyé à vos utilisateurs web lorsqu\'ils demandent un nouveau mot de passe. Le gestionnaire de contenu leur enverra un message avec leur nouveau mot de passe et l\'information permettant de l\'activer. <br /><strong>Remarque&nbsp;:</strong> Le gestionnaire de contenu remplacera les champs suivants avant l\'envoi du message&nbsp;: <br /><br />[+sname+] - Nom de votre site web, <br />[+saddr+] - Adresse email du site web, <br />[+surl+] - Adresse URL de votre site web, <br />[+uid+] - Nom d\'utilisateur, <br />[+pwd+] - Mot de passe, <br />[+ufn+] - Nom complet de l\'utilisateur. <br /><br /><strong>Ne retirer pas les champs [+uid+] et [+pwd+] du message, sans quoi le nom d\'utilisateur et le mot de passe ne seront pas envoyés et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["webpwdreminder_title"] = 'Message pour nouveau mot de passe :';
$_lang["websignupemail_message"] = 'Vous pouvez taper ici le message envoyé à vos utilisateurs web lorsque vous créez pour eux un compte. Le système leur enverra par email leur nom d\'utilisateur et leur mot de passe. <br /><strong>Remarque&nbsp;:</strong> Le gestionnaire de contenu remplacera les champs suivants avant l\'envoi du message&nbsp;: <br /><br />[+sname+] - Nom de votre site web, <br />[+saddr+] - Adresse email du site web, <br />[+surl+] - Adresse URL de votre site web, <br />[+uid+] - Nom d\'utilisateur, <br />[+pwd+] - Mot de passe, <br />[+ufn+] - Nom complet de l\'utilisateur. <br /><br /><strong>Ne retirer pas les champs [+uid+] et [+pwd+] du message, sans quoi le nom d\'utilisateur et le mot de passe ne seront pas envoyés et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["websignupemail_title"] = 'Message pour inscription web :';
$_lang["web_access_permissions"] = 'Autorisations d\'accès web';
$_lang["web_access_permissions_user_group"] = 'Groupe d\'utilisateurs web :';
$_lang["web_access_permissions_user_groups"] = 'Groupes d\'utilisateurs web :';
$_lang["web_access_permissions_user_group_access"] = 'Groupes de documents auxquels le groupe d\'utilisateurs a accès :';
$_lang["web_permissions"] = 'Autorisations web';
$_lang["web_users"] = 'Utilisateurs web';
$_lang["web_user_management_msg"] = 'Vous pouvez choisir ici quel utilisateur web modifier. Les utilisateurs web sont ceux qui ne peuvent se connecter que sur le site web';
$_lang["web_user_management_title"] = 'Gestion utilisateurs web';
$_lang["web_user_title"] = 'Créer/modifier utilisateur web';
$_lang["wednesday"] = 'Mercredi';
$_lang["welcome_messages"] = 'Votre boîte contient <strong>%d</strong> message(s), dont <strong>%s</strong> non lu(s).';
$_lang["welcome_title"] = 'Bienvenue à votre gestionnaire de contenu MODx';
$_lang["which_editor_message"] = 'Vous pouvez choisir ici l\'éditeur WYSIWYG que vous souhaitez utiliser. d\'autres éditeurs WYSIWYG à installer sont disponibles sur la page de téléchargement de MODx.';
$_lang["which_editor_title"] = 'Éditeur WYSIWYG à utiliser :';
$_lang["working"] = 'Patience...';
$_lang["wrap_lines"] = 'Retour à la ligne';
$_lang["xhtml_urls_title"] = 'URLs XHTML valides';
$_lang["xhtml_urls_message"] = 'Remplace les ampersand (&) dans les URLs par des entités html valides &<!-- -->amp;';
$_lang["yes"] = 'Oui';
$_lang["yourinfo_message"] = 'Informations sur votre compte utilisateur&nbsp;:';
$_lang["yourinfo_previous_login"] = 'Votre dernière connexion&nbsp;:';
$_lang["yourinfo_role"] = 'Votre rôle&nbsp;:';
$_lang["yourinfo_title"] = 'Vos informations';
$_lang["yourinfo_total_logins"] = 'Nombre total de connexions&nbsp;:';
$_lang["yourinfo_username"] = 'Connecté sous le nom&nbsp;:';
$_lang["you_got_mail"] = 'Vous avez un message';
?>
