<?php
/**
 * Filename:       includes/lang/francais.inc.php
 * Function:       French language file for MODx
 * Encoding:       ISO-8859-1 (Latin 1)
 * Author:         Nicolas Martignoni (Nissai), rvis par David Mollire pour la 0.9.6 (davidm)
 * Date:           2007/05/02
 * Version:        2.2
 * MODx version:   0.9.6
*/
// NOTE: Now alpha-sorted

setlocale (LC_ALL, 'fr_FR');

include_once(dirname(__FILE__).'/english.inc.php'); // fall back to English defaults if needed

$_lang["about_msg"] = 'MODx a t dvelopp  partir d\'Etomite. Il est plac sous licence <a href="../assets/docs/license.txt\">GPL</a>.';
$_lang["about_title"] = ' propos de MODx';
$_lang["access_permissions"] = 'Autorisations d\'accs';
$_lang["access_permissions_add_document_group"] = 'Nouveau groupe de documents';
$_lang["access_permissions_add_user_group"] = 'Nouveau groupe d\'utilisateurs';
$_lang["access_permissions_docs_message"] = 'Cocher ci-dessous les groupes de documents auxquels ce document doit appartenir';
$_lang["access_permissions_documents_in_group"] = '<strong>Documents dans le groupe :</strong> ';
$_lang["access_permissions_documents_tab"] = 'Les groupes de documents actuels sont affichs ci-dessous. Vous pouvez en crer de nouveaux, les renommer, les supprimer et voir quels documents sont membres des diffrents groupes (le survol par le pointeur du numro du document en affichera le nom). Pour ajouter un document  un groupe ou pour l\'en retirer, modifiez directement le document.';
$_lang["access_permissions_document_groups"] = 'Groupes de documents';
$_lang["access_permissions_introtext"] = 'Cette section vous permet de grer les groupes d\'utilisateurs et les groupes de documents utiliss pour les autorisations d\'accs. Pour ajouter un utilisateur  un groupe d\'utilisateurs, modifier l\'utilisateur et cocher les groupes auxquels il doit appartenir. Pour ajouter un document  un groupe d\'utilisateurs, modifier le document et cocher les groupes auxquels il doit appartenir.';
$_lang["access_permissions_links"] = 'Liens groupes d\'utilisateurs/de documents ';
$_lang["access_permissions_links_tab"] = 'Le tableau ci-dessous indique les groupes d\'utilisateurs ayant accs (c\'est--dire pouvant modifier ou crer des enfants)  des groupes de document. Pour lier un groupe de documents  un groupe d\'utilisateurs, choisissez le groupe  partir du menu droulant, et cliquez sur le Ajouter le groupe. Pour retirer un groupe, cliquez sur Retirer ->. Le lien sera immdiatement supprim.';
$_lang["access_permissions_no_documents_in_group"] = 'Nant.';
$_lang["access_permissions_no_users_in_group"] = 'Nant.';
$_lang["access_permissions_off"] = '<span class="warning">Les autorisations d\'accs ne sont pas actives.</span> Les modifications faites ici n\'auront aucun effet jusqu\' ce que les autorisations d\'accs soient actives.';
$_lang["access_permissions_users_in_group"] = '<strong>Utilisateurs dans le groupe :</strong> ';
$_lang["access_permissions_users_tab"] = 'Les groupes d\'utilisateurs actuels sont affichs ci-dessous. Vous pouvez en crer de nouveaux, les renommer, les supprimer et voir quels utilisateurs sont membres des diffrents groupes. Pour ajouter un nouvel utilisateur  un groupe ou pour l\'en retirer, modifiez directement l\'utilisateur. Les administrateurs ont toujours accs  tous les documents. Ils n\'est donc pas ncessaire de les ajouter  aucun groupe.';
$_lang["access_permissions_user_group"] = 'Groupe d\'utilisateurs';
$_lang["access_permissions_user_groups"] = 'Groupes d\'utilisateurs';
$_lang["access_permissions_user_group_access"] = 'Groupes de documents auxquels le groupe d\'utilisateurs a accs :';
$_lang["access_permissions_user_message"] = 'Vous pouvez choisir ici les groupes d\'utilisateurs auxquels cet utilisateur appartient';
$_lang["access_permission_denied"] = 'Vous n\'avez pas les autorisations ncessaires pour modifier ce document.';
$_lang["access_permission_parent_denied"] = 'Vous n\'avez pas l\'autorisation de crer ou de dplacer un document ici !';
$_lang["account_email"] = 'Email du compte utilisateur';
$_lang["actioncomplete"] = '<strong>l\'action a t accomplie avec succs&nbsp;!</strong><br /> - Veuillez patienter un instant.';
$_lang["activity_message"] = 'Cette liste contient les documents que vous avez modifis ou crs rcemment&nbsp;:';
$_lang["activity_title"] = 'Documents rcents';
$_lang["add"] = 'Ajouter';
$_lang["add_chunk"] = 'Ajouter un chunk';
$_lang["add_doc"] = 'Ajouter un document';
$_lang["add_document"] = 'Nouveau document';
$_lang["add_folder"] = 'Nouveau dossier';
$_lang["add_plugin"] = 'Ajouter un plugin';
$_lang["add_snippet"] = 'Ajouter un snippet';
$_lang["add_tag"] = 'Ajouter balise';
$_lang["add_template"] = 'Ajouter un modle';
$_lang["add_tv"] = 'Ajouter une variable de modle';
$_lang["add_weblink"] = 'Nouveau lien';
$_lang["administrator_role_message"] = 'Ce rle ne peut tre ni modifi, ni supprim.';
$_lang["after_saving"] = 'After saving';
$_lang["alert_delete_self"] = 'Vous ne pouvez pas supprimer votre propre compte !';
$_lang["alias"] = 'Alias';
$_lang["allow_mgr_access"] = 'Accs  l\'interface du gestionnaire';
$_lang["allow_mgr_access_message"] = 'Slectionnez cette option pour permettre ou non l\'accs  l\'interface du gestionnaire.<br /><strong>ATTENTION ! Si vous avez dsactiv cette option, l\'utilisateur sera dirig automatiquement vers la page de connexion au gestionnaire ou vers la page d\'accueil du site web.</strong>';
$_lang["all_doc_groups"] = 'Tous les groupes de documents (Public)';
$_lang["all_events"] = 'Tous les vnements';
$_lang["all_usr_groups"] = 'Tous les groupes (Public)';
$_lang["already_deleted"] = 'a dj t supprim.';
$_lang["attachment"] = 'Annexe';
$_lang["automatic_alias_message"] = 'Une fois activ, le gestionnaire gnrera automatiquement un alias  partir du titre de la page lors de son enregistrement.';
$_lang["automatic_alias_title"] = 'Gnrer automatiquement les alias :';
$_lang["backup"] = 'Sauvegarde';
$_lang["bk_manager"] = 'Gestion des sauvegardes';
$_lang["blocked_minutes_message"] = 'Vous pouvez saisir ici le nombre de minutes durant lesquelles un utilisateur sera bloqu s\'il atteint le nombre maximum de tentative de login. Attention de ne saisir qu\'une valeur numrique (pas de virgule, d\'espace...etc)';
$_lang["blocked_minutes_title"] = 'Dure de blocage (en minutes):';
$_lang["block_message"] = 'Une fois ces donnes enregistres, cet utilisateur sera bloqu !';
$_lang["cache_files_deleted"] = 'Les fichiers suivants ont t supprims :';
$_lang["cancel"] = 'Annuler';
$_lang["captcha_code"] = 'Code de scurit';
$_lang["captcha_message"] = 'Activer les codes CAPTCHA permet de renforcer la scurit en exigeant des utilisateurs d\'crire un code illisible par des machines (automates).';
$_lang["captcha_title"] = 'Utiliser les codes CAPTCHA :';
$_lang["captcha_words_message"] = 'Vous pouvez ici taper une liste de mots  utiliser si CAPTCHA est activ. Sparez les mots par des virgules. Ce champ est limit  255 caractres.';
$_lang["captcha_words_title"] = 'Mots CAPTCHA';
$_lang["category_heading"] = 'Catgorie';
$_lang["category_msg"] = 'Vous pouvez voir ici toutes les ressources groupes par catgorie.';
$_lang["change_name"] = 'Modifier le nom';
$_lang["change_password"] = 'Changer mot de passe';
$_lang["change_password_confirm"] = 'Retaper le mot de passe ';
$_lang["change_password_message"] = 'Veuillez taper votre nouveau mot de passe, puis le retaper pour confirmation.<br />Votre mot de passe doit contenir entre 6 et 15 caractres.';
$_lang["change_password_new"] = 'Nouveau mot de passe ';
$_lang["charset_message"] = 'Veuillez choisir l\'encodage de caractres que vous souhaitez utiliser dans le gestionnaire. MODx a t test avec bon nombre d\'encodages, mais pas avec tous. Pour la plupart des langues, y compris le franais, le rglage par dfaut (utf-8) convient.';
$_lang["charset_title"] = 'Encodage des caractres :';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Code source du chunk (html)';
$_lang["cleaningup"] = 'Nettoyage';
$_lang["clear_log"] = 'Vider l\'historique';
$_lang["click_to_context"] = 'Cliquer pour accder au menu contextuel';
$_lang["click_to_edit_title"] = 'Gliquez ici pour afficher cet enregistrement';
$_lang["click_to_view_details"] = 'Cliquer ici pour afficher les dtails';
$_lang["close"] = 'Fermer';
$_lang["collapse_tree"] = 'Rduire';
$_lang["comment"] = 'Commentaire';
$_lang["configcheck_admin"] = 'Merci de contacter un administrateur et de lui communiquer le contenu de ce message !';
$_lang["configcheck_cache"] = 'Rpertoire cache non modifiable ';
$_lang["configcheck_cache_msg"] = 'MODx ne peut pas crire dans le rpertoire cache. Il fonctionnera normalement, le cache ne fonctionnera pas. Pour corriger ce problme, veuillez permettre l\'criture dans le rpertoire /_cache/.';
$_lang["configcheck_configinc"] = 'Le fichier de configuration est modifiable.';
$_lang["configcheck_configinc_msg"] = 'Des personnes mal intentionnes pourrait modifier la configuration de votre site (notamment, login et mot de passe). Modifiez <strong>immdiatement</strong> les permissions de votre fichier de configuration (/manager/includes/config.inc.php) en lecture seule (effectuez un CHMOD 644)!';
$_lang["configcheck_default_msg"] = 'Une erreur inconnue est survenue. Merci de rapporter celle-ci via notre <a href="http://MODxcms.com/bugs\">bugtracker</a>';
$_lang["configcheck_errorpage_unavailable"] = 'La page d\'erreur de votre site n\'est pas dfinie.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Cela signifie que votre page d\'erreur n\'est pas accessible  vos visiteurs ou qu\'elle n\'existe pas. Cela peut provoquer une boucle infinie, gnrer des erreurs dans vos logs. Assurez vous qu\'aucun groupe utilisateur n\'est dfini pour cette page.';
$_lang["configcheck_errorpage_unpublished"] = 'La page d\'erreur de votre site n\'est pas publie ou n\'existe pas.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Cela signifie qu\'elle n\'est pas accessible au public. Publiez cette page ou assurez vous que le numro d\'ID de la page est valide dans Outils > Configuration.';
$_lang["configcheck_images"] = 'Rpertoire d\'images pas accessible en criture';
$_lang["configcheck_images_msg"] = 'Le rpertoire des images n\'a pas les autorisations en criture ou n\'existe pas. Par consquent, les fonctions de gestion d\'images de l\'diteur WYSIWYG ne fonctionneront pas !';
$_lang["configcheck_installer"] = 'Installeur encore prsent ';
$_lang["configcheck_installer_msg"] = 'Le rpertoire &nbsp;install/&nbsp; contient l\'installeur de MODx. Imaginez un instant ce qui pourrat arriver  votre site si une personne mal intentionne trouve ce rpertoire et excute l\'installeur&nbsp;! Il n\'irait probablement pas bien loin, parce qu\'il devra taper les informations de l\'utilisateur de la base de donnes, mais il est bien plus sr de supprimer ce rpertoire de votre serveur.';
$_lang["configcheck_lang_difference"] = 'Nombre incorrect de variables dans le fichier de langue';
$_lang["configcheck_lang_difference_msg"] = 'La langue actuellement choisie ($manager_language) a un nombre de variables diffrent de la langue par dfaut. Ceci n\'est pas ncessairement un problme, mais peut signifier que le fichier de langue doit tre mis  jour.';
$_lang["configcheck_notok"] = 'Un ou plusieurs dtails de configuration ne sont pas valides&nbsp;:';
$_lang["configcheck_ok"] = 'Le contrle s\'est bien pass - aucun avertissement rapport.';
$_lang["configcheck_register_globals"] = 'register_globals est sur "ON" dans votre fichier de configuration php (php.ini)';
$_lang["configcheck_register_globals_msg"] = 'Cette configuration rend votre site vulnrable aux attaques <a href="http://www.commentcamarche.net/attaques/cross-site-scripting.php3">XCSS</a> (cross site scripting). Consulter votre hbergeur sur la marche  suivre pour dsactiver ce rglage.';
$_lang["configcheck_title"] = 'Contrle de configuration';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'La page "accs non autoris" n\'est pas publie ou n\'existe pas.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Cela signifie que cette page n\'est pas accessible  vos visiteurs ou n\'existe pas. Cela peut provoquer une boucle infinie, gnrer des erreurs dans vos logs. Assurez vous qu\'aucun groupe utilisateur n\'est dfini pour cette page.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La page "accs non autoris" dfinie dans la configuration du site n\'est pas publie.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Cela signifie que la page "accs non autoris" n\'est pas accessible au public. Publiez cette page ou assurez vous que le numro d\'ID de la page est valide dans Outils > Configuration.';
$_lang["configcheck_warning"] = 'Avertissement de configuration&nbsp;:';
$_lang["configcheck_what"] = 'Que signifie ceci&nbsp;?';
$_lang["confirm_block"] = 'Voulez-vous vraiment bloquer cet utilisateur ?';
$_lang["confirm_delete_document"] = 'Voulez-vous vraiment supprimer ce document ?\nTous les documents enfants seront galement supprims.';
$_lang["confirm_delete_eventlog"] = 'Voulez-vous vraiment supprimer cet historique ?';
$_lang["confirm_delete_file"] = 'Voulez-vous vraiment supprimer ce fichier ?\n\nUne telle opration pourrait empcher votre site de fonctionner correctement ! Ne supprimez ce fichier que si vous tes absolument certain de ne rien casser.';
$_lang["confirm_delete_htmlsnippet"] = 'Voulez-vous vraiment supprimer ce chunk ?';
$_lang["confirm_delete_keywords"] = 'Voulez-vous vraiment supprimer ce mots cls ?';
$_lang["confirm_delete_module"] = 'Voulez-vous vraiment supprimer ce module&nbsp;?';
$_lang["confirm_delete_plugin"] = 'Voulez-vous vraiment supprimer ce plugin?';
$_lang["confirm_delete_record"] = 'Voulez-vous vraiment supprimer les enregistrements slectionns ?';
$_lang["confirm_delete_role"] = 'Voulez-vous vraiment supprimer ce rle ?';
$_lang["confirm_delete_snippet"] = 'Voulez-vous vraiment supprimer ce snippet ?';
$_lang["confirm_delete_tags"] = 'Voulez-vous vraiment supprimer les balises META slectionnes ?';
$_lang["confirm_delete_template"] = 'Voulez-vous vraiment supprimer ce modle ?';
$_lang["confirm_delete_tmplvars"] = 'Voulez-vous vraiment supprimer cette variable et toutes ses valeurs enregistres&nbsp;?';
$_lang["confirm_delete_user"] = 'Voulez-vous vraiment supprimer cet utilisateur ?';
$_lang["confirm_duplicate_document"] = 'Voulez-vous vraiment dupliquer ce document/dossier&nbsp;?\nLes sous-dossiers et pages incluses seront aussi dupliqus.';
$_lang["confirm_duplicate_record"] = 'Voulez-vous vraiment dupliquer cet enregistrement&nbsp;?';
$_lang["confirm_empty_trash"] = 'Vous allez supprimer de manire permanente TOUS les documents que vous avez mis  la corbeille !\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_load_depends"] = 'Voulez-vous vraiment charger la page du Gestionnaire des dpendances sans enregistrer vos modifications&nbsp;?';
$_lang["confirm_name_change"] = 'La modification du nom d\'un utilisateur peut influencer d\'autres applications lies au gestionnaire de contenu. \n\n Voulez-vous vraiment modifier le nom de cet utilisateur ?';
$_lang["confirm_publish"] = '\n\nSi vous publiez ce document maintenant, vous en supprimerez toutes les dates de (d)publications ayant t fixes. Si vous souhaitez fixer ou modifier les dates de (d)publication, veuillez plutt choisir de &nbsp;Modifier&nbsp; le document.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_remove_locks"] = 'Les utilisateurs ferment parfois leur navigateur alors qu\'ils modifient des documents, modle, snippets ou analyseurs. Ils laissent ainsi parfois verrouill l\'lment en cours d\'dition. En cliquant sur OK vous pouvez enlever TOUS les verrous actuellement en place.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_unblock"] = 'Voulez-vous vraiment dbloquer cet utilisateur ?';
$_lang["confirm_undelete"] = '\n\nTous les documents enfants supprims avec ce document seront rtablis, mais les documents enfants supprims plus tt seront encore marqus comme supprims.';
$_lang["confirm_unpublish"] = '\n\nSi vous dpubliez ce document maintenant, vous en supprimerez toutes les dates de (d)publications ayant t fixes. Si vous souhaitez fixer ou modifier les dates de (d)publication, veuillez plutt choisir de &nbsp;Modifier&nbsp; le document.\n\nVoulez-vous vraiment continuer ?';
$_lang["confirm_unzip_file"] = 'Voulez-vous vraiment dcompresser ce fichier ?\n\nLes fichiers de mme nom existant seront supprims.';
$_lang["could_not_find_user"] = 'Impossible de trouver cet utilisateur';
$_lang["createdon"] = 'Date cration';
$_lang["create_document_here"] = 'Crer page ici';
$_lang["create_folder_here"] = 'Crer un dossier ici';
$_lang["create_weblink_here"] = 'Crer lien ici';
$_lang["credits"] = 'Crdits';
$_lang["credits_dTree"] = 'MODx utilise l\'excellent script dTree de DestroyDrop.com.';
$_lang["credits_everaldo"] = 'MODx utilise plusieurs icnes du jeu d\'icnes Crystal d\'Everaldo.';
$_lang["credits_mysql"] = 'MODx fonctionne avec MySQL.';
$_lang["credits_php"] = 'MODx fonctionne grce  PHP.';
$_lang["credits_shouts_msg"] = '<ul><li><strong>Raymond Irving, Ryan Thrash</strong> &ndash; Project Founders</li><li><strong>Jason Coward, Victor Brillon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</strong> &ndash; Core Architecture &amp; Design</li><li><strong>Nicolas Martignoni et David Mollire</strong> &ndash; Traduction franaise</li></ul>';
$_lang["credits_shouts_title"] = '<strong>Remerciements galement  :</strong>';
$_lang["credits_webfx"] = 'MODx utilise un certain nombre de JavaScript de Webfx.';
$_lang["custom_contenttype_message"] = 'Vous pouvez ajouter ici des types de contenu personnaliss pour vos documents. Pour ajouter un nouveau type, tapez-le dans le champ, puis cliquez le bouton &nbsp;Ajouter&nbsp;.';
$_lang["custom_contenttype_title"] = 'Types de contenu personnaliss&nbsp;:';
$_lang["database_name"] = 'Nom de la BDD';
$_lang["database_server"] = 'Nom du serveur de la BDD';
$_lang["database_tables"] = 'Tables de la BDD';
$_lang["database_overhead"] = '<b style=\'color:#990033\'>Note:</b> L\'overhead est un espace rserv par MySQL et qui est inutilis. Pour librer cet espace, cliquer sur le chiffre dans la colonne overhead.';
$_lang["database_table_clickhere"] = 'Cliquez ici';
$_lang["database_table_clickbackup"] = 'pour sauvegarder les tables slectionnes';
$_lang["database_table_datasize"] = 'Taille';
$_lang["database_table_droptablestatements"] = 'Gnrer les dclarations DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Taille relle';
$_lang["database_table_indexsize"] = 'Taille de l\'index';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Enregistrement';
$_lang["database_table_tablename"] = 'Nom de la table';
$_lang["database_table_totalsize"] = 'Taille totale';
$_lang["database_table_totals"] = 'Totaux:';
$_lang["date"] = 'Date';
$_lang["datechanged"] = 'Date de modification';
$_lang["defaultcache_message"] = 'Choisissez &nbsp;Oui&nbsp; pour permettre de mettre en cache les nouveaux documents par dfaut.';
$_lang["defaultcache_title"] = ' mettre en cache par dfaut :';
$_lang["defaultmenuindex_message"] = 'Slectionnez &nbsp;Oui&nbsp; pour activer l\'auto-incrmentation de l\'index de menu par dfaut.';
$_lang["defaultmenuindex_title"] = 'Auto-incrmentation de l\'index';
$_lang["defaultpublish_message"] = 'Choisissez &nbsp;Oui&nbsp; pour que tous les nouveaux documents soient publis par dfaut.';
$_lang["defaultpublish_title"] = 'Publi par dfaut :';
$_lang["defaultsearch_message"] = 'Choisissez &nbsp;Oui&nbsp; pour rendre tous les nouveaux documents rechercheables par dfaut.';
$_lang["defaultsearch_title"] = 'Rechercheable par dfaut :';
$_lang["defaulttemplate_message"] = 'Choisissez le modle que vous souhaitez utiliser par dfaut pour les nouveaux documents. Vous pourrez choisir un modle diffrent lors de la modification du document. Ce rglage indique simplement le modle slectionn initialement.';
$_lang["defaulttemplate_title"] = 'Modle par dfaut';
$_lang["delete"] = 'Supprimer';
$_lang["delete_document"] = 'Supprimer document';
$_lang["delete_tags"] = 'Supprimer balises';
$_lang["deleting_file"] = 'Suppression du fichier &nbsp;%s&nbsp; : ';
$_lang["description"] = 'Description';
$_lang["deselect_keywords"] = 'Supprimer les mots cls';
$_lang["deselect_metatags"] = 'Retirer les balises META';
$_lang["disabled"] = 'Dsactiv';
$_lang["document"] = 'Document';
$_lang["document_alias"] = 'Alias du document';
$_lang["document_alias_help"] = 'Vous pouvez ici dfinir un alias pour ce document. Le document pourra ainsi tre atteint  l\'adresse : http://votreserver/alias. Cette fonctionnalit n\'est active que si vous utilisez les URLs simples.';
$_lang["document_content"] = 'Contenu du document';
$_lang["document_description"] = 'Description ';
$_lang["document_description_help"] = 'Vous pouvez taper ici une description (facultative) du document.';
$_lang["document_long_title_help"] = 'Vous pouvez indiquer ici un plus long titre pour votre document. Un tel titre sera pratique pour des moteurs de recherche, et offrira une meilleure description de votre document.';
$_lang["document_metatag_help"] = 'Slectionnez les balises META et les mots-cls que vous dsirez associer  ce document. Vous pouvez slectionner plusieurs mots-cls ou balises (touche Majuscule ou Contrle).';
$_lang["document_opt_contentdispo"] = 'Affichage contenu';
$_lang["document_opt_contentdispo_help"] = 'Utilisez le champ Affichage contenu pour spcifier la faon dont le document doit tre trait par le navigateur web. Pour les fichiers  tlcharger, choisissez l\'option the Annexe.';
$_lang["document_opt_emptycache"] = 'Supprimer du cache ?';
$_lang["document_opt_emptycache_help"] = 'Cocher cette case si vous voulez que MODx supprime automatiquement le document du cache aprs son enregistrement. De cette faon, vos visiteurs auront accs  la dernire version du document et non pas  la version en cache.';
$_lang["document_opt_folder"] = 'Rpertoire ?';
$_lang["document_opt_folder_help"] = 'Cocher cette case pour dfinir ce document comme rpertoire d\'autres documents. Comme MODx prend gnralement soin automatiquement de ce rglage, n\'y attachez pas trop d\'importance.';
$_lang["document_opt_menu_index"] = 'Index de menu';
$_lang["document_opt_menu_index_help"] = 'l\'index de menu est une valeur que vous pouvez utiliser pour trier les documents dans vos snippets de menu. Vous pouvez galement l\'utiliser dans vos snippets  n\'importe quel autre fin.';
$_lang["document_opt_menu_title"] = 'Titre de menu';
$_lang["document_opt_menu_title_help"] = 'Le titre de menu est un champ que vous pouvez utiliser pour afficher un bref intitul du document dans vos snippets ou modules de menu.';
$_lang["document_opt_published"] = 'Publi ?';
$_lang["document_opt_published_help"] = 'Cocher cette case pour publier ce document immdiatement aprs son enregistrement.';
$_lang["document_opt_richtext"] = 'diteur WYSIWYG ?';
$_lang["document_opt_richtext_help"] = 'Cocher cette case si vous voulez utiliser l\'diteur WISIWYG pour modifier ce document. Si le document contient du JavaScript ou du code HTML, dcochez la case pour modifier le document en mode HTML, afin que l\'diteur WYSIWYG ne le dtriore pas.';
$_lang["document_opt_show_menu"] = 'Afficher dans le menu';
$_lang["document_opt_show_menu_help"] = 'Choisissez cette option pour afficher le document dans un menu web. Certains scripts de construction de menus peuvent ignorer cette option.';
$_lang["document_opt_trackvisit_help"] = 'Enregistrer les visites de chaque internaute sur cette page';
$_lang["document_overview"] = 'Rsum du document';
$_lang["document_parent"] = 'Document parent';
$_lang["document_parent_help"] = 'Cliquez sur l\'icne dossier ci-dessus pour activer ou dsactiver la slection d\'un parent, puis cliquer sur un document dans l\'arbre pour le choisir comme parent de ce document.';
$_lang["document_setting"] = 'Proprits du document';
$_lang["document_summary"] = 'Rsum';
$_lang["document_summary_help"] = 'Taper un bref rsum du document';
$_lang["document_title"] = 'Titre';
$_lang["document_title_help"] = 'Taper ici le nom du document. vitez d\'utiliser des antislashs (\) dans ce nom&nbsp;!';
$_lang["document_to_be_moved"] = 'Document  dplacer';
$_lang["document_weblink_help"] = 'Taper ici l\'adresse (URL) de l\'objet que vous souhaitez rfrencer.';
$_lang["documents_in_container"] = 'documents dans ce dossier';
$_lang["documents_in_container_no"] = 'Ce dossier n\'a aucun document enfant.';
$_lang["doc_data_title"] = 'Afficher les donnes du document';
$_lang["duplicate"] = 'Dupliquer';
$_lang["duplicate_alias_found"] = 'Le document &nbsp;%s&nbsp; utilise dj l\'alias &nbsp;%s&nbsp;. Veuillez choisir un alias unique.';
$_lang["duplicate_alias_message"] = 'Vous autorisez ici la cration de d\'alias identiques. <strong>Attention&nbsp;!</strong> Pour viter des problmes de rfrencement de documents, cette option ne doit tre active qu\'en conjonction avec l\'option &nbsp;Chemin d\'accs pour les alias simples&nbsp;.';
$_lang["duplicate_alias_title"] = 'Permettre les doublons d\'alias&nbsp;:';
$_lang["duplicate_document"] = 'Dupliquer un document';
$_lang["edit"] = 'Modifier';
$_lang["editedon"] = 'Date modification';
$_lang["editing_file"] = 'Modification fichier ';
$_lang["editor_css_path_message"] = 'Tapez le chemin du fichier CSS que vous dsirez utiliser dans l\'diteur. La meilleur faon de saisir le chemin est de l\'crire  partir de la racine de votre serveur, par exemple /assets/site/style.css. Si vous ne dsirez pas charger une feuille de style dans l\'diteur, laissez ce champ vide.';
$_lang["editor_css_path_title"] = 'Chemin du fichier CSS&nbsp;:';
$_lang["edit_document"] = 'Modifier page';
$_lang["edit_document_title"] = 'Crer/modifier un document';
$_lang["edit_settings"] = 'Configuration';
$_lang["email"] = 'email';
$_lang["emailsender_message"] = 'Vous pouvez indiquer l\'adresse email  utiliser pour envoyer aux nouveaux utilisateurs leur login et mot de passe.';
$_lang["emailsender_title"] = 'Adresse email :';
$_lang["emailsubject_message"] = 'Vous pouvez taper ici le sujet du message envoy par email aux nouveaux utilisateurs.';
$_lang["emailsubject_title"] = 'Sujet du message :';
$_lang["email_sent"] = 'Email sent';
$_lang["empty_folder"] = 'Ce rpertoire est vide';
$_lang["empty_recycle_bin"] = 'Vider la corbeille';
$_lang["empty_recycle_bin_empty"] = 'La corbeille ne contient aucun document  purger.';
$_lang["enabled"] = 'Activ';
$_lang["enable_resource"] = 'Activer le fichier ressource.';
$_lang["enable_sharedparams"] = 'Activer le partage des paramtres';
$_lang["enable_sharedparams_msg"] = '<strong>Attention&nbsp;!</strong> l\'identifiant unique global (GUID) ci-dessus ne sera utilis que pour distinguer ce module et ses paramtres partags. Le GUID est aussi utilis pour former un lien entre le module et les plugins ou snippets qui accdent  ses paramtres partags. ';
$_lang["error"] = 'Erreur';
$_lang["errorpage_message"] = 'Tapez ici le numro du document que vous voulez afficher aux utilisateurs s\'ils demandent un document qui n\'existe pas rellement. <strong>ATTENTION&nbsp;! Assurez-vous que ce numro est bien celui d\'un document existant et qu\'il est publi &nbsp;</strong>';
$_lang["errorpage_title"] = 'Page d\'erreur :';
$_lang["error_sending_email"] = 'Erreur durant l\'envoi de l\'email';
$_lang["eventlog"] = 'Historique vnements';
$_lang["eventlog_msg"] = 'l\'historique des vnements est utilis pour afficher des informations, des messages d\'avertissements ou d\'erreurs gnrs par le gestionnaire de contenu. La colonne &nbsp;source&nbsp; indique la section d\'o provient le message.';
$_lang["eventlog_viewer"] = 'Affichage historique';
$_lang["event_id"] = 'Id vnement';
$_lang["existing_category"] = 'Catgorie existante';
$_lang["expand_tree"] = 'Dvelopper';
$_lang["export_site"] = 'Exporter le site';
$_lang["export_site_cacheable"] = 'Inclure les fichiers non-cachables :';
$_lang["export_site_exporting_document"] = 'Exportation du fichier <strong>%s</strong> sur <strong>%s</strong><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><em>%s</em>, no %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style="color:#990000">chec !</span>';
$_lang["export_site_html"] = 'Exportation en HTMl';
$_lang["export_site_maxtime"] = 'Temps maximal d\'exportation :';
$_lang["export_site_maxtime_message"] = 'Vous pouvez indiquer ici la dure maximale (en secondes)  disposition de MODx pour exporter le site (remplace la configuration PHP). Tapez &nbsp;0&nbsp; pour une dure illimite. Il n\'est pas recommand de taper &nbsp;0&nbsp; ou un nombre trs lev, car dans ce cas des disfonctionnements de votre serveur pourront survenir.';
$_lang["export_site_message"] = '<p>Cette fonction vous permet d\'exporter la totalit du site en format HTML. Ce faisant, vous perdrez ainsi beaucoup de fonctionnalits de MODx :<p /><ul><li>les visites sur les fichiers exports ne seront pas comptabilises&nbsp;;</li><li>les snippets interactifs ne fonctionneront pas dans les fichiers exports&nbsp;;</li><li>seuls les documents seront exports, alors que les liens ne le seront pas&nbsp;;</li><li>le processus d\'exportation peut chouer si vos documents contiennent des snippets qui renvoient des en-ttes de redirection&nbsp;;</li><li>suivant la faon dont vous avez crit vos documents, feuilles de styles et images, la mise en page de votre site pourrait tre chamboule. Pour viter ceci, vous pouvez enrgistrer ou dplacer vos fichiers exports dans le rpertoire o se situe le fichier principal de MODx &nbsp;index.php&nbsp;&nbsp;;</li></ul><p />Veuillez remplir le formulaire et cliquer sur Commencer l\'exportation pour dbuter le processus. Les fichiers crs seront enregistrs  l\'endroit spcifi, en utilisant comme noms de fichiers, dans la mesure du possible, les alias de document. Lors de l\'exportation de votre site, il est prfrable d\'activer les &nbsp;Alias simples&nbsp; dans la configuration de MODx. Selon la taille de votre site, l\'exportation peut prendre un bon moment.<p /><strong>Si des fichiers de mme nom existent, ils seront crass par les nouveaux fichiers aux noms identiques !</strong><p />';
$_lang["export_site_numberdocs"] = '<strong>%s documents trouvs pour exportation...</strong>';
$_lang["export_site_prefix"] = 'Prfixe de fichier :';
$_lang["export_site_start"] = 'Commencer l\'exportation';
$_lang["export_site_success"] = '<span style="color:#009900">Succs !</span>';
$_lang["export_site_suffix"] = 'Suffixe de fichier :';
$_lang["export_site_target_unwritable"] = 'Impossible d\'crire dans le rpertoire cible. Veuillez vous assurer que les autorisations du rpertoire sont correctes et essayez  nouveau.';
$_lang["export_site_time"] = 'l\'exportation est termine. l\'opration a dur %s secondes.';
$_lang["failed_login_message"] = 'Vous pouvez spcifier ici le nombre de tentatives de login infructueuses avant qu\'un utilisateur ne soit bloqu.';
$_lang["failed_login_title"] = 'Tentatives de login infructueuses :';
$_lang["fe_editor_lang_message"] = 'Choisir une langue pour l\'diteur (utilis pour l\'dition en ligne, ct front-end).';
$_lang["fe_editor_lang_title"] = 'Langue de l\'diteur Front-End:';
$_lang["file_delete_file"] = 'Supprimer le fichier';
$_lang["file_delete_folder"] = 'Supprimer le rpertoire';
$_lang["filemanager_path_message"] = 'Souvent, IIS ne remplit pas correctement le rglage document_root, qui est utilis par le gestionnaire pour dterminer ce que vous pouvez voir. Si vous rencontrez des problmes avec le gestionnaire, assurez-vous que ce chemin pointe vers la racine de votre installation MODx.';
$_lang["filemanager_path_title"] = 'Chemin du Gestionnaire de fichiers :';
$_lang["files_access_denied"] = 'Accs interdit !';
$_lang["files_data"] = 'Donnes';
$_lang["files_directories"] = 'Rpertoires';
$_lang["files_dirwritable"] = 'Accs en criture ?';
$_lang["files_dir_listing"] = 'Contenu du rpertoire ';
$_lang["files_editfile"] = 'Modifier fichier';
$_lang["files_filename"] = 'Nom de fichier';
$_lang["files_fileoptions"] = 'Options';
$_lang["files_files"] = 'Fichiers';
$_lang["files_filesize"] = 'Taille';
$_lang["files_filetype_notok"] = 'Vous ne pouvez pas tlcharger ce type de fichier !';
$_lang["files_file_type"] = 'Type du fichier : ';
$_lang["file_folder_chmod_error"] = 'Impossible de modifier les permissions, vous allez devoir changer les permissions manuellement (FTP, SSH).';
$_lang["files_modified"] = 'Modification';
$_lang["files_title"] = 'Slection de fichiers';
$_lang["files_top_level"] = 'Vers la racine';
$_lang["files_uploadfile"] = 'Tlcharger';
$_lang["files_uploadfile_msg"] = 'Slectionner un fichier  tlcharger :';
$_lang["files_uploading"] = 'Tlchargement de <strong>%s</strong> dans <strong>%s/</strong><br />';
$_lang["files_upload_copyfailed"] = 'Le fichier n\'a pas pu tre copi dans le rpertoire de destination - le tlchargement a chou !';
$_lang["files_upload_error"] = 'Erreur';
$_lang["files_upload_error0"] = 'Un problme est survenu lors de votre tlchargement.';
$_lang["files_upload_error1"] = 'Le fichier que vous essayez de tlcharger est trop grand.';
$_lang["files_upload_error2"] = 'Le fichier que vous essayez de tlcharger est trop grand.';
$_lang["files_upload_error3"] = 'Le fichier que vous essayez de tlcharger n\'a t que partiellement tlcharg.';
$_lang["files_upload_error4"] = 'Veuillez slectionner un fichier  tlcharger.';
$_lang["files_upload_error5"] = 'Un problme est survenu lors de votre tlchargement.';
$_lang["files_upload_inhibited_msg"] = '<strong>Tlchargement est dsactiv</strong> - assurez-vous que votre serveur supporte le tlchargement et que PHP possde l\'autorisation d\'crire dans le rpertoire.<br />';
$_lang["files_upload_ok"] = 'Fichier tlcharg avec succs !';
$_lang["files_up_level"] = 'Niveau suprieur';
$_lang["files_viewfile"] = 'Afficher fichier';
$_lang["file_deleted"] = 'Succs !';
$_lang["file_download_file"] = 'Tlcharger fichier';
$_lang["file_download_unzip"] = 'Dcompresser fichier';
$_lang["file_folder_created"] = 'Le dossier a t cr !';
$_lang["file_folder_deleted"] = 'Le dossier a t supprim&nbsp;!';
$_lang["file_folder_not_created"] = 'Impossible de crer le dossier';
$_lang["file_folder_not_deleted"] = 'Impossible de supprimer le dossier. Veuillez vous assurer qu\'il est vide avant de le supprimer&nbsp;!';
$_lang["file_not_deleted"] = 'chec !';
$_lang["file_not_saved"] = 'Impossible d\'enregistrer le fichier. Veuillez vous assurer qu\'il est possible d\'crire dans le rpertoire cible !';
$_lang["file_saved"] = 'Le fichier a t enregistr !';
$_lang["file_unzip"] = 'Les fichiers ont t dcompresss !';
$_lang["file_unzip_fail"] = 'Les fichiers n\'ont pas pu tre dcompresss !';
$_lang["folder"] = 'Rpertoire';
$_lang["forgot_password_email_fine_print"] = '* l\'URL ci-dessus expirera ds que vous changez votre mot de passe, ou  dfaut, le jour suivant.';
$_lang["forgot_password_email_instructions"] = 'A partir de l vous serez en mesure de changer votre mot de passe depuis le menu Mon Compte';
$_lang["forgot_password_email_intro"] = 'Une demande de changement de mot de passe a t mise pour votre compte utilisateur.';
$_lang["forgot_password_email_link"] = 'Cliquez ici pour finaliser le changement de mot de passe.';
$_lang["forgot_your_password"] = 'Mot de passe oubli ?';
$_lang["friday"] = 'Vendredi';
$_lang["friendlyurlsprefix_message"] = 'Vous pouvez indiquer ici un prfixe  utiliser pour les URLs simples. Par exemple, si le prfixe est page, l\'URL /index.php?id=2 sera transform en l\'URL simple /page2.html (pour autant que le suffixe soit .html). Vous pouvez ainsi spcifier ce que vos utilisateurs (et les moteurs de recherche) verront comme liens sur votre site.';
$_lang["friendlyurlsprefix_title"] = 'Prfixe des URLs simples :';
$_lang["friendlyurlsuffix_message"] = 'Vous pouvez indiquer ici un suffixe  utiliser pour les URLs simples. Par exemple, en indiquant .html, toutes vos URLs simples se termineront par .html.';
$_lang["friendlyurlsuffix_title"] = 'Suffixe des URLs simples :';
$_lang["friendlyurls_message"] = 'Cette option vous permet d\'utiliser des URLs compatibles avec les moteurs de recherche. Veuillez prendre note que ceci ne fonctionne que sur des installations de MODx fonctionnant avec Apache, et que vous devrez crire un fichier .htaccess pour que cela fonctionne correctement. Pour plus d\'informations, voyez les fichiers .htaccess inclus dans la distribution.';
$_lang["friendlyurls_title"] = 'Utiliser les URLs simples :';
$_lang["friendly_alias_message"] = 'Si vous utilisez les URLs simples et si le document possde un alias, l\'alias aura toujours la priorit sur l\'URL simple. En spcifiant &nbsp;oui&nbsp; pour ce rglage, le prfixe et le suffixe de l\'URL seront appliqus  l\'alias. Par exemple, si votre document no 1 a l\'alias &nbsp;introduction&nbsp; et si le prfixe est &nbsp; (vide) et le suffixe &nbsp;.html&nbsp;, l\'URL gnr pour ce document sera &nbsp;introduction.html&nbsp;. Si le document n\'a pas d\'alias, l\'URL sera &nbsp;1.html&nbsp;.';
$_lang["friendly_alias_title"] = 'Utiliser les alias simples';
$_lang["functionnotimpl"] = 'Dsol !';
$_lang["functionnotimpl_message"] = 'Cette fonction n\'a pas encore t implmente.';
$_lang["go"] = 'Excuter';
$_lang["group_access_permissions"] = 'Accs des groupes d\'utilisateurs';
$_lang["guid"] = 'GUId';
$_lang["help"] = 'Aide';
$_lang["help_msg"] = 'Si vous avez besoin d\'aide sur MODx, le mieux est de nous rendre visite sur les <a href="http://modxcms.com/forums/index.php#8" target="_blank">Forums de MODx</a>. Vous pouvez aussi consulter la <a href="http://www.tattoocms.info/wiki/doku.php">documentation franaise</a>. Les rponses que vous attendez s\'y trouvent peut-tre. Dans le cas contraire, posez votre question dans les forums, et nous y rpondrons aussi vite que possible.';
$_lang["help_title"] = 'Aide';
$_lang["hide_tree"] = 'Cacher l\'arbre';
$_lang["home"] = 'Accueil';
$_lang["htmlsnippet_desc"] = 'Description du chunk';
$_lang["htmlsnippet_management_msg"] = 'Cette section vous permet de crer et de modifier des chunks.';
$_lang["htmlsnippet_msg"] = 'Cette section vous permet de crer et de modifier des chunks (portions de code HTML). Les chunks sont crits en code HTML pur, et le code PHP n\'y sera pas interprt.';
$_lang["htmlsnippet_name"] = 'Nom du chunk';
$_lang["htmlsnippet_title"] = 'Crez/modifier un chunk';
$_lang["icon"] = 'Icne';
$_lang["id"] = 'No';
$_lang["illegal_parent_child"] = 'Choix du parent&nbsp;:\n\nle document est un enfant du document slectionn.';
$_lang["illegal_parent_self"] = 'Choix du parent&nbsp;:\n\nle document slectionn ne peut pas tre son propre parent.';
$_lang["import_files_found"] = '<strong>%s documents trouvs pour importation...</strong><p/>';
$_lang["import_params"] = 'Importer les paramtres partags du module';
$_lang["import_params_msg"] = 'Vous pouvez importer les paramtres ou rglages d\'un module en slectionnant le nom du module dans le menu droulant ci-dessus. <strong>Remarque&nbsp;:</strong> pour qu\'un module apparaisse dans le menu, ce plugin ou ce snippet doit faire partie des ressources dont le module dpend et le partage des paramtres doit tre activ pour ce module.';
$_lang["import_parent_document"] = 'Document parent&nbsp:';
$_lang["import_site"] = 'Importer un site';
$_lang["import_site_failed"] = '<span style="color:#990000">chec&nbsp;!</span>';
$_lang["import_site_html"] = 'Importer un site en HTMl';
$_lang["import_site_importing_document"] = 'Importation du fichier <strong>%s</strong> ';
$_lang["import_site_maxtime"] = 'Dure maximale d\'importation&nbsp;:';
$_lang["import_site_maxtime_message"] = 'Vous pouvez indiquer ici la dure maximale (en secondes)  disposition de MODx pour importer le site (remplace la configuration PHP). Tapez &nbsp;0&nbsp; pour une dure illimite. Il n\'est pas recommand de taper &nbsp;0&nbsp; ou un nombre trs lev, car dans ce cas des disfonctionnements de votre serveur pourront survenir.';
$_lang["import_site_message"] = 'l\'utilisation de cette fonction vous permet d\'importer l\'intgralit d\'un site web en HTML dans la base de donnes. Avant de lancer cette opration, vous devez copier tous vos fichiers et dossier HTML dans le dossier &nbsp;assets/import&nbsp;.<p />Veuillez complter le formulaire et cliquer sur &nbsp;Importer&nbsp; pour commencer l\'importation. Les fichiers imports seront enregistrs  l\'emplacement choisi, en utilisant si possible, les noms de fichiers comme alias des pages et le titre des pages de faon adquate.';
$_lang["import_site_skip"] = '<span style="color:#990000">Ignor&nbsp;!</span>';
$_lang["import_site_start"] = 'Importer';
$_lang["import_site_success"] = '<span style="color:#009900">Succs&nbsp;!</span>';
$_lang["import_site_time"] = 'Importation termine. l\'importation a dur %s secondes.';
$_lang["inbox"] = 'Bote de rception';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Elment en ligne';
$_lang["insert"] = 'Insrer';
$_lang["insert_snippet"] = 'Insrer un snippet dans la page';
$_lang["keyword"] = 'Mot cl';
$_lang["keywords"] = 'Mots cls';
$_lang["keywords_intro"] = 'Pour modifier un mot-cl, tapez un nouveau mot-cl dans le champ  ct du mot-cl  modifier. Pour supprimer un mot-cl, cochez la case &nbsp;Supprimer&nbsp; de ce mot-cl. Si vous cocher cette case et modifier aussi le mot-cl, celui-ci sera effac et le changement de nom n\'aura pas lieu.';
$_lang["language_message"] = 'Choisissez la langue de l\'administration de MODx.';
$_lang["language_title"] = 'Langue :';
$_lang["launch_site"] = 'Visiter le site';
$_lang["link_attributes"] = 'Attributs des liens';
$_lang["link_attributes_help"] = 'Vous pouvez indiquer ici des attributs pour les liens, tels que target= or rel=.';
$_lang["list_mode"] = 'Mode liste actif/inactif - permet d\'afficher dans la grille tous les enregistrements.';
$_lang["loading_doc_tree"] = 'Chargement de l\'arbre...';
$_lang["loading_menu"] = 'Chargement du menu...';
$_lang["loading_page"] = 'Veuillez patienter pendant le chargement de la page...';
$_lang["localtime"] = 'Heure locale';
$_lang["locked"] = 'Verrouill';
$_lang["lock_htmlsnippet"] = 'Verrouiller ce chunk';
$_lang["lock_htmlsnippet_msg"] = 'Seuls les administrateurs peuvent modifier ce chunk.';
$_lang["lock_module"] = 'Verrouiller le module en vue de modification';
$_lang["lock_module_msg"] = 'Seuls les administrateurs peuvent modifier ce module.';
$_lang["lock_msg"] = '%s modifie actuellement ce %s. Veuillez patienter jusqu\' ce que l\'autre utilisateur ait termin et essayer  nouveau.';
$_lang["lock_plugin"] = 'Verrouiller ce plugin';
$_lang["lock_plugin_msg"] = 'Seuls les administrateurs peuvent modifier ce plugin.';
$_lang["lock_settings_msg"] = '%s modifie acteullement ces rglages. Veuillez patienter jusqu\' ce que l\'autre utilisateur ait termin et essayer  nouveau.';
$_lang["lock_snippet"] = 'Verrouiller ce snippet';
$_lang["lock_snippet_msg"] = 'Seuls les administrateurs peuvent modifier ce snippet.';
$_lang["lock_template"] = 'Verrouiller ce modle';
$_lang["lock_template_msg"] = 'Seuls les administrateurs peuvent modifier ce modle.';
$_lang["lock_tmplvars"] = 'Verrouiller la variable';
$_lang["lock_tmplvars_msg"] = 'Seuls les administrateurs peuvent modifier cette variable.';
$_lang["login_allowed_days"] = 'Jours autoriss';
$_lang["login_allowed_days_message"] = 'Choisissez les jours durant lesquels l\'utilisateur a l\'autorisation de se connecter.';
$_lang["login_allowed_ip"] = 'Adresses IP autorise';
$_lang["login_allowed_ip_message"] = 'Taper ici les adresses IP d\'o l\'utilisateur a l\'autorisation de se connecter. <strong>ATTENTION&nbsp;! Sparez les diverses adresses IP par une virgule (,)</strong>';
$_lang["login_button"] = 'Connecter';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">L\'installation du site est actuellement en cours.<br /> Merci de r-essayer dans quelques minutes !</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">MODx a t r-install. Merci de vous logger a nouveau!</span><br/>';
$_lang["login_captcha_message"] = 'Merci de saisir le code de scurit tel qu\'affich sur le graphique. Si vous ne pouvez pas lire le code, cliquez sur l\'image pour en gnrer un nouveau ou contactez votre administrateur.';
$_lang["login_captcha_message"] = ' Un administrateur a activ la validation par CAPTCHA. Vous devez par consquent taper le code de scurit. Si vous avez du mal  lire le code, cliquez sur le code pour en produire un nouveau.';
$_lang["login_homepage"] = 'Connexion page d\'accueil';
$_lang["login_homepage_message"] = 'Taper le numro du document o envoyer l\'utilisateur aprs sa connexion. <strong>ATTENTION&nbsp;! Assurez-vous que ce numro est bien celui d\'un document existant et qu\'il est publi et accessible par l\'utilisateur&nbsp;!</strong>';
$_lang["login_message"] = 'Veuillez vous identifier afin d\'accder au gestionnaire de contenu de votre site. Votre login et votre mot de passe sont sensibles  la casse. Tapez-les donc avec soin !';
$_lang["logout"] = 'Dconnexion';
$_lang["logo_slogan"] = 'Faire plus avec moins - MODx Content Manager';
$_lang["long_title"] = 'Titre long';
$_lang["mail_check_timeperiod_title"] = 'Intervalle de vrification des messages:';
$_lang["mail_check_timeperiod_message"] = 'A quel intervalle MODx doit-il vrifier l\'arrive de nouveaux messages, en secondes.';
$_lang["manager"] = 'Gestionnaire';
$_lang["manager_direction_message"] = 'Choisissez la direction dans laquelle le texte sera lu dans le gestionnaire, de gauche  droite ou de droite  gauche.';
$_lang["manager_direction_title"] = 'Sens de lecture du gestionnaire:';
$_lang["manager_lockout_message"] = 'Vous tes dj connect au Manager. Si vous souhaitez fermer votre session merci de bien vouloir utiliser le bouton "Dconnexion". <p />Pour aller  la page d\'accueil. Cliquer sur "Site > Accueil".';
$_lang["manager_permissions"] = 'Autorisations du gestionnaire';
$_lang["manager_theme"] = 'Thme du gestionnaire&nbsp;:';
$_lang["manager_theme_message"] = 'Choisir un thme pour le gestionnaire de contenu.';
$_lang["manage_depends"] = 'Gestion des dpendances';
$_lang["manage_files"] = 'Gestion des fichiers';
$_lang["manage_htmlsnippets"] = 'Gestion des chunks';
$_lang["manager_lang_attribute_message"] = 'Saisissez le code qui convient le mieux  la langue utilise pour le gestionnaire, cela garantira que votre navigateur affichera les contenus au format correct.';
$_lang["manager_lang_attribute_title"] = 'Attribut de langue HTML et XML du gestionnaire:';
$_lang["manage_metatags"] = 'Gestion des balises META et des mots-cls';
$_lang["manage_modules"] = 'Gestion des modules';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Gestion des modles';
$_lang["messages"] = 'Messages';
$_lang["messages_all"] = 'Tout le monde';
$_lang["messages_compose"] = 'Composer message';
$_lang["messages_forward"] = 'Transmettre';
$_lang["messages_from"] = 'De';
$_lang["messages_group"] = 'Un groupe';
$_lang["messages_inbox"] = 'Bote de messages';
$_lang["messages_message"] = 'Message';
$_lang["messages_not_allowed_to_read"] = 'Vous ne pouvez pas lire ce message !';
$_lang["messages_no_messages"] = 'Votre bote ne contient aucun message.';
$_lang["messages_private"] = 'Priv';
$_lang["messages_read_message"] = 'Lire message';
$_lang["messages_reply"] = 'Rpondre';
$_lang["messages_select_group"] = 'Choisir un groupe';
$_lang["messages_select_user"] = 'Choisir un utilisateur';
$_lang["messages_send"] = 'Envoyer';
$_lang["messages_send_to"] = 'Envoyer ';
$_lang["messages_sent"] = 'Envoy le';
$_lang["messages_subject"] = 'Sujet';
$_lang["messages_system_user"] = '[Systme]';
$_lang["messages_title"] = 'Messages';
$_lang["messages_user"] = 'Un utilisateur';
$_lang["metatags"] = 'Balises META';
$_lang["metatags_and_keywords"] = 'Balises META et mots-cls';
$_lang["metatag_intro"] = 'Sur cette page, vous pouvez supprimer, crer ou modifier des balises META. Pour associer des balises META  des documents, slectionnez l\'onglet <strong>Mots cls</u> lors de l\'dition du document, et slectionnez les balises META et les mots-cls adquats. Pour ajouter une nouvelle balise, tapez son nom et sa valeur, puis cliquez le bouton &nbsp;Ajouter balise&nbsp;. Pour modifier une balise, cliquez sur son nom dans la grille de donnes.';
$_lang["metatag_notice"] = 'Merci de consulter le <a href="http://www.html-reference.com/META.htm" target="_blank">Guide de rference HTML</a> pour plus d\'informations. Liste non exhaustive.';
$_lang["meta_keywords"] = 'Mots-cls';
$_lang["mgr_access_permissions"] = 'Autorisations d\'accs au gestionnaire';
$_lang["mgr_login_start"] = 'Document de dpart';
$_lang["mgr_login_start_message"] = 'Tapez ici le numro du document que vous voulez faire afficher  l\'utilisateur une fois qu\'il est connect au gestionnaire.<br /><strong>ATTENTION&nbsp;! Assurez-vous que ce numro est bien celui d\'un document existant, qu\'il est publi et que cet utilisateur  les autorisations pour y accder&nbsp;!</strong>';
$_lang["mgrlog_action"] = 'Action';
$_lang["mgrlog_actionid"] = 'ID';
$_lang["mgrlog_anyall"] = 'Toutes/Aucune';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() a retourn false.';
$_lang["mgrlog_datefr"] = 'Date du';
$_lang["mgrlog_dateinvalid"] = 'Format de date incorrect.';
$_lang["mgrlog_dateto"] = 'Date au';
$_lang["mgrlog_emptysrch"] = 'Votre recherche n\'a donn aucun rsultat (aucun logs correpondants).';
$_lang["mgrlog_field"] = 'Champs';
$_lang["mgrlog_itemid"] = 'ID de l\'item';
$_lang["mgrlog_itemname"] = 'Nom de l\'item';
$_lang["mgrlog_msg"] = 'Message';
$_lang["mgrlog_noquery"] = 'Pas de recherche effectue.';
$_lang["mgrlog_query_msg"] = 'Merci d\'effecteur une slection pour visualiser les logs. Vous pouvez effectuer une slection par date, mais faites bien attention : les dates saisies ne sont pas inclusives - pour slectionner les logs du 1/1/2004 vous devez slectionner les logs du 1/1/2004 au 2/1/2004.<br /><br />
Message et action ont habituellement les mmes valeurs. Si vous recherchez un message spcifique, il vaut mieux slectionner l\'action sur &nbsp;Toutes/Acune&nbsp;.';
$_lang["mgrlog_results"] = 'Nb. de rsultats';
$_lang["mgrlog_qresults"] = 'Rsultat de la recherche';
$_lang["mgrlog_searchlogs"] = 'Rechercher les logs';
$_lang["mgrlog_sortinst"] = 'Vous pouvez trier les tables en cliquant sur l\'entte de colonne. Si les logs deviennent plus volumineux, vous pouvez <a href="index.php?a=55">les vider</a>. Cela supprimera tous les logs et ne peut pas tre annul !';
$_lang["mgrlog_query"] = 'Enregistrement des requtes';
$_lang["mgrlog_time"] = 'Heure';
$_lang["mgrlog_user"] = 'Utilisateur';
$_lang["mgrlog_username"] = 'Nom utilisateur';
$_lang["mgrlog_value"] = 'Valeur';
$_lang["mgrlog_view"] = 'Voir les logs du manager';
$_lang["modules"] = 'Modules';
$_lang["module_code"] = 'Code source du module (php)';
$_lang["module_config"] = 'Configuration du module';
$_lang["module_desc"] = 'Description';
$_lang["module_disabled"] = 'Le module est dsactiv';
$_lang["module_edit_click_title"] = 'Cliquer ici pour modifier le module';
$_lang["module_group_access_msg"] = 'Slectionnez les groupes d\'utilisateurs ayant le droit de lancer ce module depuis le gestionnaire de contenu.';
$_lang["module_management"] = 'Gestion des modules';
$_lang["module_management_msg"] = 'Vous pouvez choisir ici le module  lancer ou  modifier. Pour lancer le module, cliquer sur l\'icne dans la grille. Pour modifier le module, cliquer sur le nom du module.';
$_lang["module_msg"] = 'Vous pouvez ici ajouter ou modifier des modules. Un module est une collection de ressources (par exemple des plugins, des snippets, etc.).';
$_lang["module_name"] = 'Nom du module';
$_lang["module_resource_msg"] = 'Vous pouvez ici ajouter ou supprimer les ressources dont dpend ce module. Pour ajouter une nouvelle ressource, cliquez sur l\'un des boutons ci-dessous.';
$_lang["module_resource_title"] = 'Dpendances du module';
$_lang["module_title"] = 'Crer/modifier un module';
$_lang["module_viewdepend_msg"] = 'Vous pouvez voir ici les ressources dont dpend le fonctionnement du module. Cliquer sur le bouton &nbsp;Dpendances du gestionnaire&nbsp; pour modifier les dpendances';
$_lang["modx_version"] = "Version de MODx";
$_lang["monday"] = 'Lundi';
$_lang["move"] = 'Dplacer';
$_lang["move_document"] = 'Dplacer document';
$_lang["move_document_message"] = 'Vous pouvez dplacer un document et tous ses enfants en choisissant un nouveau parent dans l\'arbre. Si ce document n\'est pas un rpertoire, il sera transform en rpertoire. Veuillez cliquer sur le nouveau parent dans l\'arbre.';
$_lang["move_document_new_parent"] = 'Veuillez choisir un nouveau parent dans l\'arbre des documents.';
$_lang["move_document_title"] = 'Dplacer le document';
$_lang["name"] = 'Nom';
$_lang["new_category"] = 'Nouvelle Catgorie';
$_lang["new_file_permissions_message"] = 'Lorsque vous uploadez un fichier via le gestionnaire de fichier, celui-ci tentera de modifier automatiquement les permissions sur le rglages saisi ici. Il est possible que cela ne fonctionne pas sur certaines configuration de serveur, telle qu\'IIS, vous serez alors contraint de modifier les permissions manuellement (FTP, SSH).';
$_lang["new_file_permissions_title"] = 'Nouvelle permission du fichier';
$_lang["new_folder_permissions_message"] = 'Lorsque vous crez un rpertoire via le gestionnaire de fichier, celui-ci tentera de modifier automatiquement les permissions sur le rglages saisi ici. Il est possible que cela ne fonctionne pas sur certaines configuration de serveur, telle qu\'IIS, vous serez alors contraint de modifier les permissions manuellement (FTP, SSH).';
$_lang["new_folder_permissions_title"] = 'Nouvelle permission du rpertoire';
$_lang["new_htmlsnippet"] = 'Nouveau chunk';
$_lang["new_keyword"] = 'Ajouter un nouveau mot cl :';
$_lang["new_module"] = 'Nouveau module';
$_lang["new_parent"] = 'Nouveau parent';
$_lang["new_plugin"] = 'Nouveau plugin';
$_lang["new_role"] = 'Crer un rle';
$_lang["new_snippet"] = 'Nouveau snippet';
$_lang["new_template"] = 'Nouveau modle';
$_lang["new_tmplvars"] = 'Nouvelle variable de modle';
$_lang["new_user"] = 'Crer un utilisateur';
$_lang["new_web_user"] = 'Nouvel utilisateur web';
$_lang["no"] = 'Non';
$_lang["nologentries_message"] = 'Spcifiez le nombre d\'entres de l\'historique affiches par page lors de l\'affichage de l\'historique.';
$_lang["nologentries_title"] = 'Nombre d\'entres de l\'historique :';
$_lang["nomessages_message"] = 'Spcifiez le nombre de messages  afficher dans la bote lors de l\'affichage des messages.';
$_lang["nomessages_title"] = 'Nombre de messages :';
$_lang["none"] = 'Aucun';
$_lang["noresults_message"] = 'Tapez ici le nombre des rsultats  afficher dans la grille de donnes lors de l\'affichage de listes et de rsultats de recherches.';
$_lang["noresults_title"] = 'Nombre de rsultats&nbsp;:';
$_lang["notset"] = 'Non fix';
$_lang["not_deleted"] = 'n\'a pas t supprim.';
$_lang["not_set"] = 'Non fix';
$_lang["no_activity_message"] = 'Vous n\'avez encore cr ni modifi aucun document.';
$_lang["no_category"] = 'non catgoris';
$_lang["no_docs_pending_publishing"] = 'Aucun document en attente de publication.';
$_lang["no_docs_pending_pubunpub"] = 'Aucun vnement trouv.';
$_lang["no_docs_pending_unpublishing"] = 'Aucun document en attente de dpublication.';
$_lang["no_groups_found"] = 'Aucun groupe trouv.';
$_lang["no_keywords_found"] = 'Le site n\'a actuellement pas de mots-cls.';
$_lang["no_records_found"] = 'Aucun enregistrement trouv.';
$_lang["no_results"] = 'Aucun rsultat trouv';
$_lang["offline"] = 'Hors ligne';
$_lang["online"] = 'En ligne';
$_lang["onlineusers_action"] = 'Action';
$_lang["onlineusers_actionid"] = 'Action-ID';
$_lang["onlineusers_ipaddress"] = 'Adresse IP de l\'utilisateur';
$_lang["onlineusers_lasthit"] = 'Dernire requte';
$_lang["onlineusers_message"] = 'La liste ci-dessous affiche les utilisateurs actifs durant des 20 dernires minutes (il est actuellement ';
$_lang["onlineusers_title"] = 'Utilisateurs en ligne';
$_lang["onlineusers_user"] = 'Utilisateur';
$_lang["onlineusers_userid"] = 'Numro ID';
$_lang["optimize_table"] = 'Cliquez ici pour optimiser cette table';
$_lang["pagetitle"] = 'Titre';
$_lang["page_data_cacheable"] = ' placer en cache';
$_lang["page_data_cacheable_help"] = 'Cocher cette case si vous voulez permettre que le document soit plac en cache. Si votre document contient des snippets, assurez-vous que ce champ est ne soit pas coch.';
$_lang["page_data_cached"] = '<strong>Source tire du cache&nbsp;:</strong>';
$_lang["page_data_changes"] = 'Modifications';
$_lang["page_data_contentType"] = 'Type de contenu';
$_lang["page_data_contentType_help"] = 'Choisissez le type de contenu de ce document. Si vous n\'tes pas sr du type de votre document, slectionnez text/html.';
$_lang["page_data_created"] = 'Cr le';
$_lang["page_data_edited"] = 'Modifi le';
$_lang["page_data_editor"] = 'Modifier avec diteur WYSIWYG';
$_lang["page_data_folder"] = 'Le document est un rpertoire';
$_lang["page_data_general"] = 'Gnral';
$_lang["page_data_markup"] = 'Disposition/structure';
$_lang["page_data_mgr_access"] = 'Accs gestionnaire';
$_lang["page_data_notcached"] = 'Ce document n\'a pas (encore) t mis en cache.';
$_lang["page_data_publishdate"] = 'Date publication';
$_lang["page_data_publishdate_help"] = 'Si vous choisissez une date de publication, le document sera publi lorsque cette date sera atteinte. Cliquez sur l\'icne du calendrier pour choisir une date, ou sur l\'icne  ct pour supprimer la date de publication. Dans ce cas le document ne sera pas publi automatiquement.';
$_lang["page_data_published"] = 'Publi';
$_lang["page_data_searchable"] = 'Recherchable';
$_lang["page_data_searchable_help"] = 'Cocher cette case si vous voulez permettre que le document soit retrouv par la fonction de recherche. Vous pouvez galement utiliser ce champ dans vos snippets  n\'importe quel autre fin.';
$_lang["page_data_source"] = 'Source';
$_lang["page_data_status"] = 'Statut';
$_lang["page_data_template"] = 'Modle utilis';
$_lang["page_data_template_help"] = 'Slectionnez ici le modle  utiliser pour la mise en page du document.';
$_lang["page_data_title"] = 'Donnes de page';
$_lang["page_data_unpublishdate"] = 'Date fin de publication';
$_lang["page_data_unpublishdate_help"] = 'Si vous choisissez une date de fin de publication, le document sera dpubli lorsque cette date sera atteinte. Cliquez sur l\'icne du calendrier pour choisir une date, ou sur l\'icne  ct pour supprimer la date de fin de publication. Dans ce cas le document ne sera pas dpubli automatiquement.';
$_lang["page_data_unpublished"] = 'Non publi';
$_lang["page_data_web_access"] = 'Accs web';
$_lang["pagination_table_first"] = "Dbut";
$_lang["pagination_table_last"] = "Fin";
$_lang["pagination_table_gotopage"] = "Aller  la page";
$_lang["paging_first"] = 'premire';
$_lang["paging_last"] = 'dernire';
$_lang["paging_next"] = 'suivant';
$_lang["paging_prev"] = 'prcdent';
$_lang["paging_showing"] = 'Affiches';
$_lang["paging_to"] = '';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Paramtre';
$_lang["password"] = 'Votre mot de passe ';
$_lang["password_change_request"] = 'Demande de modification de mot de passe';
$_lang["password_gen_gen"] = 'Laisser MODx gnrer le mot de passe.';
$_lang["password_gen_length"] = 'Le mot de passe doit contenir au moins 6 caractres.';
$_lang["password_gen_method"] = 'Comment crer le mot de passe de cet utilisateur ?';
$_lang["password_gen_specify"] = 'Me laisser spcifier le mot de passe :';
$_lang["password_method"] = 'Comment notifier du nouveau mot de passe ?';
$_lang["password_method_email"] = 'Envoyer le nouveau mot de passe par email.';
$_lang["password_method_screen"] = 'Afficher le nouveau mot de passe  l\'cran.';
$_lang["password_msg"] = 'Le nouveau mot de passe de <strong>%s</strong> est <strong>%s</strong>.';
$_lang["php_version_check"] = 'MODx est compatible avec PHP version 4.3.0 ou ultrieure. Veuillez mettre  jour votre installation de PHP !';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Code source du plugin (php)';
$_lang["plugin_config"] = 'Rglages du plugin';
$_lang["plugin_desc"] = 'Description';
$_lang["plugin_disabled"] = 'Plugin dsactiv';
$_lang["plugin_event_msg"] = 'Slection des vnements devant tre pris en compte par ce plugin.';
$_lang["plugin_locked_message"] = 'Ce plugin est verrouill.';
$_lang["plugin_management_msg"] = 'Vous pouvez choisir ici quel plugin modifier.';
$_lang["plugin_msg"] = 'Cette section vous permet de crer et de modifier des plugins. Les plugins sont des extraits de code PHP brut excuts par MODx lorsque les vnements systme choisis sont dtects.';
$_lang["plugin_name"] = 'Nom du plugin';
$_lang["plugin_priority"] = 'Editer l\'ordre d\'excution du plugin';
$_lang["plugin_title"] = 'Crer/modifier plugin';
$_lang["preview"] = 'Prvisualiser';
$_lang["preview_document"] = 'Prvisualiser le document';
$_lang["preview_msg"] = 'Voici la prvisualisation de vos derniers changements enregistrs. Cliquer ici pour <a href="javascript://" onclick="saveRefreshPreview();"><img src="media/images/icons/save.gif" align="absmiddle" height="12">Enregistrer et afficher</a> vos modifications actuelles';
$_lang["private"] = 'Priv';
$_lang["public"] = 'Public';
$_lang["publish_date"] = 'Date de publication';
$_lang["publish_document"] = 'Publier le document';
$_lang["publish_events"] = 'Documents  publier';
$_lang["rb_base_dir_message"] = 'Tapez ici le chemin physique vers le dossier des ressources. d\'ordinaire, ce rglage gnr automatiquement. Cependant, si vous utilisez IIS, MODx ne pourra pas dtecter le chemin, et le gestionnaire de ressources affichera une erreur. Dans ce cas, vous pouvez saisir ici le chemin du dossier images (le chemin tel que vous le voyez dans l\'explorateur Windows). <strong>Attention&nbsp;!</strong> Le dossier des ressources doit contenir les sous-dossiers images, fichiers, flash et media pour que le gestionnaire de ressources fonctionne correctement.';
$_lang["rb_base_dir_title"] = 'Chemin des ressources&nbsp;:';
$_lang["rb_base_url_message"] = 'Tapez ici le chemin virtuel vers le dossier des ressources. d\'ordinaire, ce rglage gnr automatiquement. Cependant, si vous utilisez IIS, MODx ne pourra pas dtecter le chemin, et le gestionnaire de ressources affichera une erreur. Dans ce cas, vous pouvez saisir ici l\'URL du dossier images (l\'URL tel que vous le saisiriez dans votre navigateur web).';
$_lang["rb_base_url_title"] = 'URL des ressources&nbsp;:';
$_lang["rb_message"] = 'Une fois activ, vos utilisateurs pourront consulter et tlcharger des ressources, par exemple des images, fichiers flash et d\'autres mdias sur le serveur.';
$_lang["rb_title"] = 'Activer le gestionnaire de ressources&nbsp;:';
$_lang["recent_docs"] = 'Documents rcents';
$_lang["refresh_cache"] = 'Cache : <strong>%s</strong> fichier(s) en cache&nbsp; <strong>%d</strong> d\'entre eux ont t supprims.<br />De nouveaux fichiers seront crs en cache  mesure que les pages sont visites.';
$_lang["refresh_published"] = 'Documents publis&nbsp;: <strong>%s</strong> document(s) a(ont) t publi(s).';
$_lang["refresh_site"] = 'Recharger le site';
$_lang["refresh_title"] = 'Recharger le site';
$_lang["refresh_tree"] = 'Recharger l\'arbre';
$_lang["refresh_unpublished"] = 'Documents non publis&nbsp;: <strong>%s</strong> document(s) a(ont) t dpubli(s).';
$_lang["remember_username"] = 'Enregistrer mon nom d\'utilisateur';
$_lang["remove"] = 'Retirer';
$_lang["remove_date"] = 'Retirer date';
$_lang["remove_locks"] = 'Supprimer les verrous';
$_lang["rename"] = 'Renommer';
$_lang["reports"] = 'Rapports';
$_lang["require_tagname"] = 'Un nom de balise est requis';
$_lang["require_tagvalue"] = 'Une valeur est requise pour la balise';
$_lang["reset"] = 'Vider';
$_lang["reset_failedlogins"] = 'Mise  zro';
$_lang["resolve_hostnames_message"] = 'Voulez-vous que MODx rsolve les noms de domaines de vos visiteurs ? La rsolution des noms de domaines engendre une charge supplmentaire sur le serveur, mais vos visiteurs ne s\'en apercevront pas.';
$_lang["resolve_hostnames_title"] = 'Rsolution des noms de domaine :';
$_lang["resource"] = 'Ressource';
$_lang["resources"] = 'Ressources';
$_lang["resource_categories"] = 'Toutes les ressources';
$_lang["resource_management"] = 'Gestion ressources';
$_lang["resource_name"] = 'Nom de la ressource';
$_lang["resource_selector_msg"] = 'Slectionnez les ressources dans la liste ci-dessous et cliquer sur le bouton &nbsp;Insrer&nbsp;.';
$_lang["resource_selector_title"] = 'Slecteur de ressources';
$_lang["role_about"] = 'Accs  la page &nbsp; propos de&nbsp;';
$_lang["role_access_persmissions"] = 'Autorisations d\'accs';
$_lang["role_actionok"] = 'Accs  l\'cran de fin d\'action';
$_lang["role_bk_manager"] = 'Utiliser le gestionnaire de sauvegardes';
$_lang["role_cache_refresh"] = 'Purge du cache du site';
$_lang["role_change_password"] = 'Changement de mot de passe';
$_lang["role_chunk_management"] = 'Gestion des Chunks';
$_lang["role_config_management"] = 'Gestion de la configuration';
$_lang["role_content_management"] = 'Gestion du contenu';
$_lang["role_create_chunk"] = 'Crer un Chunk';
$_lang["role_create_doc"] = 'Cration de documents';
$_lang["role_create_plugin"] = 'Crer plugins';
$_lang["role_create_snippet"] = 'Cration de snippets';
$_lang["role_create_template"] = 'Cration de modles';
$_lang["role_credits"] = 'Accs aux crdits';
$_lang["role_delete_chunk"] = 'Supprimer les Chunks';
$_lang["role_delete_doc"] = 'Suppression de documents';
$_lang["role_delete_eventlog"] = 'Supprimer l\'historique des vnements';
$_lang["role_delete_module"] = 'Supprimer module';
$_lang["role_delete_plugin"] = 'Supprimer plugins';
$_lang["role_delete_role"] = 'Suppression de rles';
$_lang["role_delete_snippet"] = 'Suppression de snippets';
$_lang["role_delete_template"] = 'Suppression de modles';
$_lang["role_delete_user"] = 'Suppression d\'utilisateurs';
$_lang["role_delete_web_user"] = 'Supprimer utilisateurs web';
$_lang["role_edit_chunk"] = 'Editer les chunks';
$_lang["role_edit_doc"] = 'Modification de documents';
$_lang["role_edit_doc_metatags"] = 'Modifier les balises META et les mots-cls du document';
$_lang["role_edit_module"] = 'Modifier module';
$_lang["role_edit_plugin"] = 'Modifier plugins';
$_lang["role_edit_role"] = 'Modification de rles';
$_lang["role_edit_settings"] = 'Modification de la configuration du site';
$_lang["role_edit_snippet"] = 'Modification de snippets';
$_lang["role_edit_template"] = 'Modification des modles';
$_lang["role_edit_user"] = 'Modification d\'utilisateurs';
$_lang["role_edit_web_user"] = 'Modifier utilisateurs web';
$_lang["role_errors"] = 'Accs aux annonces d\'erreurs';
$_lang['role_export_static'] = 'Exportation HTML';
$_lang["role_eventlog_management"] = 'Gestion de l\'historique des vnements';
$_lang["role_file_manager"] = 'Utilisation du gestionnaire de fichiers';
$_lang["role_frames"] = 'Accs aux cadres du gestionnaire';
$_lang["role_help"] = 'Accs aux pages d\'aide';
$_lang["role_home"] = 'Accs  la page d\'introduction du gestionnaire';
$_lang['role_import_static'] = 'Importation HTML';
$_lang["role_logout"] = 'Dconnexion du gestionnaire';
$_lang["role_management_msg"] = 'Cette section vous permet de crer et de modifier des rles.';
$_lang["role_management_title"] = 'Gestion rles';
$_lang["role_manage_metatags"] = 'Grer les les balises META et les mots-cls du site';
$_lang["role_messages"] = 'Lecture et envoi de messages';
$_lang["role_module_management"] = 'Gestion des modules';
$_lang["role_name"] = 'Nom du rle ';
$_lang["role_new_module"] = 'Nouveau module';
$_lang["role_new_role"] = 'Cration de rles';
$_lang["role_new_user"] = 'Cration d\'utilisateurs';
$_lang["role_new_web_user"] = 'Crer utilisateurs web';
$_lang["role_plugin_management"] = 'Gestion des plugins';
$_lang["role_role_management"] = 'Gestion des rles';
$_lang["role_publish_doc"] = 'Publier les documents';
$_lang["role_run_module"] = 'Lancer module';
$_lang["role_save_chunk"] = 'Enregistrement des chunks';
$_lang["role_save_doc"] = 'Enregistrement de documents';
$_lang["role_save_module"] = 'Enregistrer module';
$_lang["role_save_password"] = 'Enregistrement du mot de passe';
$_lang["role_save_plugin"] = 'Enregistrer plugins';
$_lang["role_save_role"] = 'Enregistrement de rles';
$_lang["role_save_snippet"] = 'Enregistrement de snippets';
$_lang["role_save_template"] = 'Enregistrement de modles';
$_lang["role_save_user"] = 'Enregistrement d\'utilisateurs';
$_lang["role_save_web_user"] = 'Enregistrer utilisateurs web';
$_lang["role_snippet_management"] = 'Gestion des snippets';
$_lang["role_template_management"] = 'Gestion des modles';
$_lang["role_title"] = 'Crer/modifier un rle';
$_lang["role_udperms"] = 'Gestion des autorisations';
$_lang["role_user_management"] = 'Gestion des utilisateurs';
$_lang["role_view_docdata"] = 'Affichage des donnes des documents';
$_lang["role_view_eventlog"] = 'Afficher l\'historique des vnements';
$_lang["role_view_logs"] = 'Affichage des historiques du systme';
$_lang["role_view_unpublished"] = 'Visualiser les documents non publis';
$_lang["role_web_access_persmissions"] = 'Autorisations d\'accs web';
$_lang["role_web_user_management"] = 'Gestion des utilisateurs web';
$_lang["run_module"] = 'Lancer le module';
$_lang["saturday"] = 'Samedi';
$_lang["save"] = 'Enregistrer';
$_lang["save_all_changes"] = 'Enregistrer tous les changements';
$_lang["save_tag"] = 'Enregistrer balise';
$_lang["saving"] = 'En cours d\'enregistrement, veuillez patienter...';
$_lang["scroll_dn"] = 'Dfilement vers le bas';
$_lang["scroll_up"] = 'Dfilement vers le haut';
$_lang["search"] = 'Recherche';
$_lang["search_criteria"] = 'Critres de recherche';
$_lang["search_criteria_content"] = 'Rech. par contenu';
$_lang["search_criteria_content_msg"] = 'Chercher les documents dont le contenu contient ce texte';
$_lang["search_criteria_id"] = 'Recherche par no';
$_lang["search_criteria_id_msg"] = 'Tapez un no de document pour le localiser rapidement';
$_lang["search_criteria_longtitle"] = 'Rech. par titre long';
$_lang["search_criteria_longtitle_msg"] = '(Voir les documents avec le texte crit dans leur titre long)';
$_lang["search_criteria_title"] = 'Rech. par titre';
$_lang["search_criteria_title_msg"] = 'Chercher les documents dont le titre contient ce texte';
$_lang["search_empty"] = 'Votre recherche n\'a donn aucun rsultat. Veuillez essayer de nouveau en largissant vos critres de recherche.';
$_lang["search_item_deleted"] = 'Cet lment a t supprim';
$_lang["search_results"] = 'Rsultats de recherche';
$_lang["search_results_returned_desc"] = 'Description';
$_lang["search_results_returned_id"] = 'No';
$_lang["search_results_returned_msg"] = 'Vos critres de recherche ont permis de trouver <strong>%s</strong> documents. Si un trop grand nombre de fichiers sont trouvs, essayer de taper des critres plus spcifiques. Les deux colonnes  l\'extrme gauche vous permettront de trouver le document dans l\'arbre ou de l\'afficher. Les colonnes de droite montrent, respectivement, si un document a t supprim et son statut de publication.<br />';
$_lang["search_results_returned_title"] = 'Titre';
$_lang["search_view_docdata"] = 'Afficher cet lment';
$_lang["security"] = 'Scurit';
$_lang["select_date"] = 'Choisir une date';
$_lang["send"] = 'Envoyer';
$_lang["serveroffset_message"] = 'Choisissez le nombre d\'heures de dcalage entre le lieu o vous tes et celui o se trouve le serveur. l\'heure sur le serveur est actuellement <strong>[%s]</strong>,<br />l\'heure sur le serveur en tenant compte du dcalage est <strong>[%s]</strong>.';
$_lang["serveroffset_title"] = 'Dcalage horaire du serveur&nbsp;:';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Si votre site est sur un serveur scuris (HTTPS), veuillez l\'indiquez ici.';
$_lang["server_protocol_title"] = 'Type de serveur :';
$_lang["servertime"] = 'Heure du serveur';
$_lang["serveroffset"] = 'Dcalage horaire du serveur';
$_lang["settings_after_install"] = 'Puisqu\'il s\'agit d\'une nouvelle installation, vous devez contrler ces rglages et effectuer les modifications que vous souhaitez. Veuillez ensuite cliquer Enregistrer pour enregistrer les rglages dans la base de donnes.<br /><br />';
$_lang["settings_config"] = 'Configuration';
$_lang["settings_dependencies"] = 'Dpendances';
$_lang["settings_events"] = 'vnements systme';
$_lang["settings_furls"] = 'Rglages URLs simples';
$_lang["settings_general"] = 'Gnral';
$_lang["settings_misc"] = 'Rglages divers';
$_lang["settings_page_settings"] = 'Rglages de la page';
$_lang["settings_photo"] = 'Photo';
$_lang["settings_properties"] = 'Proprits';
$_lang["settings_site"] = 'Rglages site';
$_lang["settings_snippets"] = 'Snippets';
$_lang["settings_strip_image_paths_message"] = 'l\'activation de cette option permet  MODx de changer les liens des images en chemin relatifs au lieu de chemins absolus. c\'est trs pratique si vous souhaitez dplacer votre installation de MODx (par exemple d\'un site d\'bauche  un site en production). Si vous ne savez pas de quoi il s\'agit, il est prfrable de ne pas l\'activer.';
$_lang["settings_strip_image_paths_title"] = 'Chemins relatifs des images ?';
$_lang["settings_templvars"] = 'Variables de modle';
$_lang["settings_title"] = 'Configuration';
$_lang["settings_ui"] = 'Rglages interface et diteur';
$_lang["settings_users"] = 'Rglages utilisateurs';
$_lang["showing"] = 'Affichage';
$_lang["show_preview"] = 'Afficher la fentre de prvisualisation';
$_lang["show_tree"] = 'Afficher l\'arbre';
$_lang["signupemail_message"] = 'Vous pouvez taper ici le message envoy  vos utilisateurs lors de la cration de leur compte. Ce message contiendra leur login et leur mot de passe. <strong>Remarque&nbsp;:</strong> Les codes %s sont remplacs par MODx quand il envoie le message. Le premier %s est remplac par le login, et le second par le mot de passe. <strong>Laissez les deux codes %s dans le email, sans quoi le login et le mot de passe ne seront pas envoys dans le email et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["signupemail_title"] = 'Message d\'inscription :';
$_lang["site"] = 'Site';
$_lang["sitename_message"] = 'Tapez ici le nom de votre site.';
$_lang["sitename_title"] = 'Nom du site :';
$_lang["sitestart_message"] = 'Tapez ici le numro du document que vous voulez utiliser comme page d\'accueil. <strong>ATTENTION&nbsp;! Assurez-vous que ce numro est bien celui d\'un document existant et qu\'il est publi&nbsp;!</strong>';
$_lang["sitestart_title"] = 'Page d\'accueil du site :';
$_lang["sitestatus_message"] = 'Choisissez &nbsp;En ligne&nbsp; pour publier votre site sur le web. Si vous choisissez &nbsp;Hors ligne&nbsp;, vos visiteurs se verront afficher le message d\'indisponibilit et ne pourront pas visiter le site.';
$_lang["sitestatus_title"] = 'Statut du site :';
$_lang["siteunavailable_message"] = 'Ce message est affich lorsque le site est &nbsp;Hors ligne&nbsp; ou si une erreur se produit. <strong>Ce message ne sera affich que si l\'option d\'afficher une page d\'indisponibilit n\'est pas utilise.</strong>';
$_lang["siteunavailable_page_message"] = 'Tapez ici le numro du document que vous voulez utiliser comme page lorsque le site est indisponible. <strong>Remarque&nbsp;:</strong> assurez-vous que ce numro appartient  un document existant et que ce document est publi&nbsp;!';
$_lang["siteunavailable_page_title"] = 'Page site indisponible&nbsp;:';
$_lang["siteunavailable_title"] = 'Message d\'indisponibilit :';
$_lang["site_schedule"] = 'Programme du site';
$_lang["snippet"] = 'Snippet';
$_lang["snippets_availabe"] = 'Snippets disponibles pour cette page';
$_lang["snippet_code"] = 'Code source du snippet (php)';
$_lang["snippet_desc"] = 'Description du snippet';
$_lang["snippet_execonsave"] = 'Lancer l\'excution du snippet aprs l\'enregistrement.';
$_lang["snippet_management_msg"] = 'Cette section vous permet de crer et de modifier des snippets.';
$_lang["snippet_msg"] = 'Cette section vous permet de crer et de modifier des snippets. Attention, les snippets sont cod en PHP pur, et si vous vous voulez que l\'output du snippet s\'affiche  un certain endroit d\'un modle, il doit y avoir dans le snippet une variable du mme nom que le snippet lui-mme. En clair, l\'output du snippet doit tre enregistr dans une variable portant le mme nom que le snippet.';
$_lang["snippet_name"] = 'Nom du snippet';
$_lang["snippet_properties"] = 'Proprits par dfaut';
$_lang["snippet_title"] = 'Crer/modifier un snippet';
$_lang["sort_asc"] = 'Ascendant';
$_lang["sort_desc"] = 'Descendant';
$_lang["sort_tree"] = 'Trier';
$_lang["source"] = 'Source';
$_lang["stay"] = 'Continuer l\'dition';
$_lang["stay_new"] = 'Ajouter un autre';
$_lang["submit"] = 'Submit';
$_lang["sunday"] = 'Dimanche';
$_lang["sysinfo_activity_message"] = 'Cette liste affiche les documents ayant t rcemment modifis ou crs par vos utilisateurs.';
$_lang["sysinfo_userid"] = 'Utilisateur';
$_lang["system_email_signup"] = 'Bonjour [+uid+] Voici vos paramtres de connexion pour le gestionnaire de contenu de [+sname+] ([+surl+]): Nom d\'utilisateur: [+uid+] Mot de passe: [+pwd+]. Une fois connect au gestionnaire de contenu, vous pourrez changer votre mot de passe. Salutations, l\'administrateur du site';
$_lang["system_email_webreminder"] = 'Bonjour [+uid+] Pour activer votre nouveau mot de passe, cliquez sur le lien suivant: [+surl+]. Si tout se passe normalement vous pourrez utiliser le mot de passe suivant pour vous identifier: Mot de passe:[+pwd+]. Si vous n\'aviez pas demand ce email, alors n\'en tenez pas compte. Salutations,l\'administrateur du site';
$_lang["system_email_websignup"] = 'Bonjour [+uid+] Voici vos paramtres de connexion pour [+sname+]: Nom d\'utilisateur: [+uid+] Mot de passe: [+pwd+]. Une fois connect en tant que [+sname+] ([+surl+]), vous pourrez changer votre mot de passe. Salutations, l\'administrateur du site';
$_lang["sys_alert"] = 'Alerte systme';
$_lang["table_hoverinfo"] = 'Passer le curseur de la souris sur un nom de table pour voir une courte description de sa fonction (Toutes les tables n\'en disposent pas).';
$_lang["table_prefix"] = 'Prfixe de la table';
$_lang["tag"] = 'Balise';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Variables de modle associes';
$_lang["template_code"] = 'Code source du modle (html)';
$_lang["template_desc"] = 'Description ';
$_lang["template_edit_tab"] = 'Editer le modle';
$_lang["template_locked_message"] = 'Ce modle est verrouill.';
$_lang["template_management_msg"] = 'Cette section vous permet de crer et de modifier des modles.';
$_lang["template_msg"] = 'Cette section vous permet de crer et de modifier des modles. Les modles crs ou modifis ne seront pas actualiss dans les pages en cache de votre site jusqu\' ce que le cache soit vid. Cependant, vous pouvez utiliser la fonction de prvisualisation d\'une page pour afficher la mise en page du nouveau modle.';
$_lang["template_name"] = 'Nom du modle ';
$_lang["template_no_tv"] = 'Aucune variable de modle associes  ce modle pour le moment.';
$_lang["template_reset_all"] = 'Utiliser sur toutes les pages le modle par dfaut';
$_lang["template_reset_specific"] = 'Seulement sur les pages %s';
$_lang["template_title"] = 'Crer/modifier un modle';
$_lang["template_tv_edit"] = 'Modifier l\'ordre de tri des variables de modle';
$_lang["template_tv_msg"] = 'Les variables de modles associes  ce modle sont lists ci-dessous.';
$_lang["thursday"] = 'Jeudi';
$_lang["tmplvars"] = 'Variables de modle';
$_lang["tmplvars_binding_msg"] = 'Ce champ supporte les liens  une source de donnes utilisant les commandes @';
$_lang["tmplvars_caption"] = 'Lgende';
$_lang["tmplvars_default"] = 'Valeur par dfaut';
$_lang["tmplvars_description"] = 'Description';
$_lang["tmplvars_elements"] = 'Valeurs optionnelles d\'entre';
$_lang["tmplvars_management_msg"] = 'Vous pouvez grer ici les champs supplmentaires pour vos documents.';
$_lang["tmplvars_msg"] = 'Cette section vous permet d\'ajouter/de modifier les variables de modle. Les variables de modle doivent tre actives pour certains modles afin qu\'elles puissent tre utilises  partir de snippets et de documents comme n\'importe quelle autre variable de contenu.';
$_lang["tmplvars_name"] = 'Nom de variable';
$_lang["tmplvars_novars"] = 'Aucune variable de modle trouve';
$_lang["tmplvars_rank"] = 'Ordre de tri';
$_lang["tmplvars_reset_params"] = 'Paramtres  zro';
$_lang["tmplvars_type"] = 'Type d\'entre';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Proprits du widget';
$_lang["tmplvar_access_msg"] = 'Slectionner les groupes de documents ayant l\'autorisation de modifier le contenu ou la valeur de cette variable';
$_lang["tmplvar_change_template_msg"] = 'La modification de ce modle gnrera le rechargement des variables de modles de la page. Les changements non enregistrs seront perdus.\n\n Voulez-vous vraiment modifier ce modle&nbsp;?';
$_lang["tmplvar_inuse"] = 'Le(s) document(s) suivant(s) utilisent actuellement cette variable de modle. Pour confirmer la suppression, cliquer sur le bouton Supprimer. Dans le cas contraire, cliquer sur le bouton Annuler.';
$_lang["tmplvar_tmpl_access"] = 'Accs au modle';
$_lang["tmplvar_tmpl_access_msg"] = 'Slectionner les modles pouvant accder  cette variable et l\'utiliser';
$_lang["to"] = '';
$_lang["tools"] = 'Outils';
$_lang["top_howmany_message"] = 'Lors de l\'affichage des statistiques, combien d\'lments avec les plus hautes statistiques doivent tre affichs dans les listes ?';
$_lang["top_howmany_title"] = 'Lignes  afficher :';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'l\'enregistrement de visites vous permettra d\'afficher des statistiques d\'utilisation de votre site. Cependant, cela ralentit un peu l\'analyseur du site. Si les statistiques des visites ne vous intressent pas particulirement, vous pouvez sans risque les dsactiver et apprcier l\'augmentation de vitesse.';
$_lang["track_visitors_title"] = 'Enregistrer les visites :';
$_lang["tree_show_protected"] = 'Montrer les pages protges';
$_lang["tree_show_protected_message"] = 'Lorsque cette option est sur "Non", les pages protges (et tous leurs enfants) ne seront pas visibles dans l\'arbre des documents aux utlisateurs hors du groupe d\'utilisateur autoris. ""Non" tait le rglage par dfaut dans les versions antrieures."Oui" permet de donner accs  vos utilisateur aux enfants d\'un document protg sans donner accs pour autant au parent.';
$_lang["truncate_table"] = 'Cliquez ici pour tronquer cette table';
$_lang["tuesday"] = 'Mardi';
$_lang["tv"] = 'Variable de modle';
$_lang["type"] = 'Type';
$_lang["udperms_allowroot_message"] = 'Voulez-vous autoriser  vos utilisateurs la cration de nouveaux documents/rpertoires  la racine du site&nbsp;?';
$_lang["udperms_allowroot_title"] = 'Accs racine :';
$_lang["udperms_message"] = 'Les autorisations d\'accs vous permettent d\'indiquer quelles pages peuvent modifier vos utilisateurs. Vous devrez assigner les utilisateurs  des groupes d\'utilisateurs, vos documents  des groupes de documents et spcifier quels groupes d\'utilisateurs peuvent modifier quels groupes de documents. La premire fois vous activez les autorisations d\'accs, seuls les administrateurs peuvent modifier des documents.';
$_lang["udperms_title"] = 'Utiliser les autorisations d\'accs :';
$_lang["unable_set_link"] = 'Impossible de dfinir le lien !';
$_lang["unable_set_parent"] = 'Impossible de fixer le nouveau parent !';
$_lang["unauthorizedpage_message"] = 'Tapez ici le numro du document que vous voulez afficher aux utilisateurs s\'ils demandent un document scuris ou auxquel ils n\'ont pas accs. <strong>ATTENTION&nbsp;! Assurez-vous que ce numro est bien celui d\'un document existant, qu\'il est publi et accessible par tout le monde&nbsp;!</strong>';
$_lang["unauthorizedpage_title"] = 'Page non autorise&nbsp;:';
$_lang["unblock_message"] = 'Une fois ces donnes enregistres, cet utilisateur sera dbloqu !';
$_lang["undelete_document"] = 'Rtablir document';
$_lang["unpublish_date"] = 'Date de dpublication';
$_lang["unpublish_document"] = 'Dpublier document';
$_lang["unpublish_events"] = 'Dpublication(s)';
$_lang["untitled_document"] = 'Page sans titre';
$_lang["untitled_weblink"] = 'Lien sans titre';
$_lang["update_params"] = 'Mettre  jour l\'affichage des paramtres';
$_lang["uploadable_files_message"] = 'Vous pouvez taper ici une liste de types de fichiers peuvant tre tlchargs avec le gestionnaire de fichiers. Veuillez taper les extensions correspondant aux types de fichiers, spares par des virgules.';
$_lang["uploadable_files_title"] = 'Types de fichier tlchargeables :';
$_lang["uploadable_flash_message"] = 'Vous pouvez saisir ici une liste de types de fichier  dposer dans "assets/flash/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers Flash  (swf, flv...), spares par des virgules.';
$_lang["uploadable_flash_title"] = 'Types Flash autoriss :';
$_lang["uploadable_images_message"] = 'Vous pouvez saisir ici une liste de types fichier  dposer dans "assets/images/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers Image  (jpg, jpeg, png...), spares par des virgules.';
$_lang["uploadable_images_title"] = 'Types d\'image autoriss :';
$_lang["uploadable_media_message"] = 'Vous pouvez saisir ici une liste de types fichier  dposer dans "assets/media/" via le gestionnaire de fichier. Merci de saisir les extensions pour les fichiers multimdia  (mov, avi...), spares par des virgules.';
$_lang["uploadable_media_title"] = 'Types de contenus multimdia autoriss :';
$_lang["upload_maxsize_message"] = 'Taper ici la taille maximale des fichiers pourvant tre tlchargs  l\'aide du gestionnaire de fichiers. La taille doit tre spcifie en octets. <strong>Attention&nbsp;! De gros fichiers peuvent prendre trs longtemps  tlcharger&nbsp;!</strong>';
$_lang["upload_maxsize_title"] = 'Taille maximale de tlchargement';
$_lang["user"] = 'Utilisateur';
$_lang["username"] = 'Votre nom d\'utilisateur ';
$_lang["users"] = 'Utilisateurs';
$_lang["user_block"] = 'Bloqu';
$_lang["user_blockedafter"] = 'Bloqu aprs';
$_lang["user_blockeduntil"] = 'Bloqu jusqu\'au';
$_lang["user_changeddata"] = 'Vos donnes ont t actualises. Merci de vous identifier  nouveau.';
$_lang["user_country"] = 'Pays';
$_lang["user_dob"] = 'Date de naissance';
$_lang["user_doesnt_exist"] = 'User does not exist';
$_lang["user_edit_self_msg"] = '<br /><br />Pour que les informations soient effectivement mises  jour, il vous faudra vous dconnecter, puis vous reconnecter.</strong><br />En outre, si vous choisissez de gnrer un nouveau mot de passe pour vous-mme, il vous sera envoy par email.';
$_lang["user_email"] = 'Adresse email ';
$_lang["user_failedlogincount"] = 'Connexions choues ';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Fminin';
$_lang["user_full_name"] = 'Nom complet ';
$_lang["user_gender"] = 'Sexe';
$_lang["user_is_blocked"] = 'Cet utilisateur est bloqu !';
$_lang["user_logincount"] = 'Nombre de connexions ';
$_lang["user_male"] = 'Masculin';
$_lang["user_management_msg"] = 'Cette section vous permet de crer et de modifier des utilisateurs.';
$_lang["user_management_title"] = 'Gestion utilisateurs';
$_lang["user_mobile"] = 'Tlphone mobile ';
$_lang["user_phone"] = 'Tlphone ';
$_lang["user_photo"] = 'Photo utilisateur';
$_lang["user_photo_message"] = 'Taper l\'URL de l\'image pour cet utilisateur ou utiliser le bouton insrer pour slectionner ou tlcharger une image sur le serveur.';
$_lang["user_prevlogin"] = 'Dernire connexion ';
$_lang["user_role"] = 'Rle de l\'utilisateur ';
$_lang["user_state"] = 'tat';
$_lang["user_title"] = 'Crer/modifier un utilisateur';
$_lang["user_upload_message"] = ' Si vous souhaitez empcher cet utilisateur de dposer n\'importe quel type de fichier dans cette catgorie, assurez vous que la case "Utiliser la configuration par dfaut" n\'est pas coche et de laisser ce champ vide.';
$_lang["user_use_config"] = 'Utiliser la configuration par dfaut';
$_lang["user_zip"] = 'Code postal';
$_lang["use_alias_path_message"] = 'l\'activation de cette option permet l\'affichage de chemin d\'accs complet au document, si celui-ci a un alias. Par exemple, si un document dont l\'alias est &nbsp;fils&nbsp; est plac dans un dossier d\'alias &nbsp;parent&nbsp;, le chemin &nbsp;/parent/child.html&nbsp; sera affich comme URL du document.<br /><strong>Remarque&nbsp;: si cette option est active, les rfrences  vos fichiers (images, css, javascripts, etc.) doivent tre absolues, par exemple &nbsp;/assets/images&nbsp; au lieu de &nbsp;assets/images&nbsp;. Ceci permet d\'viter que le navigateur ou le serveur web ajoute le chemin relatif au chemin de l\'alias.</strong>';
$_lang["use_alias_path_title"] = 'Chemin d\'accs pour les alias simples&nbsp;:';
$_lang["use_editor_message"] = 'Voulez-vous activer l\'diteur WYSIWYG ? Si vous tes plus  l\'aise avec le code HTML, ce rglage vous permet de dsactiver l\'diteur. Ce rglage s\'applique  tous les documents et  tous les utilisateurs !';
$_lang["use_editor_title"] = 'Activer l\'diteur :';
$_lang["value"] = 'Valeur';
$_lang["version_codename"] = "Nom de code de version";
$_lang["view"] = 'Afficher';
$_lang["view_child_documents_in_container"] = "Voir les documents enfants";
$_lang["view_document"] = 'Afficher page';
$_lang["view_log"] = 'Afficher l\'historique';
$_lang["view_logging"] = 'Historiques';
$_lang["view_sysinfo"] = 'Afficher infos systme';
$_lang["warning"] = 'Attention !';
$_lang["warning_not_saved"] = 'Les changements que vous avez fait n\'ont pas t encore enregistrs. Vous pouvez choisir de rester sur cette page pour enregistrer vos modifications (Annuler), ou vous pouvez quitter cette page, et perdrez ainsi toutes les modifications que vous avez effectues (OK).';
$_lang["weblink"] = 'Lien';
$_lang["weblink_message"] = 'Un lien est une rfrence  un objet sur Internet. Ce peut tre un document dans MODx, une page sur un autre site, une image ou tout autre fichier accessible sur Internet.<br /><br />';
$_lang["webpwdreminder_message"] = 'Vous pouvez taper ici le message envoy  vos utilisateurs web lorsqu\'ils demandent un nouveau mot de passe. Le gestionnaire de contenu leur enverra un message avec leur nouveau mot de passe et l\'information permettant de l\'activer. <br /><strong>Remarque&nbsp;:</strong> Le gestionnaire de contenu remplacera les champs suivants avant l\'envoi du message&nbsp;: <br /><br />[+sname+] - Nom de votre site web, <br />[+saddr+] - Adresse email du site web, <br />[+surl+] - Adresse URL de votre site web, <br />[+uid+] - Nom d\'utilisateur, <br />[+pwd+] - Mot de passe, <br />[+ufn+] - Nom complet de l\'utilisateur. <br /><br /><strong>Ne retirer pas les champs [+uid+] et [+pwd+] du message, sans quoi le nom d\'utilisateur et le mot de passe ne seront pas envoys et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["webpwdreminder_title"] = 'Message pour nouveau mot de passe :';
$_lang["websignupemail_message"] = 'Vous pouvez taper ici le message envoy  vos utilisateurs web lorsque vous crez pour eux un compte. Le systme leur enverra par email leur nom d\'utilisateur et leur mot de passe. <br /><strong>Remarque&nbsp;:</strong> Le gestionnaire de contenu remplacera les champs suivants avant l\'envoi du message&nbsp;: <br /><br />[+sname+] - Nom de votre site web, <br />[+saddr+] - Adresse email du site web, <br />[+surl+] - Adresse URL de votre site web, <br />[+uid+] - Nom d\'utilisateur, <br />[+pwd+] - Mot de passe, <br />[+ufn+] - Nom complet de l\'utilisateur. <br /><br /><strong>Ne retirer pas les champs [+uid+] et [+pwd+] du message, sans quoi le nom d\'utilisateur et le mot de passe ne seront pas envoys et vos utilisateurs ne pourront pas se connecter&nbsp;!</strong>';
$_lang["websignupemail_title"] = 'Message pour inscription web :';
$_lang["web_access_permissions"] = 'Autorisations d\'accs web';
$_lang["web_access_permissions_user_group"] = 'Groupe d\'utilisateurs web :';
$_lang["web_access_permissions_user_groups"] = 'Groupes d\'utilisateurs web :';
$_lang["web_access_permissions_user_group_access"] = 'Groupes de documents auxquels le groupe d\'utilisateurs a accs :';
$_lang["web_permissions"] = 'Autorisations web';
$_lang["web_users"] = 'Utilisateurs web';
$_lang["web_user_management_msg"] = 'Vous pouvez choisir ici quel utilisateur web modifier. Les utilisateurs web sont ceux qui ne peuvent se connecter que sur le site web';
$_lang["web_user_management_title"] = 'Gestion utilisateurs web';
$_lang["web_user_title"] = 'Crer/modifier utilisateur web';
$_lang["wednesday"] = 'Mercredi';
$_lang["welcome_messages"] = 'Votre bote contient <strong>%d</strong> message(s), dont <strong>%s</strong> non lu(s).';
$_lang["welcome_title"] = 'Bienvenue  votre gestionnaire de contenu MODx';
$_lang["which_editor_message"] = 'Vous pouvez choisir ici l\'diteur WYSIWYG que vous souhaitez utiliser. d\'autres diteurs WYSIWYG  installer sont disponibles sur la page de tlchargement de MODx.';
$_lang["which_editor_title"] = 'diteur WYSIWYG  utiliser :';
$_lang["working"] = 'Patience...';
$_lang["wrap_lines"] = 'Retour  la ligne';
$_lang["xhtml_urls_title"] = 'URLs XHTML valides';
$_lang["xhtml_urls_message"] = 'Remplace les ampersand (&) dans les URLs par des entits html valides &<!-- -->amp;';
$_lang["yes"] = 'Oui';
$_lang["yourinfo_message"] = 'Informations sur votre compte utilisateur&nbsp;:';
$_lang["yourinfo_previous_login"] = 'Votre dernire connexion&nbsp;:';
$_lang["yourinfo_role"] = 'Votre rle&nbsp;:';
$_lang["yourinfo_title"] = 'Vos informations';
$_lang["yourinfo_total_logins"] = 'Nombre total de connexions&nbsp;:';
$_lang["yourinfo_username"] = 'Connect sous le nom&nbsp;:';
$_lang["you_got_mail"] = 'Vous avez un message';
?>
