<?php
#############################################################
# Project:      bCounter                                    #
# File:         ua_get_data.php                             #
# Decription:   function to retrieve the user agent data
#                                                           #
# Copyright (c) Alexander Bondar (http://bondar.de/)        #
#############################################################

# T-Online Browser => Windows

function getUserAgentData($strUserAgent) {
    $arrReturn = array(
        "browser"     => "unknown",
        "browser_ver" => "",
        "os"          => "unknown",
        "os_ver"      => "",
        "type"        => "human"
    );

    # Browser bestimmen
    $iVersionBeginsAt = 0;
    $iVersionEndsAt = 0;
    if(
        $strUserAgent == "Mozilla"
        || $strUserAgent == ""
        || $strUserAgent == "PF:INET"
        || $strUserAgent == "acoon"
        || $strUserAgent == "Verdacht Vergehen nach UrhG"
        || $strUserAgent == "*Internet Explorer"
        || $strUserAgent == "user agent string"
        || $strUserAgent == "Bushido1994"
        || $strUserAgent == "flowna"
        || $strUserAgent == "BoeserSeoSpider"
        || $strUserAgent == "Mozilla/4.0  (via babelfish.yahoo.com)"
        || $strUserAgent == "Clearware web browser"
        || $strUserAgent == "eastgermanrevengev1"
        || eregi( "^Netluchs", $strUserAgent )
        || eregi( "Nutscrape", $strUserAgent )
        || eregi( "^LTID=.*", $strUserAgent )
    ){
        $arrReturn["type"]    = "fake";
    }else{
        if ( eregi("aol [0-9]", $strUserAgent ) ) {
            $arrReturn["browser"] = "aol";
            $iVersionBeginsAt = strpos ( $strUserAgent, "AOL " );
            $iVersionEndsAt   = strpos ( $strUserAgent, "; ", $iVersionBeginsAt );
            $arrReturn["browser_ver"]    = substr($strUserAgent, $iVersionBeginsAt+4, $iVersionEndsAt-$iVersionBeginsAt-4 );
        }elseif ( eregi( ".*\(.*msie [0-9]{1,}(\.[0-9]+)?.*.*", $strUserAgent ) && !eregi( "opera", $strUserAgent ) ) {
            $arrReturn["browser"] = "ie";
            $iVersionBeginsAt = strpos ( $strUserAgent, "MSIE " );
            $iVersionEndsAt   = strpos ( $strUserAgent, ";", $iVersionBeginsAt );
            $arrReturn["browser_ver"]    = substr($strUserAgent, $iVersionBeginsAt+5, $iVersionEndsAt-$iVersionBeginsAt-5 );
        }elseif ( eregi( ".*MSIE[0-9]{1,}(\.[0-9]+);.*", $strUserAgent ) ) {
            $arrReturn["browser"] = "ie";

            $iVersionBeginsAt         = strpos( $strUserAgent, "MSIE", $iVersionBeginsAt );
            $iVersionEndsAt           = strpos( $strUserAgent, ";", $iVersionBeginsAt );
            $iVersionShift            = strlen("msie");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif ( eregi( "^Microsoft Internet Explorer/[0-9]\.[0-9]+ \(", $strUserAgent ) ) {
            $arrReturn["browser"] = "ie";

            $iVersionBeginsAt         = 0;
            $iVersionEndsAt           = strpos( $strUserAgent, " (", $iVersionBeginsAt );
            $iVersionShift            = strlen("Microsoft Internet Explorer/");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif(
            (eregi( "opera/[0-9][0-9]*\.[0-9]", $strUserAgent )
            || (eregi( "Mozilla/[0-9]", $strUserAgent ) && eregi( "opera [0-9]\.[0-9]", $strUserAgent ) ) )
            && !eregi( "Opera Mini/[0-9]\.[0-9]", $strUserAgent )
        ){
            # Opera
            $arrReturn["browser"] = "opera";
            $iVersionShift = 6;
            if ( eregi( "Mozilla/[0-9]", $strUserAgent ) ) {
                # Version steht am Ende des Strings
                $iVersionBeginsAt = strpos ( $strUserAgent, "Opera " );
                if ( strpos ( $strUserAgent, " [" ) > 0 ) {
                    $iVersionEndsAt = strpos ( $strUserAgent, " [", $iVersionBeginsAt );
                }else{
                    # nach der Version kommt nichts mehr
                    $iVersionEndsAt = strlen( $strUserAgent );
                }
            }elseif( eregi( " Version/[0-9]{1,}(\.[0-9]+)$", $strUserAgent ) ){
                $iVersionBeginsAt = strpos ( $strUserAgent, " Version/" );
                $iVersionShift            = strlen(" Version/");
                $iVersionEndsAt = strlen( $strUserAgent );
            }else{
                $iVersionBeginsAt = 0;
                $iVersionEndsAt   = strpos ( $strUserAgent, " (", $iVersionBeginsAt );
            }
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi( "Opera Mini/[0-9]\.[0-9]", $strUserAgent ) ){
        # Opera Mini
            $arrReturn["browser"] = "operamini";
            if ( eregi( "Opera Mini/4", $strUserAgent ) ) {
                $arrReturn["browser_ver"] = 4;
            }elseif ( eregi( "Opera Mini/3", $strUserAgent ) ) {
                $arrReturn["browser_ver"] = 3;
            }elseif ( eregi( "Opera Mini/2", $strUserAgent ) ) {
                $arrReturn["browser_ver"] = 2;
            }elseif ( eregi( "Opera Mini/1", $strUserAgent ) ) {
                $arrReturn["browser_ver"] = 1;
            }
        }elseif( eregi( "firefox/[0-9]\.[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "firefox";
            $iVersionBeginsAt = strpos ( $strUserAgent, "Firefox/" );
            $iVersionEndsAt   = strpos ( $strUserAgent, " (", $iVersionBeginsAt );
            if ( !($iVersionEndsAt > 0) ) {
                $iVersionEndsAt   = strlen ( $strUserAgent );
            }
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+8, $iVersionEndsAt-$iVersionBeginsAt-8 );
        }elseif( eregi( "firefox / [0-9]\.[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "firefox";
            $iVersionBeginsAt = strpos ( $strUserAgent, "Firefox / " );
            $iVersionEndsAt   = strpos ( $strUserAgent, " (", $iVersionBeginsAt );
            if ( !($iVersionEndsAt > 0) ) {
                $iVersionEndsAt   = strlen ( $strUserAgent );
            }
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+10, $iVersionEndsAt-$iVersionBeginsAt-10 );
        }elseif( eregi( "Netscape/[0-9](\.[0-9]+)*", $strUserAgent ) ){
            $arrReturn["browser"] = "netscape";

            $iVersionBeginsAt = strpos ( $strUserAgent, "Netscape/" );
            $iVersionEndsAt   = $iVersionBeginsAt+9+1; #strlen ( $strUserAgent );

            $arrReturn["browser_ver"] = (substr($strUserAgent, $iVersionBeginsAt+9, $iVersionEndsAt-$iVersionBeginsAt-9 ))+0;
        }elseif( eregi( "SeaMonkey/[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "seamonkey";

            $iVersionBeginsAt = strpos ( $strUserAgent, "SeaMonkey/" );
            $iVersionEndsAt   = strlen ( $strUserAgent );

            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+10, $iVersionEndsAt-$iVersionBeginsAt-10 );
        }elseif( eregi( "BonEcho/[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "firefox";
            $arrReturn["browser_ver"] = 2;
        }elseif( eregi( "Chrome/[0-9].* safari/[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "chrome";

            $iVersionBeginsAt = strpos ( $strUserAgent, "Chrome/" );
            $iVersionEndsAt   = strpos ( $strUserAgent, "Safari/", $iVersionBeginsAt );

            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+7, $iVersionEndsAt-$iVersionBeginsAt-7 );
        }elseif( eregi( "safari/[0-9]", $strUserAgent ) && eregi( "AppleWebKit/[0-9]", $strUserAgent ) ){
            $arrReturn["browser"] = "safari";
            $iVersionBeginsAt = strpos ( $strUserAgent, "Safari/" );
            $iVersionEndsAt   = strlen ( $strUserAgent );

            $arrReturn["browser_ver"]    = substr($strUserAgent, $iVersionBeginsAt+7, $iVersionEndsAt-$iVersionBeginsAt-7 );
            $iTmpVer = (int) $arrReturn["browser_ver"];
            if ( $iTmpVer > 419 ) {
                # explizite Versionangabe erst ab Safari 2.0
                $iVersionBeginsAt = strpos ( $strUserAgent, "Version/" );
                $iVersionEndsAt   = strpos ( $strUserAgent, " Safari/", $iVersionBeginsAt );
                $arrReturn["browser_ver"]    = substr($strUserAgent, $iVersionBeginsAt+8, $iVersionEndsAt-$iVersionBeginsAt-8 );
            }else{
                switch( $iTmpVer ){
                    case 85:
                        $arrReturn["browser_ver"] = "1.0";
                        break;
                    case 125:
                        $arrReturn["browser_ver"] = "1.2";
                        break;
                    case 312:
                        $arrReturn["browser_ver"] = "1.3";
                        break;
                    case 412:
                        $arrReturn["browser_ver"] = "2.0";
                        break;
                    case 416:
                        $arrReturn["browser_ver"] = "2.0.2";
                        break;
                    case 417:
                        $arrReturn["browser_ver"] = "2.0.3";
                        break;
                    case 419:
                        $arrReturn["browser_ver"] = "2.0.4";
                        break;
                }
            }
        }elseif( eregi( "Mozilla/[0-9]", $strUserAgent ) ){
            if ( strlen($strUserAgent) == strlen("Mozilla/5.0") ) {
                $arrReturn["browser"] = "mozilla";
                $iVersionBeginsAt = strpos ( $strUserAgent, "Mozilla/" );
                $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+8, 1 );

                $arrReturn["os"] = "none";
            }elseif ( eregi("^Mozilla/[0-9](\.[0-9]+)* \(compatible;\)$", $strUserAgent) ) {
                $arrReturn["browser"] = "mozilla";
                $iVersionBeginsAt = 8;
                $arrReturn["browser_ver"] = substr($strUserAgent, 8, 1 );

                $arrReturn["os"] = "none";
            }elseif ( eregi("Iceape/[0-9]", $strUserAgent) ) {
                $arrReturn["browser"] = "iceape";
                $iVersionBeginsAt = strpos ( $strUserAgent, "Iceape/" );
                $iVersionEndsAt   = $iVersionBeginsAt+7+1;

                $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+7, $iVersionEndsAt-$iVersionBeginsAt-7 );
            }elseif ( eregi("K-Meleon/[0-9](\.[0-9]+)*$", $strUserAgent) ) {
                $arrReturn["browser"] = "k-meleon";
                $iVersionBeginsAt = strpos ( $strUserAgent, "K-Meleon/" );
                $iVersionEndsAt   = strlen ( $strUserAgent );

                $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+9, $iVersionEndsAt-$iVersionBeginsAt-9 );
            }elseif ( $strUserAgent == "Mozilla/5.0 (en-US)" ) {
                $arrReturn["browser"] = "mozilla";

                $arrReturn["browser_ver"] = "5.0";
            }elseif ( eregi("Mozilla/[0-9].* \(PSP \(PlayStation Portable\); [0-9]+(\.[0-9]+)*\)$", $strUserAgent) ) {
                $arrReturn["os"]      = "psp";
                $arrReturn["browser"] = "psp";
            }elseif (
                eregi("^Mozilla/[0-9](\.[0-9]+)* .*Gecko/[0-9]{8}", $strUserAgent)
                || eregi("^Mozilla/[0-9](\.[0-9]+)*.*\(.*;.*\)", $strUserAgent)
            ) {
                $arrReturn["browser"] = "mozilla";
                $iVersionBeginsAt = 8;
                $iVersionEndsAt   = 9;

                $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
            }else{
                # etwas anderes mit "Mozilla" im Namen... Immer diese Mchtegerns ;-)
            }
        }elseif( eregi( "T-Online", $strUserAgent ) ){
            $arrReturn["browser"] = "tonline";
            $arrReturn["os"]      = "windows";
        }

#############################
### OS ######################
#############################
        if (
            eregi( "Windows", $strUserAgent )
            && !eregi( "^Windows-Media-Player/", $strUserAgent )
            && !eregi( "^WebAlta Crawler/", $strUserAgent )
            && !eregi( "\+http://ws\.daum\.net/aboutWebSearch\.html", $strUserAgent )
        ) {
            $arrReturn["os"] = "windows";
            if ( eregi( "Windows NT 6\.1", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "7";
            }elseif ( eregi( "Windows NT 6\.0", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "Vista";
            }elseif ( eregi( "Windows NT 5\.2", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "Server 2003/XP x64 Edition";
            }elseif ( eregi( "Windows NT 5\.1", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "XP";
            }elseif ( eregi( "Windows NT 5\.01", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "2000 SP1";
            }elseif ( eregi( "Windows NT 5\.0", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "2000";
            }elseif ( eregi( "Windows NT 4\.0", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "NT 4.0";
            }elseif ( eregi( "Windows 98; Win 9x 4\.90", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "ME";
            }elseif ( eregi( "Windows 98", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "98";
            }elseif ( eregi( "Windows 95", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "95";
            }elseif ( eregi( "Windows CE", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "CE";
            }elseif ( eregi( "Windows 3\.1", $strUserAgent ) ) {
                $arrReturn["os_ver"] = "3.1";
            }
        }elseif( eregi( "Mac OS X", $strUserAgent ) ){
            $arrReturn["os"] = "macosx";
        }elseif( eregi( "Linux", $strUserAgent ) && !eregi("\(Exabot-Thumbnails\)", $strUserAgent ) ){
            $arrReturn["os"] = "linux";
        }elseif(
            eregi( "J2ME/MIDP", $strUserAgent )
            || eregi( "SAMSUNG-SGH-F700-Vodafone", $strUserAgent ) # user agent of a mobile phone, add more
        ) {
            $arrReturn["os"] = "javame";
        }elseif( eregi( "\(X11;.* SunOS.* sun4u\)", $strUserAgent ) ) {
            $arrReturn["os"] = "sun";
            if ( eregi( "SunOS [0-9][0-9]*(\.[0-9][0-9]*)* sun4u", $strUserAgent ) ) {
                $iVersionBeginsAt    = strpos( $strUserAgent, "SunOS ", 0 );
                $iVersionEndsAt      = strpos( $strUserAgent, " sun4u", $iVersionBeginsAt );
                $iVersionShift       = strlen("SunOS ");
                $arrReturn["os_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
            }
        }
#############################
### bots ####################
#############################
        elseif ( eregi( "Googlebot/[0-9]", $strUserAgent ) ) {
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "googlebot";
            $arrReturn["type"]    = "bot";

            $iVersionBeginsAt = strpos ( $strUserAgent, "Googlebot/" )+10;
            $iVersionEndsAt   = strpos ( $strUserAgent, "; ", $iVersionBeginsAt );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
        }elseif ( eregi( "Googlebot-Image/[0-9]", $strUserAgent ) ) {
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "googlebotimage";
            $arrReturn["type"]    = "bot";

            $iVersionBeginsAt = strpos ( $strUserAgent, "Googlebot/" )+10;
            $iVersionEndsAt   = strpos ( $strUserAgent, "; ", $iVersionBeginsAt );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
        }elseif ( eregi( "Google-Sitemaps/[0-9]", $strUserAgent ) ) {
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "sitemaps";
            $arrReturn["type"]    = "bot";

            $iVersionBeginsAt         = 16;
            $iVersionEndsAt           = strlen ( $strUserAgent );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
        }elseif( $strUserAgent == "PageFetcher-Google-CoOp;" ) {
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "pagefetcher";
            $arrReturn["type"]    = "bot";
        }elseif( $strUserAgent == "Mediapartners-Google" ) {
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "adsense";
            $arrReturn["type"]    = "bot";
        }elseif( eregi( "Yahoo! Slurp", $strUserAgent ) ) {
            $arrReturn["os"]      = "yahoo";
            $arrReturn["browser"] = "slurp";
            $arrReturn["type"]    = "bot";
        }elseif( eregi( "msnbot.*\(\+http://search\.msn\.com/msnbot\.htm\)", $strUserAgent ) ) {
            $arrReturn["os"]      = "msn";
            if ( eregi( "msnbot-media", $strUserAgent) ) {
                $arrReturn["browser"] = "bot-media";
            }else{
                $arrReturn["browser"] = "bot";
                }
            $iVersionBeginsAt = 7;
            $iVersionEndsAt   = strpos ( $strUserAgent, "(+http", $iVersionBeginsAt );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
            $arrReturn["type"]    = "bot";
        }elseif( eregi( "Ask Jeeves.*\+http://about\.ask\.com/en/docs/about/webmasters\.shtml\)", $strUserAgent ) ) {
            $arrReturn["os"]      = "askjeeves";
            $arrReturn["browser"] = "crawler";
            $arrReturn["type"]    = "bot";
        }elseif( eregi( "Sogou web spider/[0-9].*\(\+http://www\.sogou\.com/docs/help/webmasters\.htm", $strUserAgent ) ) {
            $arrReturn["os"]      = "sogou";
            $arrReturn["browser"] = "spider";
            $iVersionBeginsAt = 17;
            $iVersionEndsAt   = strpos ( $strUserAgent, "(+http", $iVersionBeginsAt );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
            $arrReturn["type"]    = "bot";
        }elseif( eregi( "^libwww-perl/[[0-9]|/]*$", $strUserAgent ) ) {
            $arrReturn["os"]      = "libwww";
            $arrReturn["browser"] = "perl";

            $iVersionBeginsAt         = 12;
            $iVersionEndsAt           = strlen ( $strUserAgent );
            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );

            $arrReturn["type"]    = "lib";
        }elseif( eregi( "^(Java/[0-9])([0-9]|\.|_|[a-z]|[A-Z])*$", $strUserAgent ) ) {
            $arrReturn["os"]      = "java";
            $arrReturn["browser"] = "";

            $iVersionBeginsAt         = 5;
            $iVersionEndsAt           = strlen ( $strUserAgent );

            $arrReturn["browser_ver"] = substr ( $strUserAgent, $iVersionBeginsAt, $iVersionEndsAt-$iVersionBeginsAt );
            $arrReturn["type"]    = "lib";
        }elseif( eregi("WebAlta Crawler/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "webalta";
            $arrReturn["browser"] = "crawler";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("CazoodleBot/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "cazoodle";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("infometrics-bot", $strUserAgent ) ){
            $arrReturn["os"]      = "infometrics";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("myWebbot/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "myweb";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Gigabot/.* \(http://www\.gigablast\.com/spider\.html\)", $strUserAgent ) ){
            $arrReturn["os"]      = "gigablast";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("WWW-Mechanize/[0-9].* \(http://rubyforge\.org/projects/mechanize/\)", $strUserAgent ) ){
            $arrReturn["os"]      = "www-mechanize";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Seekbot/[0-9].* \(http://www\.seekbot\.net/bot\.html\)", $strUserAgent ) ){
            $arrReturn["os"]      = "seekport";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("ScoutJet; \+http://www\.scoutjet\.com/", $strUserAgent ) ){
            $arrReturn["os"]      = "scoutjet";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("AdShadow \+http://adshadow\.de", $strUserAgent ) ){
            $arrReturn["os"]      = "adshadow";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^appie.* \(www\.walhello\.com\)", $strUserAgent ) ){
            $arrReturn["os"]      = "walhello";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif(
            eregi("^DotBot/[0-9]*.* \(http://www\.dotnetdotcom\.org/.* crawler@dotnetdotcom\.org\)", $strUserAgent )
            || eregi("^Mozilla/[0-9].* \(compatible; DotBot/[0-9].*; http://www\.dotnetdotcom\.org/, crawler@dotnetdotcom\.org\)", $strUserAgent )
        ){
            $arrReturn["os"]      = "dotbot";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^wget/[0-9]*.*", $strUserAgent ) ){
            $arrReturn["os"]      = "wget";
            $arrReturn["browser"] = "downloader";
            $arrReturn["type"]    = "downloader";
        }elseif( eregi("^FDM [0-9]*.*", $strUserAgent ) ){
            $arrReturn["os"]      = "fdm";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "downloader";
        }elseif( eregi("^Windows-Media-Player/[0-9]*.*", $strUserAgent ) ){
            $arrReturn["os"]      = "wmp";
            $iVersionBeginsAt     = 21;
            $iVersionEndsAt       = strlen ( $strUserAgent );
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
        }elseif( eregi("^Toplistbot", $strUserAgent ) ){
            $arrReturn["os"]      = "toplist";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Cityreview Robot \(\+http://www\.cityreview\.org/crawler/\)", $strUserAgent ) ){
            $arrReturn["os"]      = "cityreview";
            $arrReturn["browser"] = "robot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Yandex/[0-9]*.* \(compatible; Win16; .*\)", $strUserAgent ) || eregi("^YandexSomething/[0-9]*.*", $strUserAgent )  ){
            $arrReturn["os"]      = "yandex";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Mozilla/.* \(compatible; WebDataCentreBot/.*; \+http://WebDataCentre\.com/\)", $strUserAgent ) ){
            $arrReturn["os"]      = "webdatacentre";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^squidwall [0-9].*", $strUserAgent ) ){
            $arrReturn["os"]      = "squidwall";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
        }elseif( eregi("^psbot/[0-9]*", $strUserAgent ) ){
            $arrReturn["os"]      = "picsearch";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi(" \+http://www\.suchen\.de/", $strUserAgent ) ){
            $arrReturn["os"]      = "suchende";
            $arrReturn["browser"] = "crawler";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Yeti/[0-9]", $strUserAgent ) || eregi("NaverBot", $strUserAgent ) ){
            $arrReturn["os"]      = "naver";
            $arrReturn["browser"] = "yeti";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Eurobot/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "eurobot";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("suchbaer\.de", $strUserAgent ) ){
            $arrReturn["os"]      = "suchbaerde";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("ichiro/[0-9].* \(", $strUserAgent ) ){
            $arrReturn["os"]      = "ichiro";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^EuripBot/[0-9].* \(\+http://www\.eurip\.com\)", $strUserAgent ) ){
            $arrReturn["os"]      = "eurip";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("BejiBot Crawler", $strUserAgent ) ){
            $arrReturn["os"]      = "bejibot";
            $arrReturn["browser"] = "crawler";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("http://www\.voodoo-it\.com/spider\.html", $strUserAgent ) ){
            $arrReturn["os"]      = "voodooit";
            $arrReturn["browser"] = "spider";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Yanga WorldSearch Bot.*\(http://www\.yanga\.co\.uk/\)", $strUserAgent ) ){
            $arrReturn["os"]      = "yanga";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^TurnitinBot/[0-9].* \(http://www\.turnitin\.com/robot/crawlerinfo\.html\)", $strUserAgent ) ){
            $arrReturn["os"]      = "turnitin";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Twiceler", $strUserAgent ) && ( eregi("cuil\.com", $strUserAgent ) || eregi("cuill\.com", $strUserAgent ) ) ){
            $arrReturn["os"]      = "cuil";
            $arrReturn["browser"] = "twiceler";
            $arrReturn["type"]    = "bot";
        }elseif(
            eregi("\(Exabot-Thumbnails\)", $strUserAgent )
            || eregi("Exabot/[0-9]", $strUserAgent )
        ){
            $arrReturn["os"]      = "exabot";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("WinHttp\.WinHttpRequest", $strUserAgent ) ){
            $arrReturn["os"]      = "winhttp";
            $arrReturn["browser"] = "";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]    = "lib";
        }elseif( eregi("Jyxobot/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "jyxo";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^ia_archiver", $strUserAgent ) ){
            $arrReturn["os"]      = "alexa";
            $arrReturn["browser"] = "ia_archiver";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Touche \(\+http://www\.touche\.com\.ve\)", $strUserAgent ) ){
            $arrReturn["os"]      = "touche";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("\+http://www\.askpeter\.info", $strUserAgent ) ){
            $arrReturn["os"]      = "askpeter";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("\(.*http://www\.grub\.org.*\)", $strUserAgent ) ){
            $arrReturn["os"]      = "grub";
            $arrReturn["browser"] = "crawler";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^wwwster/[0-9]", $strUserAgent ) ){
            $arrReturn["os"]      = "wwwster";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("Charlotte/[0-9].*; http://www\.searchme\.com/support/", $strUserAgent ) ){
            $arrReturn["os"]          = "searchme";
            $arrReturn["browser"]     = "charlotte";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]        = "bot";
        }elseif( eregi("http://ws\.daum\.net/aboutWebSearch\.html", $strUserAgent ) ){
            $arrReturn["os"]          = "daumoa";
            $arrReturn["browser"]     = "bot";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]        = "bot";
        }elseif( eregi("^OOZBOT/.* \(.*http://www\.setooz\.com/oozbot\.html.*\)$", $strUserAgent ) ){
            $arrReturn["os"]          = "setooz";
            $arrReturn["browser"]     = "oozbot";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]        = "bot";
        }elseif( eregi("\(vBSEO; http://www\.vbseo\.com\)$", $strUserAgent ) ){
            $arrReturn["os"]          = "vbseo";
            $arrReturn["browser"]     = "bot";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]        = "bot";
        }elseif( eregi("\+http://worio\.com\)$", $strUserAgent ) ){
            $arrReturn["os"]          = "worio";
            $arrReturn["browser"]     = "bot";
            $arrReturn["browser_ver"] = "";
            $arrReturn["type"]        = "bot";
        }elseif( eregi("^findlinks/[0-9].* \(\+http://wortschatz\.uni-leipzig\.de/findlinks/\)$", $strUserAgent ) ){
            $arrReturn["os"]      = "findlinks";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";

            $iVersionBeginsAt = 0;
            $iVersionEndsAt   = strpos ( $strUserAgent, " (", $iVersionBeginsAt );
            $iVersionShift            = strlen("findlinks/");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi("MJ12bot/v[0-9].*; http://www\.majestic12\.co\.uk/bot\.php.*$", $strUserAgent ) ){
            $arrReturn["os"]      = "majestic12";
            $arrReturn["browser"] = "mj12bot";
            $arrReturn["type"]    = "bot";

            $iVersionBeginsAt         = strpos( $strUserAgent, "MJ12bot/v", 0 );
            $iVersionEndsAt           = strpos( $strUserAgent, "; http://", $iVersionBeginsAt );
            $iVersionShift            = strlen("MJ12bot/v");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi("^Snapbot/[0-9]*(\.[0-9]+)* \(.*.*http://www\.snap\.com\)$", $strUserAgent ) ){
            $arrReturn["os"]      = "snap";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Speedy Spider .*http://www\.entireweb\.com/about/search_tech/speedyspider/\)$", $strUserAgent ) ){
            $arrReturn["os"]      = "entireweb";
            $arrReturn["browser"] = "speedyspider";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("^Baiduspider.*", $strUserAgent ) ){
            $arrReturn["os"]      = "baidu";
            $arrReturn["browser"] = "spider";
            $arrReturn["type"]    = "bot";
        }elseif( eregi("http://sw\.deri\.org/2006/04/multicrawler/robots\.html", $strUserAgent ) ){
            $arrReturn["os"]      = "multicrawler";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "bot";
        }elseif( $strUserAgent == "panscient.com" ){
            $arrReturn["os"]          = "panscient";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "SeznamBot/2.0 (+http://fulltext.seznam.cz/)" ){
            $arrReturn["os"]          = "seznam";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("http://www\.apptus\.com", $strUserAgent ) ){
            $arrReturn["os"]          = "apptus";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "MLBot (www.metadatalabs.com/mlbot)" ){
            $arrReturn["os"]          = "metadatalabs";
            $arrReturn["browser"]     = "mlbot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("Rexyobot", $strUserAgent ) ){ # broken bot
            $arrReturn["os"]          = "rexyobot";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^kalooga/KaloogaBot \(.*", $strUserAgent ) ){
            $arrReturn["os"]          = "kalooga";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "betaBot" ){
            $arrReturn["os"]          = "betabot";
            $arrReturn["browser"]     = "bot";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^IOI.*ISC Open Index crawler", $strUserAgent ) ){
            $arrReturn["os"]          = "ioi";
            $arrReturn["browser"]     = "crawler";
            $arrReturn["type"]        = "bot";
            $arrReturn["browser_ver"] = "";
        }
#############################
### libs ####################
#############################
        elseif( eregi("Runnk online rss reader.*http://www\.runnk\.com/", $strUserAgent ) ){
            $arrReturn["os"]      = "runnk";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("CyberPatrol SiteCat Webbot \(http://www\.cyberpatrol\.com/cyberpatrolcrawler\.asp\)", $strUserAgent ) ){
            $arrReturn["os"]      = "cyberpatrol";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^W3C_Validator/[0-9][0-9]*(\.[0-9][0-9]*)*$", $strUserAgent ) ){
            $arrReturn["os"]      = "w3c";
            $arrReturn["browser"] = "validator";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";

            $iVersionBeginsAt         = strpos( $strUserAgent, "W3C_Validator/", 0 );
            $iVersionEndsAt           = strlen( $strUserAgent );
            $iVersionShift            = strlen("W3C_Validator/");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi("^Microsoft URL Control - [0-9][0-9]*(\.[0-9][0-9]*)*$", $strUserAgent ) ){
            $arrReturn["os"]      = "msurlcontrol";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";

            $iVersionBeginsAt         = strpos( $strUserAgent, "Microsoft URL Control - ", 0 );
            $iVersionEndsAt           = strlen( $strUserAgent );
            $iVersionShift            = strlen("Microsoft URL Control - ");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi("^Microsoft-WebDAV-MiniRedir/[0-9][0-9]*(\.[0-9][0-9]*)*$", $strUserAgent ) ){
            $arrReturn["os"]      = "ms-webdav-miniredir";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";

            $iVersionBeginsAt         = strpos( $strUserAgent, "Microsoft-WebDAV-MiniRedir/", 0 );
            $iVersionEndsAt           = strlen( $strUserAgent );
            $iVersionShift            = strlen("Microsoft-WebDAV-MiniRedir/");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
        }elseif( eregi("Indy Library\)", $strUserAgent ) ){
            $arrReturn["os"]      = "indy";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("http://www\.whoisde\.de", $strUserAgent ) ){
            $arrReturn["os"]      = "whoisdede";
            $arrReturn["browser"] = "";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "thumbshots-de-bot (+http://www.thumbshots.de)" ){
            $arrReturn["os"]      = "thumbshotsde";
            $arrReturn["browser"] = "bot";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "AppEngine-Google; (+http://code.google.com/appengine)" ){
            $arrReturn["os"]      = "google";
            $arrReturn["browser"] = "appengine";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "FavOrg" ){
            $arrReturn["os"]          = "favorg";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "http://Anonymouse.org/ (Unix)" ){
            $arrReturn["os"]          = "anonymouse";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("http://nlp\.uned\.es/qeavis/", $strUserAgent ) ){
            $arrReturn["os"]          = "qeavis";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("plantynet\.com$", $strUserAgent ) ){
            $arrReturn["os"]          = "plantynet";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "gzip(gfe) (via translate.google.com)" ){
            $arrReturn["os"]          = "google";
            $arrReturn["browser"]     = "translate";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( $strUserAgent == "blackspider" ){
            $arrReturn["os"]          = "blackspider";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("www\.forumseek\.net\)$", $strUserAgent ) ){
            $arrReturn["os"]          = "forumseek";
            $arrReturn["browser"]     = "spider";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^Jakarta Commons-HttpClient/[0-9].*$", $strUserAgent ) ){
            $arrReturn["os"]          = "jakarta";
            $arrReturn["browser"]     = "commons-httpclient";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("\(compatible; OpenX Spider; http://www\.openx\.org\)$", $strUserAgent ) ){
            $arrReturn["os"]          = "openx";
            $arrReturn["browser"]     = "spider";
            $arrReturn["type"]        = "lib";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^facebookexternalhit/[0-9][0-9]*(\.[0-9][0-9]*)* \(\+http://www\.facebook\.com/externalhit_uatext\.php)$", $strUserAgent ) ){
            $arrReturn["os"]      = "facebook";
            $arrReturn["browser"] = "facebookexternalhit";
            $arrReturn["type"]    = "lib";
            $arrReturn["browser_ver"] = "";

            $iVersionBeginsAt         = strpos( $strUserAgent, "facebookexternalhit/", 0 );
            #$iVersionEndsAt           = strlen( $strUserAgent );
            $iVersionEndsAt           = strpos( $strUserAgent, " (+http://www.facebook.com/externalhit_uatext.php)", $iVersionBeginsAt );
            $iVersionShift            = strlen("facebookexternalhit/");
            $arrReturn["browser_ver"] = substr($strUserAgent, $iVersionBeginsAt+$iVersionShift, $iVersionEndsAt-$iVersionBeginsAt-$iVersionShift );
#print_r($arrReturn);
        }
#############################
### spam ####################
#############################
        elseif( $strUserAgent == "WEP Search 00" ){
            $arrReturn["os"]          = "wep_search_00";
            $arrReturn["browser"]     = "";
            $arrReturn["type"]        = "spam";
            $arrReturn["browser_ver"] = "";
        }elseif( eregi("^Missigua Locator", $strUserAgent ) ){
            $arrReturn["os"]          = "missigua_locator";
            $arrReturn["browser"]     = "spambot";
            $arrReturn["type"]        = "spam";
            $arrReturn["browser_ver"] = "";
        }
    }
# debug output
# print_r($arrReturn);
return $arrReturn;
}
?>