<?php
#############################################################
# Project:      bCounter                                    #
# File:         diagramm.php                                #
# Decription:   diagramm rendering
#                                                           #
# Copyright (c) Alexander Bondar (http://bondar.de/)        #
#############################################################

    @require_once("./inc/inc.php");
    @include_once("./inc/jpgraph/jpgraph.php");
    @include_once("./inc/jpgraph/jpgraph_pie.php");
    @include_once("./inc/jpgraph/jpgraph_pie3d.php");

    $arrData   = array();
    $arrLegend = array();
    $strDiagramTitle = "";


    switch ( $_GET["type"] ) {
        case 'referer_all':
            $strDiagramTitle = "Verweisende Domains";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."referer";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT host, count(host) AS anzahl
                             FROM ".$bCounter_dbPrefix."referer
                             GROUP BY host
                             ORDER BY anzahl DESC, host ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( mysql_result($SQLresult_all, $i, "host"), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'keywords':
            $strDiagramTitle = "Alle Keywords";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."suchbegriffe";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT suchbegriff, count(suchbegriff) AS anzahl
                             FROM ".$bCounter_dbPrefix."suchbegriffe
                             GROUP BY suchbegriff
                             ORDER BY anzahl DESC, suchbegriff ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( mysql_result($SQLresult_all, $i, "suchbegriff"), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'browsers_all':
            $strDiagramTitle = "Alle (erkannten) Browser";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='human' AND browser!='unknown'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT *, count(browser) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='human' AND browser!='unknown'
                             GROUP BY browser
                             ORDER BY anzahl DESC, browser ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( getBrowserString(mysql_result($SQLresult_all, $i, "browser"), ""), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'browser':
            $strInput = $_GET["input1"];
            $bValidString = false;
# prfen, ob es diese Browser schon gibt in der DB
            $strSQLstring = "SELECT browser FROM ".$bCounter_dbPrefix."visits WHERE type='human' AND browser!='unknown' GROUP BY browser";
            $SQLresult = $bCounterDB->query($strSQLstring);
            for ( $i = 0; $i < mysql_num_rows($SQLresult); $i++ ) {
                if ( $strInput === mysql_result( $SQLresult, $i, 0 ) ) {
# die Eingabe ist gltig
                    $bValidString = true; # merken
                    break; # Schleife abbrechen
                }
            }

            if ( $bValidString ) {
                $strBrowser = getBrowserString($strInput, "");
                $strDiagramTitle = "$strBrowser";


                $strSQLstring = "SELECT * FROM ".$bCounter_dbPrefix."visits WHERE browser='$strInput'";
                $iBesucherGesamt = mysql_num_rows( $bCounterDB->query($strSQLstring) );
                $strSQLstring = "SELECT browser, browser_version, count(browser) AS anzahl
                                 FROM ".$bCounter_dbPrefix."visits
                                 WHERE browser='$strInput'
                                 GROUP BY browser, browser_version
                                 ORDER BY anzahl DESC, browser_version ASC";
                $SQLresult_all = $bCounterDB->query($strSQLstring);
                for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                    $iBesucher = mysql_result($SQLresult_all, $i, "anzahl");
                    if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                    # nur die ersten 15 ausgeben bzw. nur ber 2%
                        $arrData[]   = $iBesucher;
                        $arrLegend[] = ($i+1).". ".substr( getBrowserString( $strInput, mysql_result($SQLresult_all, $i, "browser_version") ), 0, 40);
                    }else{
                        $iSonstige += $iBesucher;
                    }
                }
                if ( $iSonstige > 0 ) {
                    # den Rest zusammenfassen
                    $arrData[]   = $iSonstige;
                    $arrLegend[] = count($arrData).". Sonstige";
                }
            }else{
                $strDiagramTitle = "Falsche Eingabe";
                $arrData[] = 1;
            }
            break;
        case 'os':
            $strDiagramTitle = "Alle (erkannten) Betriebssysteme";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='human' AND os!='unknown'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT os, os_, count(browser) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='human' AND browser!='unknown'
                             GROUP BY browser
                             ORDER BY anzahl DESC, browser ASC";
            $strSQLstring = "SELECT os, os_version, count(os) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='human' AND os!='unknown'
                             GROUP BY os, os_version
                             ORDER BY anzahl DESC, os ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( getOSstring(mysql_result($SQLresult_all, $i, "os"), mysql_result($SQLresult_all, $i, "os_version") ), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'pages':
            $strDiagramTitle = "Alle Seiten (inkl. Sumas etc.)";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."data";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );
            $strSQLstring = "SELECT *, count(request_uri) AS anzahl
                             FROM ".$bCounter_dbPrefix."data
                             GROUP BY request_uri
                             ORDER BY anzahl DESC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iAngezeigteSeiten = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( mysql_result($SQLresult_all, $i, "request_uri"), 0, 40);
                    $iAngezeigteSeiten += $iBesucher;
                }
            }
            $iSonstige = $iBesucherGesamt - $iAngezeigteSeiten;
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case '404s':
            $strDiagramTitle = "404-Anfragen";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."data WHERE redirect_status='404'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );
            $strSQLstring = "SELECT *, count(request_uri) AS anzahl
                             FROM ".$bCounter_dbPrefix."data
                             WHERE redirect_status='404'
                             GROUP BY request_uri
                             ORDER BY anzahl DESC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iAngezeigteSeiten = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( mysql_result($SQLresult_all, $i, "request_uri"), 0, 40);
                    $iAngezeigteSeiten += $iBesucher;
                }
            }
            $iSonstige = $iBesucherGesamt - $iAngezeigteSeiten;
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'regions_humans':
            $strDiagramTitle = "Herkunft Besucher";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='human'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );
            $strSQLstring = "SELECT alpha2, count(alpha2) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='human'
                             GROUP BY alpha2
                             ORDER BY anzahl DESC, alpha2";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $strAlpha2   = strtolower(mysql_result($SQLresult_all, $i, "alpha2"));
                    $strLandName = $arrAlpha2name[$strAlpha2];
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( $strLandName, 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'regions_other':
            $strDiagramTitle = "Herkunft Sonstige";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type!='human'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );
            $strSQLstring = "SELECT alpha2, count(alpha2) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type!='human'
                             GROUP BY alpha2
                             ORDER BY anzahl DESC, alpha2";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $strAlpha2   = strtolower(mysql_result($SQLresult_all, $i, "alpha2"));
                    $strLandName = $arrAlpha2name[$strAlpha2];
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( $strLandName, 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'searchengines':
            $strDiagramTitle = "Suchmaschinen";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='bot'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT os, count(os) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='bot'
                             GROUP BY os
                             ORDER BY anzahl DESC, os ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( getOSstring(mysql_result($SQLresult_all, $i, "os"), "" ), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'searchengines_bots':
            $strDiagramTitle = "Einzelne Bots";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='bot'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT os, browser, count(os) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='bot'
                             GROUP BY os, browser
                             ORDER BY anzahl DESC, os ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");
                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( getOSstring(mysql_result($SQLresult_all, $i, "os"), "" )." ".getBrowserString(mysql_result($SQLresult_all, $i, "browser"), ""), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'libs':
            $strDiagramTitle = "Libraries/Programme";
            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='lib' OR type='downloader'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT os, browser, count(browser) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='lib' OR type='downloader'
                             GROUP BY os
                             ORDER BY anzahl DESC, os ASC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");

                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $strOS          = mysql_result($SQLresult_all, $i, "os");
                    $strBrowser     = mysql_result($SQLresult_all, $i, "browser");

                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( getOSstring($strOS, ""), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
        case 'hosts':
            $strDiagramTitle = "Hosts";

            $strSQLstring = "SELECT count(*) FROM ".$bCounter_dbPrefix."visits WHERE type='human'";
            $iBesucherGesamt = mysql_result( $bCounterDB->query($strSQLstring), 0, 0 );

            $strSQLstring = "SELECT top_host, count(top_host) AS anzahl
                             FROM ".$bCounter_dbPrefix."visits
                             WHERE type='human'
                             GROUP BY top_host
                             ORDER BY anzahl DESC";
            $SQLresult_all = $bCounterDB->query($strSQLstring);
            $iSonstige = 0;

            for ( $i = 0; $i < mysql_num_rows($SQLresult_all); $i++ ) {
                $iBesucher   = mysql_result($SQLresult_all, $i, "anzahl");

                if ( $i < 16 && $iBesucher/$iBesucherGesamt >= 0.02 ) {
                # nur die ersten 15 ausgeben bzw. nur ber 2%
                    $arrData[]   = $iBesucher;
                    $arrLegend[] = ($i+1).". ".substr( mysql_result($SQLresult_all, $i, "top_host"), 0, 40);
                }else{
                    $iSonstige += $iBesucher;
                }
            }
            if ( $iSonstige > 0 ) {
                # den Rest zusammenfassen
                $arrData[]   = $iSonstige;
                $arrLegend[] = count($arrData).". Sonstige";
            }
            break;
    }

    if ( count($arrData) == 0 ) {
        $arrData[] = 1;
        $arrLegend[] = "Keine Daten vorhanden";
    }
    $graph = new PieGraph(800, 300, "auto", 0, 1);

    $graph->title->Set( $strDiagramTitle );
    $graph->title->SetFont(FF_FONT1);
    $graph->legend->SetAbsPos( 10, 10 );
    $graph->SetAntiAliasing( true );


    $graph->legend->SetFrameWeight(1);
    $graph->legend->SetFillColor('ivory1');
    $graph->legend->SetShadow(false);


    $p1 = new PiePlot3D($arrData);
    $p1->SetStartAngle(90);
    $p1->SetHeight(12);
    $p1->value->SetFormat( "%.2f%%" );
    $p1->SetCenter(0.33);
    $p1->SetLegends( $arrLegend );
    $p1->SetAngle(45);
    $p1->ExplodeSlice( 0, 12 );
    $p1->SetSize( 0.5, 0.2 );
    $p1->SetLabelPos(1.1);

    $arrColors = array( 'firebrick1', 'gold', 'dodgerblue1', 'lawngreen', 'firebrick2', 'yellow1', 'maroon1', 'turquoise1' );
    $p1->SetSliceColors( $arrColors );

    $strTimestamp = date("d.m.Y H:i:s");

    $time=new Text( "Erstellt: ".$strTimestamp, 10, 280 );
    $graph->AddText($time);


    $graph->Add($p1);
    $graph->Stroke();
?>